/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentModelGroupImpl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;

public class ModelGroup
extends Particle
implements Referable {
    private String name = null;
    private boolean export = false;
    private String groupRef = null;
    private Vector modelDefs;
    private ContentModelGroup _contentModel = null;
    private Hashtable elements;
    private Order order = Order.all;
    private Schema _schema = null;

    public ModelGroup() {
        this(null);
    }

    public ModelGroup(String string, Schema schema) {
        this.name = string;
        this._schema = schema;
        this.modelDefs = new Vector();
        this.elements = new Hashtable();
        this._contentModel = new ContentModelGroupImpl();
    }

    public ModelGroup(Schema schema) {
        this(null, schema);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        if (this.elements.get(elementDecl.getName()) != null) {
            String string = "An element declaration with the given name, ";
            string = String.valueOf(string) + elementDecl.getName() + ", already exists in this scope.";
            throw new SchemaException(string);
        }
        this.modelDefs.addElement(elementDecl);
        this.elements.put(elementDecl.getName(), elementDecl);
    }

    public void addGroup(Group group) throws SchemaException {
        this._contentModel.addGroup(group);
    }

    public void addModelGroup(ModelGroup modelGroup) {
        if (!this.modelDefs.contains(modelGroup)) {
            this.modelDefs.addElement(modelGroup);
        }
    }

    public ContentModelGroup getContentModelGroup() {
        return this._contentModel;
    }

    public Enumeration getDeclarations() {
        return this.modelDefs.elements();
    }

    public boolean getExport() {
        return this.export;
    }

    public String getName() {
        return this.name;
    }

    public Order getOrder() {
        return this.order;
    }

    public ModelGroup getReference() {
        if (this.groupRef != null) {
            return this._schema.getModelGroup(this.groupRef);
        }
        return null;
    }

    public String getReferenceId() {
        if (this.name != null) {
            return "group:" + this.name;
        }
        return null;
    }

    public short getStructureType() {
        return 10;
    }

    public boolean hasReference() {
        return this.groupRef.length() != 0;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOrder(Order order) {
        if (order == null) {
            this.order = Order.all;
        }
        this.order = order;
    }

    public void setReference(String string) {
        this.groupRef = string;
    }

    public void validate() throws ValidationException {
    }
}

