/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexContentUnmarshaller;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleContentUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ComplexTypeUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private boolean allowAnnotation = true;
    private boolean foundAnnotation = false;
    private boolean foundAttributes = false;
    private boolean foundSimpleContent = false;
    private boolean foundComplexContent = false;
    private boolean foundModelGroup = false;
    private Schema _schema = null;

    public ComplexTypeUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver) throws SAXException {
        String string;
        this.setResolver(resolver);
        this._schema = schema;
        this._complexType = schema.createComplexType();
        this._complexType.useResolver(resolver);
        Object var4_4 = null;
        this._complexType.setName(attributeList.getValue("name"));
        String string2 = attributeList.getValue("mixed");
        if (string2 != null) {
            if (string2.equals("true")) {
                this._complexType.setContentType(ContentType.valueOf("mixed"));
            }
            if (string2.equals("false")) {
                this._complexType.setContentType(ContentType.valueOf("elementOnly"));
            }
        }
        if ((string = attributeList.getValue("base")) != null && string.length() > 0) {
            String string3 = attributeList.getValue("derivedBy");
            this._complexType.setDerivationMethod(string3);
            if (string3 == null || string3.length() == 0 || string3.equals("extension")) {
                XMLType xMLType = schema.getType(string);
                if (xMLType == null) {
                    this._complexType.setBase(string);
                } else {
                    this._complexType.setBaseType(xMLType);
                }
            } else {
                if (string3.equals("restrictions")) {
                    String string4 = "restrictions not yet supported for <type>.";
                    throw new SAXException(string4);
                }
                String string5 = "invalid value for derivedBy attribute of ";
                string5 = String.valueOf(string5) + "<type>: " + string3;
                throw new SAXException(string5);
            }
        }
        this._complexType.setBlock(attributeList.getValue("block"));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "complexType";
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("attribute".equals(string)) {
            AttributeDecl attributeDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attributeDecl);
        } else if ("attributeGroup".equals(string)) {
            AttributeGroupReference attributeGroupReference = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attributeGroupReference);
        } else if ("element".equals(string)) {
            ElementDecl elementDecl = ((ElementUnmarshaller)this.unmarshaller).getElement();
            this._complexType.addElementDecl(elementDecl);
        } else if (string.equals("group")) {
            ModelGroup modelGroup = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(modelGroup);
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        } else if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(annotation);
        }
        this.unmarshaller = null;
    }

    public ComplexType getComplexType() {
        return this._complexType;
    }

    public Object getObject() {
        return this.getComplexType();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("attribute".equals(string)) {
            if (this.foundComplexContent) {
                this.error("an attribute definition cannot appear as a child of 'complexType' if 'complexContent' also exists");
            }
            if (this.foundSimpleContent) {
                this.error("an attribute definition cannot appear as a child of 'complexType' if 'simpleContent' also exists");
            }
            this.foundAttributes = true;
            this.allowAnnotation = false;
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if ("attributeGroup".equals(string)) {
            if (attributeList.getValue("ref") == null) {
                this.error("A 'complexType' may contain referring attributeGroups, but not defining ones.");
            }
            if (this.foundComplexContent) {
                this.error("an attributeGroup reference cannot appear as a child of 'complexType' if 'complexContent' also exists");
            }
            if (this.foundSimpleContent) {
                this.error("an attributeGroup reference cannot appear as a child of 'complexType' if 'simpleContent' also exists");
            }
            this.foundAttributes = true;
            this.allowAnnotation = false;
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeList);
        } else if ("simpleContent".equals(string)) {
            if (this.foundAttributes) {
                this.error("'simpleContent' and attribute definitions cannot both appear as children of 'complexType' at the same time.");
            }
            if (this.foundComplexContent) {
                this.error("'simpleContent' and 'complexContent' cannot both appear as children of 'complexType'.");
            }
            if (this.foundSimpleContent) {
                this.error("Only one (1) 'simpleContent' may appear as a child of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'simpleContent' cannot appear as a child of 'complexType' if 'all', 'sequence', 'choice' or 'group' also exist");
            }
            this.foundSimpleContent = true;
            this.allowAnnotation = false;
            this._complexType.setSimpleContent(true);
            this.unmarshaller = new SimpleContentUnmarshaller(this._complexType, attributeList, this.getResolver());
        } else if ("complexContent".equals(string)) {
            if (this.foundAttributes) {
                this.error("'complexContent' and attribute definitions cannot both appear as children of 'complexType' at the same time.");
            }
            if (this.foundSimpleContent) {
                this.error("'simpleContent' and 'complexContent' cannot both appear as children of 'complexType'.");
            }
            if (this.foundComplexContent) {
                this.error("Only one (1) 'complexContent' may appear as a child of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'complexContent' cannot appear as a child of 'complexType' if 'all', 'sequence', 'choice' or 'group' also exist");
            }
            this.foundComplexContent = true;
            this.allowAnnotation = false;
            this._complexType.setComplexContent(true);
            this.unmarshaller = new ComplexContentUnmarshaller(this._complexType, attributeList, this.getResolver());
        } else if (string.equals("group")) {
            if (this.foundAttributes) {
                this.error("'" + string + "' must appear before any attribute " + "definitions when a child of 'complexType'.");
            }
            if (this.foundComplexContent) {
                this.error("'" + string + "' and 'complexContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundSimpleContent) {
                this.error("'" + string + "' and 'simpleContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + string + "' cannot appear as a child of 'complexType' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.allowAnnotation = false;
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            if (this.foundAttributes) {
                this.error("'" + string + "' must appear before any attribute " + "definitions when a child of 'complexType'.");
            }
            if (this.foundComplexContent) {
                this.error("'" + string + "' and 'complexContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundSimpleContent) {
                this.error("'" + string + "' and 'simpleContent' cannot both " + "appear as children of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + string + "' cannot appear as a child of 'complexType' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.allowAnnotation = false;
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeList, this.getResolver());
        } else if (string.equals("annotation")) {
            if (this.allowAnnotation) {
                this.unmarshaller = new AnnotationUnmarshaller(attributeList);
                this.allowAnnotation = false;
                this.foundAnnotation = true;
            } else {
                if (this.foundAnnotation) {
                    this.error("Only one (1) annotation may appear as a child of 'complexType' elements");
                }
                this.error("An annotation must appear as the first child of 'complexType' elements.");
            }
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }
}

