/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class GroupUnmarshaller
extends SaxUnmarshaller {
    private static final int ALL = 1;
    private static final int CHOICE = 2;
    private static final int MODEL_GROUP = 3;
    private static final int SEQUENCE = 4;
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private Group _group = null;
    private Schema _schema = null;
    private String _element = "group";

    public GroupUnmarshaller(Schema schema, String string, AttributeList attributeList, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._group = new Group();
        String string2 = null;
        if ("group".equals(string)) {
            this._group.setName(attributeList.getValue("name"));
            this._group.setIsModelGroupDefinition(true);
        } else {
            this._group.setIsModelGroupDefinition(false);
            if ("sequence".equals(string)) {
                this._group.setOrder(Order.seq);
            } else if ("choice".equals(string)) {
                this._group.setOrder(Order.choice);
            } else if ("all".equals(string)) {
                this._group.setOrder(Order.all);
            } else {
                String string3 = "Invalid group element name: '" + string + "'";
                throw new IllegalArgumentException(string3);
            }
        }
        this._element = string;
        string2 = attributeList.getValue("maxOccurs");
        if (string2 != null) {
            if (MAX_OCCURS_WILDCARD.equals(string2)) {
                string2 = "-1";
            }
            int n = SaxUnmarshaller.toInt(string2);
            this._group.setMaxOccurs(n);
        }
        if ((string2 = attributeList.getValue("minOccurs")) != null) {
            this._group.setMinOccurs(SaxUnmarshaller.toInt(string2));
        }
        this._group.setId(attributeList.getValue("id"));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return this._element;
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !string.equals(this.unmarshaller.elementName())) {
            String string2 = "missing end element for ";
            string2 = String.valueOf(string2) + this.unmarshaller.elementName();
            throw new SAXException(string2);
        }
        this.unmarshaller.finish();
        if ("element".equals(string)) {
            ElementDecl elementDecl = ((ElementUnmarshaller)this.unmarshaller).getElement();
            this._group.addElementDecl(elementDecl);
        } else if (string.equals("group")) {
            ModelGroup modelGroup = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._group.addGroup(modelGroup);
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._group.addGroup(group);
        }
        this.unmarshaller = null;
    }

    public Group getGroup() {
        return this._group;
    }

    public Object getObject() {
        return this.getGroup();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("element".equals(string)) {
            this.unmarshaller = new ElementUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if (string.equals("group")) {
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeList, this.getResolver());
        } else {
            StringBuffer stringBuffer = new StringBuffer("illegal element <");
            stringBuffer.append(string);
            stringBuffer.append("> found in <group>.");
            throw new SAXException(stringBuffer.toString());
        }
    }
}

