/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.util.List;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLNaming;

public class XMLClassDescriptorImpl
extends Validator
implements XMLClassDescriptor {
    private static final short ALL = 0;
    private static final short CHOICE = 1;
    private static final short SEQUENCE = 2;
    private static final String NULL_CLASS_ERR = "The Class passed as an argument to the constructor of XMLClassDescriptorImpl may not be null.";
    private static XMLNaming _naming = null;
    private Class _class = null;
    private String _className = null;
    private List attributeDescriptors = new List(7);
    private XMLFieldDescriptor contentDescriptor = null;
    private TypeValidator validator = null;
    private List elementDescriptors = new List(7);
    private String nsPrefix = null;
    private String nsURI = null;
    private String _xmlName;
    private XMLClassDescriptor _extends;
    private FieldDescriptor _identity;
    private AccessMode _accessMode;
    private boolean _introspected = false;
    private short _compositor = 0;

    static {
        _naming = XMLNaming.getInstance();
    }

    protected XMLClassDescriptorImpl() {
    }

    public XMLClassDescriptorImpl(Class clazz) {
        this();
        if (clazz == null) {
            throw new IllegalArgumentException(NULL_CLASS_ERR);
        }
        this._class = clazz;
        this.setXMLName(null);
    }

    public XMLClassDescriptorImpl(Class clazz, String string) {
        this();
        if (clazz == null) {
            throw new IllegalArgumentException(NULL_CLASS_ERR);
        }
        this._class = clazz;
        this.setXMLName(string);
    }

    public void addFieldDescriptor(XMLFieldDescriptor xMLFieldDescriptor) {
        xMLFieldDescriptor.setContainingClassDescriptor(this);
        NodeType nodeType = xMLFieldDescriptor.getNodeType();
        switch (nodeType.getType()) {
            case 0: {
                this.attributeDescriptors.add(xMLFieldDescriptor);
                break;
            }
            case 2: {
                this.contentDescriptor = xMLFieldDescriptor;
                break;
            }
            default: {
                this.elementDescriptors.add(xMLFieldDescriptor);
            }
        }
    }

    public AccessMode getAccessMode() {
        return this._accessMode;
    }

    public XMLFieldDescriptor[] getAttributeDescriptors() {
        Object[] objectArray = new XMLFieldDescriptor[this.attributeDescriptors.size()];
        this.attributeDescriptors.toArray(objectArray);
        return objectArray;
    }

    public XMLFieldDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }

    public XMLFieldDescriptor[] getElementDescriptors() {
        Object[] objectArray = new XMLFieldDescriptor[this.elementDescriptors.size()];
        this.elementDescriptors.toArray(objectArray);
        return objectArray;
    }

    public ClassDescriptor getExtends() {
        return this._extends;
    }

    public XMLFieldDescriptor getFieldDescriptor(String string, NodeType nodeType) {
        int n;
        XMLFieldDescriptor xMLFieldDescriptor;
        boolean bl;
        boolean bl2 = bl = nodeType == null || this._introspected;
        if (bl || nodeType == NodeType.Element) {
            xMLFieldDescriptor = null;
            n = 0;
            while (n < this.elementDescriptors.size()) {
                xMLFieldDescriptor = (XMLFieldDescriptor)this.elementDescriptors.get(n);
                if (xMLFieldDescriptor != null && xMLFieldDescriptor.matches(string)) {
                    return xMLFieldDescriptor;
                }
                ++n;
            }
        }
        if (bl || nodeType == NodeType.Attribute) {
            xMLFieldDescriptor = null;
            n = 0;
            while (n < this.attributeDescriptors.size()) {
                xMLFieldDescriptor = (XMLFieldDescriptor)this.attributeDescriptors.get(n);
                if (xMLFieldDescriptor != null && xMLFieldDescriptor.matches(string)) {
                    return xMLFieldDescriptor;
                }
                ++n;
            }
        }
        return null;
    }

    public FieldDescriptor[] getFields() {
        int n = this.attributeDescriptors.size();
        n += this.elementDescriptors.size();
        if (this.contentDescriptor != null) {
            ++n;
        }
        FieldDescriptor[] fieldDescriptorArray = new FieldDescriptor[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.attributeDescriptors.size()) {
            fieldDescriptorArray[n2++] = (FieldDescriptor)this.attributeDescriptors.get(n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.elementDescriptors.size()) {
            fieldDescriptorArray[n2++] = (FieldDescriptor)this.elementDescriptors.get(n4);
            ++n4;
        }
        if (this.contentDescriptor != null) {
            fieldDescriptorArray[n2] = this.contentDescriptor;
        }
        return fieldDescriptorArray;
    }

    public FieldDescriptor getIdentity() {
        return this._identity;
    }

    public Class getJavaClass() {
        return this._class;
    }

    public String getNameSpacePrefix() {
        return this.nsPrefix;
    }

    public String getNameSpaceURI() {
        return this.nsURI;
    }

    public TypeValidator getValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        return this;
    }

    public String getXMLName() {
        return this._xmlName;
    }

    public void removeFieldDescriptor(XMLFieldDescriptor xMLFieldDescriptor) {
        if (xMLFieldDescriptor == null) {
            return;
        }
        NodeType nodeType = xMLFieldDescriptor.getNodeType();
        switch (nodeType.getType()) {
            case 0: {
                this.attributeDescriptors.remove(xMLFieldDescriptor);
                break;
            }
            case 2: {
                if (this.contentDescriptor != xMLFieldDescriptor) break;
                this.contentDescriptor = null;
                break;
            }
            default: {
                this.elementDescriptors.remove(xMLFieldDescriptor);
            }
        }
    }

    public void setCompositorAsAll() {
        this._compositor = 0;
    }

    public void setCompositorAsChoice() {
        this._compositor = 1;
    }

    public void setCompositorAsSequence() {
        this._compositor = (short)2;
    }

    public void setExtends(XMLClassDescriptor xMLClassDescriptor) {
        int n;
        FieldDescriptor[] fieldDescriptorArray = null;
        if (this._extends != null) {
            this.sortDescriptors();
            fieldDescriptorArray = this._extends.getFields();
            n = 0;
            while (n < fieldDescriptorArray.length) {
                this.removeFieldDescriptor((XMLFieldDescriptor)fieldDescriptorArray[n]);
                ++n;
            }
        }
        this._extends = xMLClassDescriptor;
        if (this._extends != null) {
            fieldDescriptorArray = xMLClassDescriptor.getFields();
            n = 0;
            while (n < fieldDescriptorArray.length) {
                this.addFieldDescriptor((XMLFieldDescriptor)fieldDescriptorArray[n]);
                ++n;
            }
        }
    }

    protected void setExtendsWithoutFlatten(XMLClassDescriptor xMLClassDescriptor) {
        this._extends = xMLClassDescriptor;
    }

    public void setIdentity(XMLFieldDescriptor xMLFieldDescriptor) {
        if (xMLFieldDescriptor != null && !this.attributeDescriptors.contains(xMLFieldDescriptor) && !this.elementDescriptors.contains(xMLFieldDescriptor)) {
            this.addFieldDescriptor(xMLFieldDescriptor);
        }
        this._identity = xMLFieldDescriptor;
    }

    protected void setIntrospected(boolean bl) {
        this._introspected = bl;
    }

    protected void setJavaClass(Class clazz) {
        this._class = clazz;
    }

    public void setNameSpacePrefix(String string) {
        this.nsPrefix = string;
    }

    public void setNameSpaceURI(String string) {
        this.nsURI = string;
    }

    public void setXMLName(String string) {
        if (string == null) {
            if (this._class != null) {
                this._xmlName = this.toXMLName(this._class.getName());
            }
        } else {
            this._xmlName = string;
        }
    }

    public void sortDescriptors() {
        XMLFieldDescriptor xMLFieldDescriptor = null;
        Object var2_2 = null;
        List list = new List(3);
        int n = 0;
        while (n < this.attributeDescriptors.size()) {
            xMLFieldDescriptor = (XMLFieldDescriptor)this.attributeDescriptors.get(n);
            switch (xMLFieldDescriptor.getNodeType().getType()) {
                case 1: {
                    this.elementDescriptors.add(xMLFieldDescriptor);
                    list.add(xMLFieldDescriptor);
                    break;
                }
                case 2: {
                    list.add(xMLFieldDescriptor);
                    break;
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            this.attributeDescriptors.remove(list.get(n2));
            ++n2;
        }
        list.clear();
        int n3 = 0;
        while (n3 < this.elementDescriptors.size()) {
            xMLFieldDescriptor = (XMLFieldDescriptor)this.elementDescriptors.get(n3);
            switch (xMLFieldDescriptor.getNodeType().getType()) {
                case 0: {
                    this.attributeDescriptors.add(xMLFieldDescriptor);
                    list.add(xMLFieldDescriptor);
                    break;
                }
                case 2: {
                    list.add(xMLFieldDescriptor);
                    break;
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < list.size()) {
            this.elementDescriptors.remove(list.get(n4));
            ++n4;
        }
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "; descriptor for class: ";
        string = this._class != null ? String.valueOf(string) + this._class.getName() : String.valueOf(string) + "[null]";
        string = String.valueOf(string) + "; xml name: " + this._xmlName;
        return string;
    }

    protected String toXMLName(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        return _naming.toXMLName(string2);
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    public void validate(Object object, ClassDescriptorResolver classDescriptorResolver) throws ValidationException {
        if (object == null) {
            throw new ValidationException("Cannot validate a null object.");
        }
        if (!this.getJavaClass().isAssignableFrom(object.getClass())) {
            String string = "The given object is not an instance of the class described by this ClassDecriptor.";
            throw new ValidationException(string);
        }
        switch (this._compositor) {
            case 1: {
                FieldValidator fieldValidator;
                Object object2;
                XMLFieldDescriptor xMLFieldDescriptor;
                boolean bl = false;
                String string = null;
                int n = 0;
                while (n < this.elementDescriptors.size()) {
                    xMLFieldDescriptor = (XMLFieldDescriptor)this.elementDescriptors.get(n);
                    object2 = xMLFieldDescriptor.getHandler();
                    if (object2.getValue(object) != null) {
                        Object object3;
                        if (bl) {
                            object3 = "The element '" + xMLFieldDescriptor.getXMLName();
                            object3 = String.valueOf(object3) + "' cannot exist at the same time that ";
                            object3 = String.valueOf(object3) + "element '" + string + "' also exists.";
                            throw new ValidationException((String)object3);
                        }
                        bl = true;
                        string = xMLFieldDescriptor.getXMLName();
                        object3 = xMLFieldDescriptor.getValidator();
                        if (object3 != null) {
                            ((FieldValidator)object3).validate(object, classDescriptorResolver);
                        }
                    }
                    ++n;
                }
                n = 0;
                while (n < this.attributeDescriptors.size()) {
                    xMLFieldDescriptor = (XMLFieldDescriptor)this.attributeDescriptors.get(n);
                    object2 = xMLFieldDescriptor.getValidator();
                    if (object2 != null) {
                        ((FieldValidator)object2).validate(object, classDescriptorResolver);
                    }
                    ++n;
                }
                if (this.contentDescriptor == null || (fieldValidator = this.contentDescriptor.getValidator()) == null) break;
                fieldValidator.validate(object, classDescriptorResolver);
                break;
            }
            default: {
                FieldValidator fieldValidator;
                FieldValidator fieldValidator2;
                XMLFieldDescriptor xMLFieldDescriptor;
                int n = 0;
                while (n < this.elementDescriptors.size()) {
                    xMLFieldDescriptor = (XMLFieldDescriptor)this.elementDescriptors.get(n);
                    fieldValidator2 = xMLFieldDescriptor.getValidator();
                    if (fieldValidator2 != null) {
                        fieldValidator2.validate(object, classDescriptorResolver);
                    }
                    ++n;
                }
                n = 0;
                while (n < this.attributeDescriptors.size()) {
                    xMLFieldDescriptor = (XMLFieldDescriptor)this.attributeDescriptors.get(n);
                    fieldValidator2 = xMLFieldDescriptor.getValidator();
                    if (fieldValidator2 != null) {
                        fieldValidator2.validate(object, classDescriptorResolver);
                    }
                    ++n;
                }
                if (this.contentDescriptor == null || (fieldValidator = this.contentDescriptor.getValidator()) == null) break;
                fieldValidator.validate(object, classDescriptorResolver);
            }
        }
    }
}

