/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import java.math.BigDecimal;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;

public class DecimalValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private BigDecimal min = null;
    private BigDecimal max = null;
    private Integer precision = null;
    private Integer scale = null;

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public void setMaxExclusive(BigDecimal bigDecimal) {
        this.useMax = true;
        this.max = bigDecimal.subtract(new BigDecimal(1.0));
    }

    public void setMaxInclusive(BigDecimal bigDecimal) {
        this.useMax = true;
        this.max = bigDecimal;
    }

    public void setMinExclusive(BigDecimal bigDecimal) {
        this.useMin = true;
        this.min = bigDecimal.add(new BigDecimal(1.0));
    }

    public void setMinInclusive(BigDecimal bigDecimal) {
        this.useMin = true;
        this.min = bigDecimal;
    }

    public void setPrecision(int n) {
        this.precision = new Integer(n);
    }

    public void setScale(int n) {
        this.scale = new Integer(n);
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "decimalValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(object.toString());
        }
        catch (Exception exception) {
            String string = "Expecting a decimal, received instead: ";
            string = String.valueOf(string) + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(bigDecimal);
    }

    public void validate(BigDecimal bigDecimal) throws ValidationException {
        int n;
        if (this.useMin && bigDecimal.compareTo(this.min) == -1) {
            String string = String.valueOf(String.valueOf(bigDecimal)) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this.min;
            throw new ValidationException(string);
        }
        if (this.useMax && bigDecimal.compareTo(this.max) == 1) {
            String string = String.valueOf(String.valueOf(bigDecimal)) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this.max;
            throw new ValidationException(string);
        }
        if (this.scale != null && bigDecimal.scale() > this.scale) {
            String string = "the SCALE of " + bigDecimal + ": " + bigDecimal.scale() + " must be lower";
            string = String.valueOf(string) + " than the value of " + this.scale;
            throw new ValidationException(string);
        }
        if (this.precision != null && this.precision < this.scale) {
            String string = "the SCALE of " + bigDecimal + ": " + this.scale + " must be lower";
            string = String.valueOf(string) + " than the value of the PRECISION :" + this.precision;
            throw new ValidationException(string);
        }
        String string = bigDecimal.toString();
        int n2 = n = string.indexOf(".") != -1 ? string.toCharArray().length - 1 : string.toCharArray().length;
        if (this.precision != null && this.precision < n) {
            String string2 = "the number of digits of " + bigDecimal + " must be lower";
            string2 = String.valueOf(string2) + " than the value of " + this.precision;
            throw new ValidationException(string2);
        }
        string = null;
    }
}

