/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class StringValidator
extends PatternValidator
implements TypeValidator {
    private String fixed = null;
    private boolean required = false;
    private int _length = 0;
    private int minLength = 0;
    private int maxLength = -1;
    private String _whiteSpace = "preserved";

    public String normalize(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            switch (cArray[n2]) {
                case '\t': 
                case '\n': 
                case '\r': {
                    cArray[n2] = 32;
                    break;
                }
            }
            ++n2;
        }
        if (this._whiteSpace.equals("collapse")) {
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n - 1) {
                if (cArray[n4] == ' ') {
                    cArray2[n3] = cArray[n4];
                    ++n3;
                    int n5 = n4 + 1;
                    while (cArray[n5] == ' ') {
                        ++n5;
                    }
                    n4 = n5;
                }
                cArray2[n3] = cArray[n4];
                ++n3;
                ++n4;
            }
            if (cArray[n4] != ' ') {
                cArray2[n3] = cArray[n4];
            }
            n = ++n3;
            cArray = cArray2;
        }
        return new String(cArray, 0, n);
    }

    public void setFixedValue(String string) {
        this.fixed = string;
    }

    public void setLength(int n) {
        this._length = n;
        this.setMaxLength(n);
        this.setMinLength(n);
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setWhiteSpace(String string) {
        if (string.equals("preserved")) {
            this._whiteSpace = string;
        } else if (string.equals("replace")) {
            this._whiteSpace = string;
        } else if (string.equals("collapse")) {
            this._whiteSpace = string;
        } else {
            System.out.println("Warning : " + string + " is a bad entry for the whiteSpace value");
            this._whiteSpace = string;
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null && this.required) {
            String string = "this is a required field and cannot be null.";
            throw new ValidationException(string);
        }
        this.validate(object.toString());
    }

    public void validate(String string) throws ValidationException {
        if (string == null) {
            if (this.required) {
                String string2 = "this is a required field and cannot be null.";
                throw new ValidationException(string2);
            }
        } else {
            if (this.fixed != null && !this.fixed.equals(string)) {
                String string3 = "strings of this type must be equal to the fixed value of " + this.fixed;
                throw new ValidationException(string3);
            }
            int n = string.length();
            if (this._length > 0 && n != this._length) {
                String string4 = "strings of this type must have a length of " + this._length;
                throw new ValidationException(string4);
            }
            if (this.minLength > 0 && n < this.minLength) {
                String string5 = "strings of this type must have a minimum length of " + this.minLength;
                throw new ValidationException(string5);
            }
            if (this.maxLength >= 0 && n > this.maxLength) {
                String string6 = "strings of this type must have a maximum length of " + this.maxLength;
                throw new ValidationException(string6);
            }
            if (this.hasPattern()) {
                super.validate(string);
            }
            if (!this._whiteSpace.equals("preserved")) {
                this.normalize(string);
            }
        }
    }
}

