/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.types.TimeDuration;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;

public class TimeDurationValidator
implements TypeValidator {
    private TimeDuration _maxInclusive;
    private TimeDuration _maxExclusive;
    private TimeDuration _minInclusive;
    private TimeDuration _minExclusive;

    public void setMaxExclusive(TimeDuration timeDuration) {
        this._maxExclusive = timeDuration;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(TimeDuration timeDuration) {
        this._maxInclusive = timeDuration;
        this._maxExclusive = null;
    }

    public void setMinExclusive(TimeDuration timeDuration) {
        this._minExclusive = timeDuration;
        this._minInclusive = null;
    }

    public void setMinInclusive(TimeDuration timeDuration) {
        this._minInclusive = timeDuration;
        this._minExclusive = null;
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "TimeDurationValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        TimeDuration timeDuration = null;
        try {
            timeDuration = TimeDuration.parse(object.toString());
        }
        catch (Exception exception) {
            String string = "Expecting a TimeDuration, received instead: ";
            string = String.valueOf(string) + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(timeDuration);
    }

    public void validate(TimeDuration timeDuration) throws ValidationException {
        boolean bl;
        boolean bl2 = this._minInclusive != null;
        boolean bl3 = this._minExclusive != null;
        boolean bl4 = this._maxInclusive != null;
        boolean bl5 = bl = this._maxExclusive != null;
        if (bl3 && bl2) {
            throw new ValidationException("both minInclusive and minExclusiveare set up");
        }
        if (bl && bl4) {
            throw new ValidationException("both maxInclusive and maxExclusiveare set up");
        }
        if (bl2 && this._minInclusive.isGreater(timeDuration)) {
            String string = String.valueOf(String.valueOf(timeDuration)) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minInclusive;
            throw new ValidationException(string);
        }
        if (bl3 && (this._minExclusive.isGreater(timeDuration) || timeDuration.equals(this._minExclusive))) {
            String string = String.valueOf(String.valueOf(timeDuration)) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minExclusive;
            throw new ValidationException(string);
        }
        if (bl4 && timeDuration.isGreater(this._maxInclusive)) {
            String string = String.valueOf(String.valueOf(timeDuration)) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxInclusive;
            throw new ValidationException(string);
        }
        if (bl && (timeDuration.isGreater(this._maxExclusive) || timeDuration.equals(this._maxExclusive))) {
            String string = String.valueOf(String.valueOf(timeDuration)) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxExclusive;
            throw new ValidationException(string);
        }
    }
}

