/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.types.Time;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;

public class TimeValidator
implements TypeValidator {
    private Time _maxInclusive;
    private Time _maxExclusive;
    private Time _minInclusive;
    private Time _minExclusive;

    public void setMaxExclusive(Time time) {
        this._maxExclusive = time;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(Time time) {
        this._maxInclusive = time;
        this._maxExclusive = null;
    }

    public void setMinExclusive(Time time) {
        this._minExclusive = time;
        this._minInclusive = null;
    }

    public void setMinInclusive(Time time) {
        this._minInclusive = time;
        this._minExclusive = null;
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "TimeValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        Time time = null;
        try {
            time = (Time)object;
        }
        catch (Exception exception) {
            String string = String.valueOf(exception.toString()) + "\nExpecting a Time, received instead: ";
            string = String.valueOf(string) + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(time);
    }

    public void validate(Time time) throws ValidationException {
        boolean bl;
        boolean bl2 = this._minInclusive != null;
        boolean bl3 = this._minExclusive != null;
        boolean bl4 = this._maxInclusive != null;
        boolean bl5 = bl = this._maxExclusive != null;
        if (bl3 && bl2) {
            throw new ValidationException("both minInclusive and minExclusiveare set up");
        }
        if (bl && bl4) {
            throw new ValidationException("both maxInclusive and maxExclusiveare set up");
        }
        if (bl2 && this._minInclusive.isGreater(time)) {
            String string = String.valueOf(String.valueOf(time)) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minInclusive;
            throw new ValidationException(string);
        }
        if (bl3 && (this._minExclusive.isGreater(time) || time.equals(this._minExclusive))) {
            String string = String.valueOf(String.valueOf(time)) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minExclusive;
            throw new ValidationException(string);
        }
        if (bl4 && time.isGreater(this._maxInclusive)) {
            String string = String.valueOf(String.valueOf(time)) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxInclusive;
            throw new ValidationException(string);
        }
        if (bl && (time.isGreater(this._maxExclusive) || time.equals(this._maxExclusive))) {
            String string = String.valueOf(String.valueOf(time)) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxExclusive;
            throw new ValidationException(string);
        }
    }
}

