/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JClass
extends JType {
    private static final String DEFAULT_HEADER = "$Id$";
    private static final String version = "$Revision$ $Date$";
    private JComment header = null;
    private Vector imports = null;
    private String superClass = null;
    private JNamedMap fields = null;
    private Vector constructors = null;
    private Vector interfaces = null;
    private JDocComment jdc = null;
    private Vector methods = null;
    private JModifiers modifiers = null;
    private String packageName = null;
    private Vector packageClasses = null;
    private JSourceCode _staticInitializer = new JSourceCode();

    public JClass(String string) throws IllegalArgumentException {
        super(string);
        if (!JClass.isValidClassName(string)) {
            String string2 = this.getLocalName();
            String string3 = "'" + string2 + "' is ";
            string3 = JNaming.isKeyword(string2) ? String.valueOf(string3) + "a reserved word and may not be used as  a class name." : String.valueOf(string3) + "not a valid Java identifier.";
            throw new IllegalArgumentException(string3);
        }
        this.packageName = JClass.getPackageFromClassName(string);
        this.imports = new Vector();
        this.interfaces = new Vector();
        this.jdc = new JDocComment();
        this.constructors = new Vector();
        this.fields = new JNamedMap();
        this.methods = new Vector();
        this.modifiers = new JModifiers();
        this.packageClasses = new Vector();
        this.jdc.addDescriptor(JDocDescriptor.createVersionDesc(version));
    }

    public void addConstructor(JConstructor jConstructor) throws IllegalArgumentException {
        if (jConstructor == null) {
            throw new IllegalArgumentException("Constructors cannot be null");
        }
        if (jConstructor.getDeclaringClass() != this) {
            String string = "The given JConstructor was not created ";
            string = String.valueOf(string) + "by this JClass";
            throw new IllegalArgumentException(string);
        }
        this.constructors.addElement(jConstructor);
    }

    public void addField(JField jField) throws IllegalArgumentException {
        if (jField == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String string = jField.getName();
        if (this.fields.get(string) != null) {
            String string2 = "duplicate name found: " + string;
            throw new IllegalArgumentException(string2);
        }
        this.fields.put(string, jField);
        JType jType = jField.getType();
        while (jType.isArray()) {
            jType = jType.getComponentType();
        }
        if (!jType.isPrimitive()) {
            this.addImport(((JClass)jType).getName());
        }
    }

    public void addImport(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        String string2 = JClass.getPackageFromClassName(string);
        if (string2 != null) {
            if (string2.equals(this.packageName)) {
                return;
            }
            if (string2.equals("java.lang")) {
                return;
            }
            int n = 0;
            while (n < this.imports.size()) {
                String string3 = (String)this.imports.elementAt(n);
                if (string3.equals(string)) {
                    return;
                }
                if (string3.compareTo(string) > 0) {
                    this.imports.insertElementAt(string, n);
                    return;
                }
                ++n;
            }
            this.imports.addElement(string);
        }
    }

    public void addInterface(String string) {
        if (!this.interfaces.contains(string)) {
            this.interfaces.addElement(string);
        }
    }

    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember instanceof JField) {
            this.addField((JField)jMember);
        } else {
            this.addMethod((JMethod)jMember);
        }
    }

    public void addMethod(JMethod jMethod) throws IllegalArgumentException {
        Object object;
        if (jMethod == null) {
            throw new IllegalArgumentException("Class methods cannot be null");
        }
        boolean bl = false;
        boolean bl2 = false;
        JModifiers jModifiers = jMethod.getModifiers();
        if (jModifiers.isAbstract()) {
            this.modifiers.setAbstract(true);
        }
        int n = 0;
        while (n < this.methods.size()) {
            object = (JMethod)this.methods.elementAt(n);
            if (((JMethod)object).getModifiers().isPrivate() && !jModifiers.isPrivate()) {
                this.methods.insertElementAt(jMethod, n);
                bl = true;
                break;
            }
            if (jMethod.getName().compareTo(((JMethod)object).getName()) < 0) {
                this.methods.insertElementAt(jMethod, n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.methods.addElement(jMethod);
        }
        object = jMethod.getParameterClassNames();
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            this.addImport((String)object[n2]);
            ++n2;
        }
        JType jType = jMethod.getReturnType();
        if (jType != null) {
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (!jType.isPrimitive()) {
                this.addImport(((JClass)jType).getName());
            }
        }
        JClass[] jClassArray = jMethod.getExceptions();
        int n3 = 0;
        while (n3 < jClassArray.length) {
            this.addImport(jClassArray[n3].getName());
            ++n3;
        }
    }

    public void addMethods(JMethod[] jMethodArray) throws IllegalArgumentException {
        int n = 0;
        while (n < jMethodArray.length) {
            this.addMethod(jMethodArray[n]);
            ++n;
        }
    }

    public JConstructor createConstructor() {
        return new JConstructor(this);
    }

    public JConstructor getConstructor(int n) {
        return (JConstructor)this.constructors.elementAt(n);
    }

    public JConstructor[] getConstructors() {
        int n = this.constructors.size();
        JConstructor[] jConstructorArray = new JConstructor[n];
        int n2 = 0;
        while (n2 < this.constructors.size()) {
            jConstructorArray[n2] = (JConstructor)this.constructors.elementAt(n2);
            ++n2;
        }
        return jConstructorArray;
    }

    public JField getField(String string) {
        return (JField)this.fields.get(string);
    }

    public JField[] getFields() {
        int n = this.fields.size();
        JField[] jFieldArray = new JField[n];
        int n2 = 0;
        while (n2 < n) {
            jFieldArray[n2] = (JField)this.fields.get(n2);
            ++n2;
        }
        return jFieldArray;
    }

    public String getFilename(String string) {
        File file;
        String string2 = String.valueOf(this.getLocalName()) + ".java";
        String string3 = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            string3 = this.packageName.replace('.', File.separatorChar);
        }
        if (!(file = string == null ? new File(string3) : new File(string, string3)).exists()) {
            file.mkdirs();
        }
        if (file.toString().length() > 0) {
            string2 = String.valueOf(file.toString()) + File.separator + string2;
        }
        return string2;
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JMethod getMethod(int n) {
        return (JMethod)this.methods.elementAt(n);
    }

    public JMethod getMethod(String string, int n) {
        int n2 = n;
        while (n2 < this.methods.size()) {
            JMethod jMethod = (JMethod)this.methods.elementAt(n2);
            if (jMethod.getName().equals(string)) {
                return jMethod;
            }
            ++n2;
        }
        return null;
    }

    public JMethod[] getMethods() {
        int n = this.methods.size();
        JMethod[] jMethodArray = new JMethod[n];
        int n2 = 0;
        while (n2 < this.methods.size()) {
            jMethodArray[n2] = (JMethod)this.methods.elementAt(n2);
            ++n2;
        }
        return jMethodArray;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getName(boolean bl) {
        int n;
        String string = super.getName();
        if (bl && (n = string.lastIndexOf(".")) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private static String getPackageFromClassName(String string) {
        int n = -1;
        n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public JSourceCode getStaticInitializationCode() {
        return this._staticInitializer;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public static boolean isValidClassName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return JNaming.isValidJavaIdentifier(string);
    }

    public void print() {
        this.print(null, null);
    }

    public void print(String string, String string2) {
        Object object;
        int n;
        String string3 = this.getLocalName();
        String string4 = this.getFilename(string);
        File file = new File(string4);
        JSourceWriter jSourceWriter = null;
        try {
            jSourceWriter = new JSourceWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            System.out.println("unable to create class file: " + string4);
            return;
        }
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        jSourceWriter.setLineSeparator(string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.header != null) {
            this.header.print(jSourceWriter);
        } else {
            jSourceWriter.writeln("/*");
            jSourceWriter.writeln(" * $Id$");
            jSourceWriter.writeln("*/");
        }
        jSourceWriter.writeln();
        jSourceWriter.flush();
        if (this.packageName != null && this.packageName.length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("package ");
            stringBuffer.append(this.packageName);
            stringBuffer.append(';');
            jSourceWriter.writeln(stringBuffer.toString());
            jSourceWriter.writeln();
        }
        jSourceWriter.writeln("  //---------------------------------/");
        jSourceWriter.writeln(" //- Imported classes and packages -/");
        jSourceWriter.writeln("//---------------------------------/");
        jSourceWriter.writeln();
        int n2 = 0;
        while (n2 < this.imports.size()) {
            jSourceWriter.write("import ");
            jSourceWriter.write(this.imports.elementAt(n2));
            jSourceWriter.writeln(';');
            ++n2;
        }
        jSourceWriter.writeln();
        this.jdc.print(jSourceWriter);
        stringBuffer.setLength(0);
        if (this.modifiers.isPrivate()) {
            stringBuffer.append("private ");
        } else if (this.modifiers.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.modifiers.isAbstract()) {
            stringBuffer.append("abstract ");
        }
        stringBuffer.append("class ");
        stringBuffer.append(this.getLocalName());
        stringBuffer.append(' ');
        if (this.superClass != null) {
            stringBuffer.append("extends ");
            stringBuffer.append(this.superClass);
            stringBuffer.append(' ');
        }
        if (this.interfaces.size() > 0) {
            n = this.interfaces.size();
            boolean bl = false;
            if (n > 1 || this.superClass != null) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
                bl = true;
            }
            stringBuffer.append("implements ");
            int n3 = 0;
            while (n3 < n) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.interfaces.elementAt(n3));
                ++n3;
            }
            if (bl) {
                jSourceWriter.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append('{');
        jSourceWriter.writeln(stringBuffer.toString());
        stringBuffer.setLength(0);
        jSourceWriter.writeln();
        jSourceWriter.indent();
        if (this.fields.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //--------------------------/");
            jSourceWriter.writeln(" //- Class/Member Variables -/");
            jSourceWriter.writeln("//--------------------------/");
            jSourceWriter.writeln();
        }
        n = 0;
        while (n < this.fields.size()) {
            JField jField = (JField)this.fields.get(n);
            JDocComment jDocComment = jField.getComment();
            if (jDocComment != null) {
                jDocComment.print(jSourceWriter);
            }
            jSourceWriter.write(jField.getModifiers().toString());
            jSourceWriter.write(32);
            object = jField.getType();
            String string5 = ((JType)object).toString();
            if (string5.equals(this.toString())) {
                string5 = ((JType)object).getLocalName();
            }
            jSourceWriter.write(string5);
            jSourceWriter.write(32);
            jSourceWriter.write(jField.getName());
            String string6 = jField.getInitString();
            if (string6 != null) {
                jSourceWriter.write(" = ");
                jSourceWriter.write(string6);
            }
            jSourceWriter.writeln(';');
            jSourceWriter.writeln();
            ++n;
        }
        if (!this._staticInitializer.isEmpty()) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("static {");
            jSourceWriter.writeln(this._staticInitializer.toString());
            jSourceWriter.writeln("};");
            jSourceWriter.writeln();
        }
        if (this.constructors.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //----------------/");
            jSourceWriter.writeln(" //- Constructors -/");
            jSourceWriter.writeln("//----------------/");
            jSourceWriter.writeln();
        }
        int n4 = 0;
        while (n4 < this.constructors.size()) {
            JConstructor jConstructor = (JConstructor)this.constructors.elementAt(n4);
            jConstructor.print(jSourceWriter);
            jSourceWriter.writeln();
            ++n4;
        }
        if (this.methods.size() > 0) {
            jSourceWriter.writeln();
            jSourceWriter.writeln("  //-----------/");
            jSourceWriter.writeln(" //- Methods -/");
            jSourceWriter.writeln("//-----------/");
            jSourceWriter.writeln();
        }
        int n5 = 0;
        while (n5 < this.methods.size()) {
            object = (JMethod)this.methods.elementAt(n5);
            ((JMethod)object).print(jSourceWriter);
            jSourceWriter.writeln();
            ++n5;
        }
        jSourceWriter.unindent();
        jSourceWriter.writeln('}');
        jSourceWriter.flush();
        jSourceWriter.close();
    }

    private void printlnWithPrefix(String string, String string2, JSourceWriter jSourceWriter) {
        jSourceWriter.write(string);
        if (string2 == null) {
            return;
        }
        char[] cArray = string2.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c == '\n') {
                jSourceWriter.write(cArray, n, n2 - n + 1);
                n = n2 + 1;
                if (n2 < cArray.length) {
                    jSourceWriter.write(string);
                }
            }
            ++n2;
        }
        if (n < cArray.length) {
            jSourceWriter.write(cArray, n, cArray.length - n);
        }
        jSourceWriter.writeln();
    }

    public boolean removeImport(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        if (string.length() == 0) {
            return bl;
        }
        bl = this.imports.removeElement(string);
        return bl;
    }

    public void setHeader(JComment jComment) {
        this.header = jComment;
    }

    public void setPackageName(String string) {
        this.packageName = string;
        this.changePackage(string);
    }

    public void setSuperClass(String string) {
        this.superClass = string;
    }
}

