/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.Serializable;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;
import javax.crypto.b;
import javax.crypto.g;
import javax.crypto.n;
import javax.crypto.o;
import javax.crypto.q;
import javax.crypto.r;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    private Provider a;
    private CipherSpi b;
    private String c;
    private o d;
    private ExemptionMechanism e;
    private boolean f = false;
    private int g = 0;
    private int h = 0;
    private boolean i;
    private boolean j;
    private static final int k = 32;
    private byte[] l;
    private static final int m = 64;
    private byte[] n;
    private static final String o = "2.5.29.15";
    static /* synthetic */ Class p;
    static /* synthetic */ Class q;
    static /* synthetic */ Class r;
    static /* synthetic */ Class s;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.b = cipherSpi;
        this.a = provider;
        this.c = string;
    }

    Cipher(CipherSpi cipherSpi, Provider provider, o o2, ExemptionMechanism exemptionMechanism, Boolean bl, String string) {
        this(cipherSpi, provider, string);
        this.d = o2;
        this.e = exemptionMechanism;
        this.j = o2 != null && o2.d() == -1 ? false : (bl != null ? bl : true);
        if (this.j) {
            this.l = new byte[32];
            this.n = new byte[64];
        }
    }

    private boolean a(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray.length < n2 + n4 || byArray2.length < n3 + n4) {
            return false;
        }
        int n5 = 0;
        while (n5 < n4) {
            if (byArray[n5 + n2] != byArray2[n5 + n3]) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    private void a(byte[] byArray, int n2, int n3) {
        if (!this.i && n3 - n2 >= 64 && this.a(byArray, n2, this.n, 0, 64)) {
            throw new SecurityException("Bad cipher state");
        }
        if (this.i && this.h == this.g) {
            if (n3 - n2 >= 32 && this.a(byArray, n2, this.l, 0, 32)) {
                throw new SecurityException("Bad cipher state");
            }
            if (n3 - n2 >= 64 && this.a(byArray, n2, this.n, 0, 64)) {
                throw new SecurityException("Bad cipher state");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        byte[] byArray = this.b.engineDoFinal(null, 0, 0);
        if (this.j) {
            this.a(byArray, 0);
        }
        return byArray;
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (this.j) {
            this.a(byArray, 0, byArray.length);
        }
        byte[] byArray2 = this.b.engineDoFinal(byArray, 0, byArray.length);
        if (this.j) {
            this.a(byArray2, 0);
        }
        return byArray2;
    }

    public final int doFinal(byte[] byArray, int n2) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n2 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        int n3 = this.b.engineDoFinal(null, 0, 0, byArray, n2);
        if (this.j) {
            this.a(byArray, n2);
        }
        return n3;
    }

    public final byte[] doFinal(byte[] byArray, int n2, int n3) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n2 < 0 || n3 > byArray.length - n2 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (this.j) {
            this.a(byArray, n2, n3);
        }
        byte[] byArray2 = this.b.engineDoFinal(byArray, n2, n3);
        if (this.j) {
            this.a(byArray2, 0);
        }
        return byArray2;
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n2 < 0 || n3 > byArray.length - n2 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (this.j && !(this instanceof NullCipher)) {
            this.a(byArray, n2, n3);
        }
        int n4 = this.b.engineDoFinal(byArray, n2, n3, byArray2, 0);
        if (this.j && !(this instanceof NullCipher)) {
            this.a(byArray2, 0);
        }
        return n4;
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n2 < 0 || n3 > byArray.length - n2 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (this.j) {
            this.a(byArray, n2, n3);
        }
        int n5 = this.b.engineDoFinal(byArray, n2, n3, byArray2, n4);
        if (this.j) {
            this.a(byArray2, n4);
        }
        return n5;
    }

    public final String getAlgorithm() {
        return this.c;
    }

    private AlgorithmParameterSpec a(AlgorithmParameters algorithmParameters) throws InvalidParameterSpecException, InvalidAlgorithmParameterException {
        if (algorithmParameters == null) {
            return null;
        }
        String string = algorithmParameters.getAlgorithm().toUpperCase();
        if (string.equalsIgnoreCase("RC2")) {
            return algorithmParameters.getParameterSpec(p != null ? p : (p = Cipher.class$("javax.crypto.spec.RC2ParameterSpec")));
        }
        if (string.equalsIgnoreCase("RC5")) {
            return algorithmParameters.getParameterSpec(q != null ? q : (q = Cipher.class$("javax.crypto.spec.RC5ParameterSpec")));
        }
        if (string.startsWith("PBE")) {
            return algorithmParameters.getParameterSpec(r != null ? r : (r = Cipher.class$("javax.crypto.spec.PBEParameterSpec")));
        }
        if (string.startsWith("DES")) {
            return algorithmParameters.getParameterSpec(s != null ? s : (s = Cipher.class$("javax.crypto.spec.IvParameterSpec")));
        }
        throw new InvalidAlgorithmParameterException("No parameter specification class defined for parameters");
    }

    public final int getBlockSize() {
        return this.b.engineGetBlockSize();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return this.e;
    }

    public final byte[] getIV() {
        return this.b.engineGetIV();
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String[] stringArray;
        Object[] objectArray;
        boolean bl;
        boolean bl2;
        block17: {
            if (string == null) {
                throw new NoSuchAlgorithmException("No transformation given");
            }
            bl2 = false;
            bl = false;
            objectArray = null;
            int n2 = 0;
            stringArray = new String[3];
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            try {
                while (stringTokenizer.hasMoreTokens() && n2 < 3) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
                if (n2 == 0 || n2 == 2 || stringTokenizer.hasMoreTokens()) {
                    throw new NoSuchAlgorithmException("Wrong transformation format");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NoSuchAlgorithmException("Wrong transformation format");
            }
            try {
                if (n2 == 3) {
                    try {
                        objectArray = javax.crypto.b.a(string, "Cipher", null);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        try {
                            objectArray = javax.crypto.b.a(String.valueOf(stringArray[0]) + "/" + stringArray[1], "Cipher", null);
                            bl = true;
                            break block17;
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                            try {
                                objectArray = javax.crypto.b.a(String.valueOf(stringArray[0]) + "//" + stringArray[2], "Cipher", null);
                                bl2 = true;
                                break block17;
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                                objectArray = javax.crypto.b.a(stringArray[0], "Cipher", null);
                                bl2 = true;
                                bl = true;
                            }
                        }
                    }
                    break block17;
                }
                objectArray = javax.crypto.b.a(string, "Cipher", null);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
            }
        }
        Cipher cipher = new Cipher((CipherSpi)objectArray[0], (Provider)objectArray[1], (o)objectArray[2], (ExemptionMechanism)objectArray[3], (Boolean)objectArray[4], string);
        if (bl2) {
            cipher.b.engineSetMode(stringArray[1]);
        }
        if (bl) {
            if (stringArray[2].toUpperCase().equals("PKCS5PADDING") && stringArray[1] != null && (stringArray[1].toUpperCase().startsWith("CFB") || stringArray[1].toUpperCase().startsWith("OFB"))) {
                throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
            }
            cipher.b.engineSetPadding(stringArray[2]);
        }
        return cipher;
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Missing provider");
        }
        if (string == null) {
            throw new NoSuchAlgorithmException("No transformation given");
        }
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = null;
        int n2 = 0;
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        try {
            while (stringTokenizer.hasMoreTokens() && n2 < 3) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
            if (n2 == 0 || n2 == 2 || stringTokenizer.hasMoreTokens()) {
                throw new NoSuchAlgorithmException("Wrong transformation format");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchAlgorithmException("Wrong transformation format");
        }
        if (n2 == 3) {
            try {
                objectArray = javax.crypto.b.a(string, "Cipher", string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    objectArray = javax.crypto.b.a(String.valueOf(stringArray[0]) + "/" + stringArray[1], "Cipher", string2);
                    bl2 = true;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    try {
                        objectArray = javax.crypto.b.a(String.valueOf(stringArray[0]) + "//" + stringArray[2], "Cipher", string2);
                        bl = true;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                        objectArray = javax.crypto.b.a(stringArray[0], "Cipher", string2);
                        bl = true;
                        bl2 = true;
                    }
                }
            }
        } else {
            objectArray = javax.crypto.b.a(string, "Cipher", string2);
        }
        Cipher cipher = new Cipher((CipherSpi)objectArray[0], (Provider)objectArray[1], (o)objectArray[2], (ExemptionMechanism)objectArray[3], (Boolean)objectArray[4], string);
        if (bl) {
            cipher.b.engineSetMode(stringArray[1]);
        }
        if (bl2) {
            cipher.b.engineSetPadding(stringArray[2]);
        }
        return cipher;
    }

    public final int getOutputSize(int n2) throws IllegalStateException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Input size must be equal to or greater than zero");
        }
        return this.b.engineGetOutputSize(n2);
    }

    public final AlgorithmParameters getParameters() {
        return this.b.engineGetParameters();
    }

    public final Provider getProvider() {
        return this.a;
    }

    public final void init(int n2, Key key) throws InvalidKeyException {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (!(this.d instanceof n)) {
            int n3 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new o(key.getAlgorithm(), n3, this.d.c()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(String.valueOf(this.e.getName()) + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n2, key, new SecureRandom());
        this.f = true;
        this.h = this.g;
        this.g = n2;
        this.i = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d == null) {
            g g2 = (g)AccessController.doPrivileged(new q());
            if (!g2.a()) {
                throw new NullPointerException();
            }
        } else if (!(this.d instanceof n)) {
            int n3 = this.b.engineGetKeySize(key);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = this.a(algorithmParameters);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Failed to retrieve algorithm parameter specification");
            }
            if (!this.d.implies(new o(key.getAlgorithm(), n3, algorithmParameterSpec, this.d.c()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(String.valueOf(this.e.getName()) + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n2, key, algorithmParameters, new SecureRandom());
        this.f = true;
        this.h = this.g;
        this.g = n2;
        this.i = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (!(this.d instanceof n)) {
            int n3 = this.b.engineGetKeySize(key);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = this.a(algorithmParameters);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Failed to retrieve algorithm parameter specification");
            }
            if (!this.d.implies(new o(key.getAlgorithm(), n3, algorithmParameterSpec, this.d.c()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(String.valueOf(this.e.getName()) + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n2, key, algorithmParameters, secureRandom);
        this.f = true;
        this.h = this.g;
        this.g = n2;
        this.i = true;
    }

    public final void init(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (!(this.d instanceof n)) {
            int n3 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new o(key.getAlgorithm(), n3, this.d.c()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(String.valueOf(this.e.getName()) + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n2, key, secureRandom);
        this.f = true;
        this.h = this.g;
        this.g = n2;
        this.i = true;
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (this.d == null) {
            g g2 = (g)AccessController.doPrivileged(new r());
            if (!g2.a()) {
                throw new NullPointerException();
            }
        } else if (!(this.d instanceof n)) {
            int n3 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new o(key.getAlgorithm(), n3, algorithmParameterSpec, this.d.c()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(String.valueOf(this.e.getName()) + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n2, key, algorithmParameterSpec, new SecureRandom());
        this.f = true;
        this.h = this.g;
        this.g = n2;
        this.i = true;
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (!(this.d instanceof n)) {
            int n3 = this.b.engineGetKeySize(key);
            if (!this.d.implies(new o(key.getAlgorithm(), n3, algorithmParameterSpec, this.d.c()))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
            if (this.e != null) {
                try {
                    if (!this.e.isCryptoAllowed(key)) {
                        throw new SecurityException(String.valueOf(this.e.getName()) + " isn't enforced");
                    }
                }
                catch (ExemptionMechanismException exemptionMechanismException) {
                    throw new InvalidKeyException("Cannot determine whether " + this.e.getName() + " has " + "been enforced");
                }
            }
        }
        this.b.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.f = true;
        this.h = this.g;
        this.g = n2;
        this.i = true;
    }

    public final void init(int n2, Certificate certificate) throws InvalidKeyException {
        this.init(n2, certificate, new SecureRandom());
    }

    public final void init(int n2, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        boolean[] blArray;
        Serializable serializable;
        Set<String> set;
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        if (certificate instanceof X509Certificate && (set = (serializable = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !set.isEmpty() && set.contains(o) && (blArray = ((X509Certificate)serializable).getKeyUsage()) != null && (n2 == 1 && blArray.length > 3 && !blArray[3] || n2 == 3 && blArray.length > 2 && !blArray[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        serializable = certificate.getPublicKey();
        if (!(this.d instanceof n)) {
            int n3 = this.b.engineGetKeySize((Key)serializable);
            if (!this.d.implies(new o(serializable.getAlgorithm(), n3))) {
                throw new SecurityException("Unsupported keysize or algorithm parameters");
            }
        }
        this.b.engineInit(n2, (Key)serializable, secureRandom);
        this.f = true;
        this.g = n2;
        this.i = true;
    }

    public final Key unwrap(byte[] byArray, String string, int n2) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.g != 4) {
            throw new IllegalStateException("Cipher not initialized for unwrapping keys");
        }
        if (n2 != 3 && n2 != 2 && n2 != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        return this.b.engineUnwrap(byArray, string, n2);
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (byArray.length == 0) {
            return null;
        }
        if (this.j) {
            this.a(byArray, 0, byArray.length);
        }
        byte[] byArray2 = this.b.engineUpdate(byArray, 0, byArray.length);
        if (this.j) {
            this.a(byArray2, 0);
        }
        return byArray2;
    }

    public final byte[] update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n2 < 0 || n3 > byArray.length - n2 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n3 == 0) {
            return null;
        }
        if (this.j) {
            this.a(byArray, n2, n3);
        }
        byte[] byArray2 = this.b.engineUpdate(byArray, n2, n3);
        if (this.j) {
            this.a(byArray2, 0);
        }
        return byArray2;
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n2 < 0 || n3 > byArray.length - n2 || n3 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.j) {
            this.a(byArray, n2, n3);
        }
        int n4 = this.b.engineUpdate(byArray, n2, n3, byArray2, 0);
        if (this.j) {
            this.a(byArray2, 0);
        }
        return n4;
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray == null || n2 < 0 || n3 > byArray.length - n2 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.j) {
            this.a(byArray, n2, n3);
        }
        int n5 = this.b.engineUpdate(byArray, n2, n3, byArray2, n4);
        if (this.j) {
            this.a(byArray2, n4);
        }
        return n5;
    }

    private void a(byte[] byArray, int n2) {
        if (this.i) {
            if (byArray.length - n2 >= 32) {
                System.arraycopy(byArray, n2, this.l, 0, 32);
            }
            this.i = false;
        }
        if (byArray.length - n2 >= 64) {
            System.arraycopy(byArray, n2, this.n, 0, 64);
        }
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (!this.f && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.g != 3) {
            throw new IllegalStateException("Cipher not initialized for wrapping keys");
        }
        return this.b.engineWrap(key);
    }
}

