/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jrmp.interfaces;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb.plugins.jrmp.interfaces.InitialContextHandle;
import org.jboss.ejb.plugins.jrmp.interfaces.InitialContextHandleFactory;

public final class DefaultInitialContextHandle
extends InitialContextHandle {
    private static final long serialVersionUID = -7164179332281875677L;
    private Hashtable env = this.getEnvironment();

    private Hashtable getEnvironment() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        try {
            map.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            map.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            map.put("java.naming.provider.url", this.getUrl());
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to discover environment properties: " + e);
        }
    }

    public InitialContext getInitialContext() throws NamingException {
        InitialContext ctx = this.env != null ? new InitialContext(this.env) : new InitialContext();
        return ctx;
    }

    private String getUrl() throws Exception {
        ArrayList<MBeanServer> list;
        String hostname = System.getProperty("java.rmi.server.hostname");
        if (hostname == null) {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        if ((list = MBeanServerFactory.findMBeanServer(null)).size() == 0) {
            throw new RuntimeException("no MBean servers found");
        }
        MBeanServer server = (MBeanServer)list.get(0);
        Integer port = (Integer)server.invoke(new ObjectName(":service=Naming"), "getPort", new Object[0], new String[0]);
        return String.valueOf(hostname) + ":" + port;
    }

    public static final class Factory
    implements InitialContextHandleFactory {
        private InitialContextHandle instance;

        public InitialContextHandle create() {
            if (this.instance == null) {
                Factory factory = this;
                synchronized (factory) {
                    if (this.instance == null) {
                        this.instance = new DefaultInitialContextHandle();
                    }
                }
            }
            return this.instance;
        }
    }
}

