/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jrmp.interfaces;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.jboss.ejb.CacheKey;
import org.jboss.ejb.plugins.jrmp.interfaces.BeanProxy;
import org.jboss.ejb.plugins.jrmp.interfaces.ContainerRemote;
import org.jboss.ejb.plugins.jrmp.interfaces.EntityHandleImpl;
import org.jboss.ejb.plugins.jrmp.interfaces.GenericProxy;

public class EntityProxy
extends BeanProxy {
    private static final long serialVersionUID = -1523442773137704949L;
    protected CacheKey cacheKey;

    public EntityProxy() {
    }

    public EntityProxy(String name, ContainerRemote container, Object id, boolean optimize) {
        super(name, container, optimize);
        if (id == null) {
            throw new NullPointerException("Id may not be null");
        }
        this.cacheKey = id instanceof CacheKey ? (CacheKey)id : new CacheKey(id);
    }

    public final Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (args == null) {
            args = GenericProxy.EMPTY_ARGS;
        }
        if (m.equals(GenericProxy.TO_STRING)) {
            return String.valueOf(this.name) + ":" + this.cacheKey.getId().toString();
        }
        if (m.equals(GenericProxy.EQUALS)) {
            return this.invoke(proxy, BeanProxy.IS_IDENTICAL, args);
        }
        if (m.equals(GenericProxy.HASH_CODE)) {
            return new Integer(this.cacheKey.getId().hashCode());
        }
        if (m.equals(BeanProxy.GET_HANDLE)) {
            return new EntityHandleImpl(this.initialContextHandle, this.name, this.cacheKey.getId());
        }
        if (m.equals(BeanProxy.GET_PRIMARY_KEY)) {
            return this.cacheKey.getId();
        }
        if (m.equals(BeanProxy.GET_EJB_HOME)) {
            return this.getEJBHome();
        }
        if (m.equals(BeanProxy.IS_IDENTICAL)) {
            return this.isIdentical(args[0], this.cacheKey.getId());
        }
        return this.invokeContainer(this.cacheKey, m, args);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.cacheKey = (CacheKey)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.cacheKey);
    }
}

