/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jrmp.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.security.Principal;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.plugins.jrmp.interfaces.ContainerRemote;
import org.jboss.ejb.plugins.jrmp.interfaces.InitialContextHandle;
import org.jboss.ejb.plugins.jrmp.interfaces.RemoteMethodInvocation;
import org.jboss.security.SecurityAssociation;
import org.jboss.tm.TransactionPropagationContextFactory;

public abstract class GenericProxy
implements Externalizable {
    private static final long serialVersionUID = 1870461898442160570L;
    protected static final Object[] EMPTY_ARGS = new Object[0];
    protected static final Method TO_STRING;
    protected static final Method HASH_CODE;
    protected static final Method EQUALS;
    private static TransactionManager tm;
    protected static TransactionPropagationContextFactory tpcFactory;
    private static HashMap invokers;
    protected String name;
    protected ContainerRemote container;
    protected boolean optimize;
    protected InitialContextHandle initialContextHandle;
    private long containerStartup = ContainerRemote.STARTUP;
    static /* synthetic */ Class class$java$lang$Object;

    static {
        try {
            Class[] empty = new Class[]{};
            Class type = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = GenericProxy.class$("java.lang.Object"));
            TO_STRING = type.getMethod("toString", empty);
            HASH_CODE = type.getMethod("hashCode", empty);
            EQUALS = type.getMethod("equals", type);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
        tm = null;
        tpcFactory = null;
        invokers = new HashMap();
    }

    public GenericProxy() {
    }

    protected GenericProxy(String name, ContainerRemote container, boolean optimize) {
        this.name = name;
        this.container = container;
        this.optimize = optimize;
        this.initialContextHandle = InitialContextHandle.create();
    }

    public static void addLocal(String jndiName, ContainerRemote invoker) {
        invokers.put(jndiName, invoker);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected InitialContext createInitialContext() throws NamingException {
        return this.initialContextHandle.getInitialContext();
    }

    protected MarshalledObject createMarshalledObject(Object id, Method method, Object[] args) throws SystemException, IOException {
        RemoteMethodInvocation rmi = new RemoteMethodInvocation(id, method, args);
        rmi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        rmi.setPrincipal(this.getPrincipal());
        rmi.setCredential(this.getCredential());
        return new MarshalledObject<RemoteMethodInvocation>(rmi);
    }

    protected Object getCredential() {
        return SecurityAssociation.getCredential();
    }

    private static ContainerRemote getLocal(String jndiName) {
        return (ContainerRemote)invokers.get(jndiName);
    }

    protected Principal getPrincipal() {
        return SecurityAssociation.getPrincipal();
    }

    protected Transaction getTransaction() throws SystemException {
        return tm == null ? null : tm.getTransaction();
    }

    protected Object getTransactionPropagationContext() throws SystemException {
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    protected Object invokeContainer(Object id, Method method, Object[] args) throws Throwable {
        Object result;
        if (this.optimize && this.isLocal()) {
            result = this.container.invoke(id, method, args, this.getTransaction(), this.getPrincipal(), this.getCredential());
        } else {
            MarshalledObject mo = this.createMarshalledObject(id, method, args);
            if (this.isLocal()) {
                try {
                    result = this.container.invoke(mo).get();
                }
                catch (Throwable e) {
                    throw new MarshalledObject<Throwable>(e).get();
                }
            } else {
                result = this.container.invoke(mo).get();
            }
        }
        return result;
    }

    protected boolean isLocal() {
        return this.containerStartup == ContainerRemote.STARTUP;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.container = (ContainerRemote)in.readObject();
        this.containerStartup = in.readLong();
        this.optimize = in.readBoolean();
        this.initialContextHandle = (InitialContextHandle)in.readObject();
        if (this.isLocal()) {
            this.container = GenericProxy.getLocal(this.name);
        }
    }

    public static void removeLocal(String jndiName) {
        invokers.remove(jndiName);
    }

    public static void setTPCFactory(TransactionPropagationContextFactory tpcf) {
        tpcFactory = tpcf;
    }

    public static void setTransactionManager(TransactionManager txMan) {
        tm = txMan;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.isLocal() ? this.container : null);
        out.writeLong(this.containerStartup);
        out.writeBoolean(this.optimize);
        out.writeObject(this.initialContextHandle);
    }
}

