/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jrmp.interfaces;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.jboss.ejb.plugins.jrmp.interfaces.BeanProxy;
import org.jboss.ejb.plugins.jrmp.interfaces.ContainerRemote;
import org.jboss.ejb.plugins.jrmp.interfaces.GenericProxy;
import org.jboss.ejb.plugins.jrmp.interfaces.StatefulHandleImpl;

public class StatefulSessionProxy
extends BeanProxy {
    private static final long serialVersionUID = 1379411137308931705L;
    protected Object id;

    public StatefulSessionProxy() {
    }

    public StatefulSessionProxy(String name, ContainerRemote container, Object id, boolean optimize) {
        super(name, container, optimize);
        this.id = id;
    }

    public final Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (args == null) {
            args = GenericProxy.EMPTY_ARGS;
        }
        if (m.equals(GenericProxy.TO_STRING)) {
            return String.valueOf(this.name) + ":" + this.id.toString();
        }
        if (m.equals(GenericProxy.EQUALS)) {
            return this.invoke(proxy, BeanProxy.IS_IDENTICAL, args);
        }
        if (m.equals(GenericProxy.HASH_CODE)) {
            return new Integer(this.id.hashCode());
        }
        if (m.equals(BeanProxy.GET_HANDLE)) {
            return new StatefulHandleImpl(this.initialContextHandle, this.name, this.id);
        }
        if (m.equals(BeanProxy.GET_EJB_HOME)) {
            return this.getEJBHome();
        }
        if (m.equals(BeanProxy.GET_PRIMARY_KEY)) {
            return this.id;
        }
        if (m.equals(BeanProxy.IS_IDENTICAL)) {
            return this.isIdentical(args[0], this.id);
        }
        return this.invokeContainer(this.id, m, args);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.id = in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.id);
    }
}

