/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.verifier.BeanVerifier;
import org.jboss.verifier.Listener;

public class Main {
    public static final int OK = 0;
    public static final int WARNING = 1;
    static int returnCode = 0;

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("Usage: beanverifier [-novalidate] mybeans.jar");
            }
            boolean validate = true;
            String jar = null;
            int a = 0;
            while (a < args.length) {
                if (args[a].startsWith("-no")) {
                    validate = false;
                } else {
                    jar = args[a];
                }
                ++a;
            }
            URL url = new File(jar).toURL();
            URL[] urls = new URL[]{url};
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            URLClassLoader cl = new URLClassLoader(urls, parent);
            XmlFileLoader xfl = new XmlFileLoader(validate);
            BeanVerifier verifier = new BeanVerifier();
            xfl.setClassLoader((ClassLoader)cl);
            verifier.addVerificationListener(new Listener());
            verifier.verify(url, xfl.load());
        }
        catch (Exception e) {
            System.err.println("Problem starting the application:");
            System.err.println("Exception: " + e);
            System.err.println("Message:   " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(returnCode);
    }
}

