/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.strategy;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.gjt.lindfors.pattern.StrategyContext;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.verifier.Section;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.factory.VerificationEventFactory;
import org.jboss.verifier.strategy.VerificationContext;
import org.jboss.verifier.strategy.VerificationStrategy;

public abstract class AbstractVerifier
implements VerificationStrategy {
    protected static final String EJB_OBJECT_INTERFACE = "javax.ejb.EJBObject";
    protected static final String EJB_HOME_INTERFACE = "javax.ejb.EJBHome";
    protected ClassLoader classloader = null;
    private VerificationEventFactory factory = null;
    private VerificationContext context = null;
    public static final String BEAN_MANAGED_TX = "Bean";
    public static final String CONTAINER_MANAGED_TX = "Container";
    public static final String STATEFUL_SESSION = "Stateful";
    public static final String STATELESS_SESSION = "Stateless";
    private static final String EJB_FIND_BY_PRIMARY_KEY = "ejbFindByPrimaryKey";
    private static final String EJB_CREATE_METHOD = "ejbCreate";
    private static final String EJB_POST_CREATE_METHOD = "ejbPostCreate";
    private static final String EJB_POST_METHOD = "ejbCreate";
    private static final String CREATE_METHOD = "create";
    private static final String FINALIZE_METHOD = "finalize";
    private static final String REMOVE_METHOD = "remove";
    private static final String GET_HOME_HANDLE_METHOD = "getHomeHandle";
    private static final String GET_EJB_METADATA_METHOD = "getEJBMetaData";
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$javax$ejb$CreateException;
    static /* synthetic */ Class class$javax$ejb$FinderException;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$javax$ejb$SessionBean;
    static /* synthetic */ Class class$javax$ejb$EntityBean;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$SessionSynchronization;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Error;
    static /* synthetic */ Class class$java$lang$RuntimeException;

    public AbstractVerifier(VerificationContext context, VerificationEventFactory factory) {
        this.factory = factory;
        this.context = context;
        this.classloader = context.getClassLoader();
        if (this.classloader == null) {
            URL[] list = new URL[]{context.getJarLocation()};
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            this.classloader = new URLClassLoader(list, parent);
        }
    }

    public abstract void checkEntity(EntityMetaData var1);

    public void checkMessageBean(BeanMetaData bean) {
    }

    public abstract void checkSession(SessionMetaData var1);

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void fireBeanVerifiedEvent(BeanMetaData bean) {
        VerificationEvent event = this.factory.createBeanVerifiedEvent(this.context);
        event.setName(bean.getEjbName());
        this.context.fireBeanChecked(event);
    }

    protected void fireSpecViolationEvent(BeanMetaData bean, Method method, Section section) {
        VerificationEvent event = this.factory.createSpecViolationEvent(this.context, section);
        event.setName(bean.getEjbName());
        event.setMethod(method);
        this.context.fireSpecViolation(event);
    }

    protected void fireSpecViolationEvent(BeanMetaData bean, Section section) {
        this.fireSpecViolationEvent(bean, null, section);
    }

    public StrategyContext getContext() {
        return this.context;
    }

    public Iterator getCreateMethods(Class c) {
        LinkedList<Method> creates = new LinkedList<Method>();
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            if (this.isCreateMethod(method[i])) {
                creates.add(method[i]);
            }
            ++i;
        }
        return creates.iterator();
    }

    public Method getDefaultCreateMethod(Class c) {
        Method method = null;
        try {
            method = c.getMethod(CREATE_METHOD, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return method;
    }

    public Iterator getEJBCreateMethods(Class c) {
        LinkedList<Method> ejbCreates = new LinkedList<Method>();
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            if (method[i].getName().equals("ejbCreate")) {
                ejbCreates.add(method[i]);
            }
            ++i;
        }
        return ejbCreates.iterator();
    }

    public Method getEJBFindByPrimaryKey(Class c) {
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            String name = method[i].getName();
            if (name.equals(EJB_FIND_BY_PRIMARY_KEY)) {
                return method[i];
            }
            ++i;
        }
        return null;
    }

    public Iterator getEJBFindMethods(Class c) {
        LinkedList<Method> finders = new LinkedList<Method>();
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            if (method[i].getName().startsWith("ejbFind")) {
                finders.add(method[i]);
            }
            ++i;
        }
        return finders.iterator();
    }

    public Iterator getFinderMethods(Class home) {
        LinkedList<Method> finders = new LinkedList<Method>();
        Method[] method = home.getMethods();
        int i = 0;
        while (i < method.length) {
            if (method[i].getName().startsWith("find")) {
                finders.add(method[i]);
            }
            ++i;
        }
        return finders.iterator();
    }

    public Method getMatchingEJBCreate(Class bean, Method create) {
        try {
            return bean.getMethod("ejbCreate", create.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Method getMatchingEJBFind(Class bean, Method finder) {
        try {
            String methodName = "ejbF" + finder.getName().substring(1);
            return bean.getMethod(methodName, finder.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Method getMatchingEJBPostCreate(Class bean, Method ejbCreate) {
        try {
            return bean.getMethod(EJB_POST_CREATE_METHOD, ejbCreate.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public boolean hasANonStaticField(Class c) {
        try {
            Field[] list = c.getFields();
            int i = 0;
            while (i < list.length) {
                if (!Modifier.isStatic(list[i].getModifiers())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean hasCreateMethod(Class c) {
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            String name = method[i].getName();
            if (name.equals(CREATE_METHOD)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasDefaultConstructor(Class c) {
        try {
            c.newInstance();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean hasDefaultCreateMethod(Class home) {
        Method[] method = home.getMethods();
        int i = 0;
        while (i < method.length) {
            Class<?>[] params;
            String name = method[i].getName();
            if (name.equals(CREATE_METHOD) && (params = method[i].getParameterTypes()).length == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasEJBCreateMethod(Class c, boolean isSession) {
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            String name = method[i].getName();
            if (name.equals("ejbCreate") && !this.isStatic(method[i]) && !this.isFinal(method[i]) && (isSession && this.hasVoidReturnType(method[i]) || !isSession)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasEJBFindByPrimaryKey(Class c) {
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            String name = method[i].getName();
            if (name.equals(EJB_FIND_BY_PRIMARY_KEY)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasEJBHomeInterface(Class c) {
        return (class$javax$ejb$EJBHome != null ? class$javax$ejb$EJBHome : (class$javax$ejb$EJBHome = AbstractVerifier.class$(EJB_HOME_INTERFACE))).isAssignableFrom(c);
    }

    public boolean hasEJBObjectInterface(Class c) {
        return (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = AbstractVerifier.class$(EJB_OBJECT_INTERFACE))).isAssignableFrom(c);
    }

    public boolean hasEntityBeanInterface(Class c) {
        return (class$javax$ejb$EntityBean != null ? class$javax$ejb$EntityBean : (class$javax$ejb$EntityBean = AbstractVerifier.class$("javax.ejb.EntityBean"))).isAssignableFrom(c);
    }

    public boolean hasFinalizer(Class c) {
        try {
            Method finalizer = c.getDeclaredMethod(FINALIZE_METHOD, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    public boolean hasFinderMethod(Class c) {
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            String name = method[i].getName();
            if (name.startsWith("ejbFind")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasLegalRMIIIOPArguments(Method method) {
        Class<?>[] params = method.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            if (!this.isRMIIIOPType(params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasLegalRMIIIOPExceptionTypes(Method method) {
        Iterator<Class<?>> it = Arrays.asList(method.getExceptionTypes()).iterator();
        while (it.hasNext()) {
            Class<?> exception = it.next();
            if (this.isRMIIDLExceptionType(exception)) continue;
            return false;
        }
        return true;
    }

    public boolean hasLegalRMIIIOPReturnType(Method method) {
        return this.isRMIIIOPType(method.getReturnType());
    }

    public boolean hasMatchingEJBCreate(Class bean, Method create) {
        try {
            return bean.getMethod("ejbCreate", create.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public boolean hasMatchingEJBFind(Class bean, Method finder) {
        try {
            String methodName = "ejbF" + finder.getName().substring(1);
            return bean.getMethod(methodName, finder.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public boolean hasMatchingEJBPostCreate(Class bean, Method ejbCreate) {
        try {
            return bean.getMethod(EJB_POST_CREATE_METHOD, ejbCreate.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public boolean hasMatchingExceptions(Method source, Method target) {
        Class<?>[] a = source.getExceptionTypes();
        Class<?>[] b = target.getExceptionTypes();
        int i = 0;
        while (i < a.length) {
            boolean found = false;
            int j = 0;
            while (j < b.length) {
                if (a[i] == b[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasMatchingMethod(Class bean, Method remote) {
        String methodName = remote.getName();
        try {
            bean.getMethod(methodName, remote.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public boolean hasMatchingReturnType(Method a, Method b) {
        return a.getReturnType() == b.getReturnType();
    }

    public boolean hasMoreThanOneCreateMethods(Class c) {
        int count = 0;
        Method[] method = c.getMethods();
        int i = 0;
        while (i < method.length) {
            String name = method[i].getName();
            if (name.equals(CREATE_METHOD)) {
                ++count;
            }
            ++i;
        }
        return count > 1;
    }

    public boolean hasPrimaryKeyReturnType(EntityMetaData entity, Method m) {
        try {
            return m.getReturnType().isAssignableFrom(this.classloader.loadClass(entity.getPrimaryKeyClass()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return m.getReturnType().getName().equals(entity.getPrimaryKeyClass());
        }
    }

    public boolean hasRemoteReturnType(BeanMetaData bean, Method m) {
        return m.getReturnType().getName().equals(bean.getRemote());
    }

    public boolean hasSessionBeanInterface(Class c) {
        return (class$javax$ejb$SessionBean != null ? class$javax$ejb$SessionBean : (class$javax$ejb$SessionBean = AbstractVerifier.class$("javax.ejb.SessionBean"))).isAssignableFrom(c);
    }

    public boolean hasSessionSynchronizationInterface(Class c) {
        return (class$javax$ejb$SessionSynchronization != null ? class$javax$ejb$SessionSynchronization : (class$javax$ejb$SessionSynchronization = AbstractVerifier.class$("javax.ejb.SessionSynchronization"))).isAssignableFrom(c);
    }

    public boolean hasVoidReturnType(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    public boolean isAbstract(Class c) {
        return Modifier.isAbstract(c.getModifiers());
    }

    public boolean isAllFieldsPublic(Class c) {
        try {
            Field[] list = c.getFields();
            int i = 0;
            while (i < list.length) {
                if (!Modifier.isPublic(list[i].getModifiers())) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isCreateMethod(Method m) {
        return m.getName().equals(CREATE_METHOD);
    }

    public boolean isFinal(Class c) {
        return Modifier.isFinal(c.getModifiers());
    }

    public boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public boolean isFinderMethod(Method m) {
        return m.getName().startsWith("find");
    }

    public boolean isMultiObjectFinder(Method finder) {
        return (class$java$util$Collection != null ? class$java$util$Collection : (class$java$util$Collection = AbstractVerifier.class$("java.util.Collection"))).isAssignableFrom(finder.getReturnType()) || (class$java$util$Enumeration != null ? class$java$util$Enumeration : (class$java$util$Enumeration = AbstractVerifier.class$("java.util.Enumeration"))).isAssignableFrom(finder.getReturnType());
    }

    public boolean isPublic(Class c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    private boolean isRMIIDLExceptionType(Class type) {
        if (!(class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = AbstractVerifier.class$("java.lang.Throwable"))).isAssignableFrom(type)) {
            return false;
        }
        if ((class$java$lang$Error != null ? class$java$lang$Error : (class$java$lang$Error = AbstractVerifier.class$("java.lang.Error"))).isAssignableFrom(type)) {
            return false;
        }
        if ((class$java$lang$RuntimeException != null ? class$java$lang$RuntimeException : (class$java$lang$RuntimeException = AbstractVerifier.class$("java.lang.RuntimeException"))).isAssignableFrom(type)) {
            return false;
        }
        return this.isRMIIDLValueType(type);
    }

    private boolean isRMIIDLRemoteInterface(Class type) {
        if (!(class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = AbstractVerifier.class$("java.rmi.Remote"))).isAssignableFrom(type)) {
            return false;
        }
        Iterator<Method> methodIterator = Arrays.asList(type.getMethods()).iterator();
        while (methodIterator.hasNext()) {
            Method m = methodIterator.next();
            if (!this.throwsRemoteException(m)) {
                return false;
            }
            Iterator<Class<?>> it = Arrays.asList(m.getExceptionTypes()).iterator();
            while (it.hasNext()) {
                Class<?> exception = it.next();
                if (this.isRMIIDLExceptionType(exception)) continue;
                return false;
            }
        }
        Iterator<Field> fieldIterator = Arrays.asList(type.getFields()).iterator();
        while (fieldIterator.hasNext()) {
            Field f = fieldIterator.next();
            if (f.getType().isPrimitive() || f.getType().equals(class$java$lang$String != null ? class$java$lang$String : AbstractVerifier.class$("java.lang.String"))) continue;
            return false;
        }
        return true;
    }

    private boolean isRMIIDLValueType(Class type) {
        if ((class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = AbstractVerifier.class$("java.rmi.Remote"))).isAssignableFrom(type)) {
            return false;
        }
        return type.getDeclaringClass() == null || this.isStatic(type) || this.isRMIIDLValueType(type.getDeclaringClass());
    }

    private boolean isRMIIIOPType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return this.isRMIIIOPType(type.getComponentType());
        }
        if ((class$org$omg$CORBA$Object != null ? class$org$omg$CORBA$Object : (class$org$omg$CORBA$Object = AbstractVerifier.class$("org.omg.CORBA.Object"))).isAssignableFrom(type)) {
            return true;
        }
        if ((class$org$omg$CORBA$portable$IDLEntity != null ? class$org$omg$CORBA$portable$IDLEntity : (class$org$omg$CORBA$portable$IDLEntity = AbstractVerifier.class$("org.omg.CORBA.portable.IDLEntity"))).isAssignableFrom(type)) {
            return true;
        }
        if (this.isRMIIDLRemoteInterface(type)) {
            return true;
        }
        if (this.isRMIIDLExceptionType(type)) {
            return true;
        }
        return this.isRMIIDLValueType(type);
    }

    public boolean isSingleObjectFinder(EntityMetaData entity, Method finder) {
        return this.hasPrimaryKeyReturnType(entity, finder);
    }

    public boolean isStatic(Class c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public boolean throwsCreateException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        int i = 0;
        while (i < exception.length) {
            if ((class$javax$ejb$CreateException != null ? class$javax$ejb$CreateException : AbstractVerifier.class$("javax.ejb.CreateException")).isAssignableFrom(exception[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean throwsFinderException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        int i = 0;
        while (i < exception.length) {
            if ((class$javax$ejb$FinderException != null ? class$javax$ejb$FinderException : AbstractVerifier.class$("javax.ejb.FinderException")).isAssignableFrom(exception[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean throwsRemoteException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        int i = 0;
        while (i < exception.length) {
            if (exception[i].isAssignableFrom(class$java$rmi$RemoteException != null ? class$java$rmi$RemoteException : AbstractVerifier.class$("java.rmi.RemoteException"))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

