/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPRemoteServerInterface;
import org.jboss.security.srp.SRPServerListener;
import org.jboss.security.srp.SRPServerSession;
import org.jboss.security.srp.SRPVerifierStore;

public class SRPRemoteServer
extends UnicastRemoteObject
implements SRPRemoteServerInterface {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$srp$SRPRemoteServer == null ? (class$org$jboss$security$srp$SRPRemoteServer = SRPRemoteServer.class$("org.jboss.security.srp.SRPRemoteServer")) : class$org$jboss$security$srp$SRPRemoteServer));
    private Map sessionMap = Collections.synchronizedMap(new HashMap());
    private SRPVerifierStore verifierStore;
    private SRPServerListener listener;
    static /* synthetic */ Class class$org$jboss$security$srp$SRPRemoteServer;

    public SRPRemoteServer(SRPVerifierStore verifierStore) throws RemoteException {
        this.setVerifierStore(verifierStore);
    }

    public SRPRemoteServer(SRPVerifierStore verifierStore, int port) throws RemoteException {
        super(port);
        this.setVerifierStore(verifierStore);
    }

    public SRPRemoteServer(SRPVerifierStore verifierStore, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.setVerifierStore(verifierStore);
    }

    public void setVerifierStore(SRPVerifierStore verifierStore) {
        this.verifierStore = verifierStore;
        log.info((Object)("setVerifierStore, " + verifierStore));
    }

    public void addSRPServerListener(SRPServerListener listener) {
        this.listener = listener;
    }

    public void removeSRPServerListener(SRPServerListener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    public SRPParameters getSRPParameters(String username) throws KeyException, RemoteException {
        log.trace((Object)("getSRPParameters, " + username));
        SRPParameters params = null;
        try {
            SRPVerifierStore.VerifierInfo info = this.verifierStore.getUserVerifier(username);
            if (info == null) {
                throw new KeyException("Unknown username: " + username);
            }
            params = new SRPParameters(info.N, info.g, info.salt);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Params: " + params));
                byte[] hn = Util.newDigest().digest(params.N);
                log.trace((Object)("H(N): " + Util.tob64((byte[])hn)));
                byte[] hg = Util.newDigest().digest(params.g);
                log.trace((Object)("H(g): " + Util.tob64((byte[])hg)));
            }
            if (params.cipherAlgorithm != null) {
                Cipher cipher = Cipher.getInstance(params.cipherAlgorithm);
                int size = cipher.getBlockSize();
                params.cipherIV = new byte[size];
                Util.nextBytes((byte[])params.cipherIV);
            }
            SRPServerSession session = new SRPServerSession(username, info.verifier, params);
            this.sessionMap.put(username, session);
        }
        catch (IOException e) {
            throw new RemoteException("Error during user info retrieval", e);
        }
        catch (KeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new RemoteException("Failed to init cipherIV", e);
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected exception in getSRPParameters", t);
        }
        return params;
    }

    public byte[] init(String username, byte[] A) throws SecurityException, NoSuchAlgorithmException, RemoteException {
        log.trace((Object)("init, " + username));
        SRPServerSession session = (SRPServerSession)this.sessionMap.get(username);
        if (session == null) {
            throw new SecurityException("Failed to find active session for username: " + username);
        }
        byte[] B = session.exponential();
        session.buildSessionKey(A);
        return B;
    }

    public byte[] verify(String username, byte[] M1) throws SecurityException, RemoteException {
        log.trace((Object)("verify, " + username));
        SRPServerSession session = (SRPServerSession)this.sessionMap.get(username);
        if (session == null) {
            throw new SecurityException("Failed to find active session for username: " + username);
        }
        if (!session.verify(M1)) {
            throw new SecurityException("Failed to verify M1");
        }
        if (this.listener != null) {
            this.listener.verifiedUser(username, session);
        }
        return session.getServerResponse();
    }

    public void close(String username) throws SecurityException, RemoteException {
        log.trace((Object)("close, " + username));
        SRPServerSession session = (SRPServerSession)this.sessionMap.remove(username);
        if (session == null) {
            throw new SecurityException("Failed to find active session for username: " + username);
        }
        if (this.listener != null) {
            this.listener.closedUserSession(username);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

