/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.Name;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.security.srp.SRPVerifierStoreServiceMBean;
import org.jboss.security.srp.SerialObjectStore;
import org.jboss.util.ServiceMBeanSupport;

public class SRPVerifierStoreService
extends ServiceMBeanSupport
implements SRPVerifierStoreServiceMBean {
    private SerialObjectStore store;
    private String fileName = "SRPVerifierStore.ser";
    private String jndiName = "srp/DefaultVerifierSource";

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setStoreFile(String fileName) throws IOException {
        this.fileName = fileName;
        if (this.store != null) {
            File storeFile = new File(fileName);
            this.store.save(storeFile);
        }
    }

    public void addUser(String username, String password) throws IOException {
        try {
            this.store.addUser(username, password);
            this.save();
            this.log.debug((Object)("Added username: " + username));
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to addUser, username=" + username), (Throwable)e);
        }
    }

    public void delUser(String username) throws IOException {
        this.store.delUser(username);
        this.log.debug((Object)("Added username: " + username));
        this.save();
    }

    public String getName() {
        return "SRPVerifierStoreService";
    }

    public void initService() throws Exception {
    }

    public void startService() throws Exception {
        File storeFile = new File(this.fileName);
        this.store = new SerialObjectStore(storeFile);
        this.log.info((Object)("Created SerialObjectStore at: " + storeFile.getAbsolutePath()));
        InitialContext ctx = new InitialContext();
        Name name = ctx.getNameParser("").parse(this.jndiName);
        NonSerializableFactory.rebind((Name)name, (Object)this.store, (boolean)true);
    }

    private void save() throws IOException {
        if (this.store != null) {
            File storeFile = new File(this.fileName);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(this.fileName);
            if (url == null) {
                String parent = storeFile.getParent();
                if (parent != null && (url = loader.getResource(parent)) != null) {
                    storeFile = new File(url.getFile(), storeFile.getName());
                }
            } else {
                storeFile = new File(url.getFile());
            }
            this.store.save(storeFile);
        }
    }
}

