/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.Logger;
import org.jboss.security.auth.callback.SecurityAssociationCallback;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPServerSession;
import org.jboss.util.CachePolicy;

public class SRPCacheLoginModule
implements LoginModule {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$security$srp$jaas$SRPCacheLoginModule == null ? (class$org$jboss$security$srp$jaas$SRPCacheLoginModule = SRPCacheLoginModule.class$("org.jboss.security.srp.jaas.SRPCacheLoginModule")) : class$org$jboss$security$srp$jaas$SRPCacheLoginModule));
    private Subject subject;
    private CallbackHandler handler;
    private Map sharedState;
    private String domainName;
    private String cacheJndiName;
    private byte[] clientChallenge;
    private SRPServerSession session;
    private Principal userPrincipal;
    private boolean loginFailed;
    static /* synthetic */ Class class$org$jboss$security$srp$jaas$SRPCacheLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = handler;
        this.sharedState = sharedState;
        this.cacheJndiName = (String)options.get("cacheJndiName");
        log.trace((Object)("cacheJndiName=" + this.cacheJndiName));
        this.domainName = (String)options.get("domainName");
    }

    public boolean login() throws LoginException {
        String username;
        block6: {
            this.loginFailed = true;
            this.getUserInfo();
            username = this.userPrincipal.getName();
            try {
                if (this.cacheJndiName == null) {
                    throw new LoginException("Required cacheJndiName option not set");
                }
                InitialContext iniCtx = new InitialContext();
                CachePolicy cache = (CachePolicy)iniCtx.lookup(this.cacheJndiName);
                Object cacheCredential = cache.get((Object)this.userPrincipal);
                if (cacheCredential == null) {
                    throw new LoginException("No SRP session found for: " + username);
                }
                log.trace((Object)("Found SRP cache credential: " + cacheCredential));
                if (cacheCredential instanceof SRPServerSession) {
                    this.session = (SRPServerSession)cacheCredential;
                    if (!this.validateCache(this.session)) {
                        throw new LoginException("Failed to validate SRP session key for: " + username);
                    }
                    break block6;
                }
                throw new LoginException("Unknown type of cache credential: " + cacheCredential.getClass());
            }
            catch (NamingException e) {
                log.error((Object)"Failed to load SRP auth cache", (Throwable)e);
                throw new LoginException("Failed to load SRP auth cache: " + e.toString(true));
            }
        }
        log.trace((Object)"Login succeeded");
        this.sharedState.put("javax.security.auth.login.name", username);
        this.sharedState.put("javax.security.auth.login.password", this.clientChallenge);
        this.loginFailed = false;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.loginFailed) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(this.userPrincipal);
        this.subject.getPublicCredentials().add(this.clientChallenge);
        byte[] sessionKey = this.session.getSessionKey();
        SRPParameters params = this.session.getParameters();
        Set<Object> privateCredentials = this.subject.getPrivateCredentials();
        privateCredentials.add(params);
        if (params.cipherAlgorithm != null) {
            SecretKeySpec secretKey = new SecretKeySpec(sessionKey, params.cipherAlgorithm);
            privateCredentials.add(secretKey);
        } else {
            privateCredentials.add(sessionKey);
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.userPrincipal = null;
        this.clientChallenge = null;
        return true;
    }

    public boolean logout() throws LoginException {
        try {
            if (!this.subject.isReadOnly()) {
                Set<?> s = this.subject.getPrincipals(this.userPrincipal.getClass());
                s.remove(this.userPrincipal);
                this.subject.getPublicCredentials().remove(this.clientChallenge);
                byte[] sessionKey = this.session.getSessionKey();
                SRPParameters params = this.session.getParameters();
                Set<Object> privateCredentials = this.subject.getPrivateCredentials();
                if (params.cipherAlgorithm != null) {
                    SecretKeySpec secretKey = new SecretKeySpec(sessionKey, params.cipherAlgorithm);
                    privateCredentials.remove(secretKey);
                } else {
                    privateCredentials.remove(sessionKey);
                }
                privateCredentials.remove(params);
            }
        }
        catch (Exception e) {
            throw new LoginException("Failed to remove commit information, " + e.getMessage());
        }
        return true;
    }

    private void getUserInfo() throws LoginException {
        if (this.handler == null) {
            throw new LoginException("No CallbackHandler provied");
        }
        SecurityAssociationCallback sac = new SecurityAssociationCallback();
        Callback[] callbacks = new Callback[]{sac};
        try {
            this.handler.handle(callbacks);
            this.userPrincipal = sac.getPrincipal();
            this.clientChallenge = (byte[])sac.getCredential();
            sac.clearCredential();
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("UnsupportedCallback: " + uce.getCallback().toString());
        }
        catch (ClassCastException e) {
            throw new LoginException("Credential info is not of type byte[], " + e.getMessage());
        }
    }

    private boolean validateCache(SRPServerSession session) {
        byte[] challenge = session.getClientResponse();
        boolean isValid = Arrays.equals(challenge, this.clientChallenge);
        return isValid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

