/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyQueueSession;

public class SpyQueueBrowser
implements QueueBrowser {
    boolean closed;
    Queue destination;
    String selector;
    SpyQueueSession session;

    SpyQueueBrowser(SpyQueueSession session, Queue destination, String selector) {
        this.destination = destination;
        this.session = session;
        this.selector = selector;
    }

    public void close() throws JMSException {
        this.closed = true;
    }

    public Enumeration getEnumeration() throws JMSException {
        if (this.closed) {
            throw new JMSException("The QueueBrowser was closed");
        }
        SpyMessage[] data = this.session.connection.browse(this.destination, this.selector);
        Vector<SpyMessage> v = new Vector<SpyMessage>(data.length);
        int i = 0;
        while (i < data.length) {
            v.addElement(data[i]);
            ++i;
        }
        return v.elements();
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    public Queue getQueue() throws JMSException {
        return this.destination;
    }
}

