/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageProducer;
import org.jboss.mq.SpyQueueSession;

public class SpyQueueSender
extends SpyMessageProducer
implements QueueSender {
    private SpyQueueSession session;
    private Queue queue = null;

    SpyQueueSender(SpyQueueSession session, Queue queue) {
        this.session = session;
        this.queue = queue;
        try {
            if (queue instanceof TemporaryQueue) {
                this.setDeliveryMode(1);
            } else {
                this.setDeliveryMode(2);
            }
        }
        catch (JMSException jMSException) {}
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public void send(Message message) throws JMSException {
        if (this.queue == null) {
            throw new InvalidDestinationException("I do not have a default Destination !");
        }
        this.send(this.queue, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.queue == null) {
            throw new InvalidDestinationException("I do not have a default Destination !");
        }
        this.send(this.queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send(queue, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDestination((Destination)queue);
        message.setJMSDeliveryMode(deliveryMode);
        long ts = System.currentTimeMillis();
        message.setJMSTimestamp(ts);
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(timeToLive + ts);
        }
        message.setJMSPriority(priority);
        message.setJMSMessageID(this.session.getNewMessageID());
        if (!(message instanceof SpyMessage)) {
            SpyEncapsulatedMessage m = new SpyEncapsulatedMessage();
            m.setMessage(message);
            message = m;
        }
        this.session.sendMessage((SpyMessage)message);
    }
}

