/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyMessageConsumer;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;
import org.jboss.mq.SpyXAResource;

public abstract class SpySession
implements Session,
XASession {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$SpySession != null ? class$org$jboss$mq$SpySession : (class$org$jboss$mq$SpySession = SpySession.class$("org.jboss.mq.SpySession"))));
    public Connection connection;
    protected boolean transacted;
    protected int acknowledgeMode;
    protected HashSet consumers;
    SpyMessageConsumer sessionConsumer;
    boolean closed;
    Object runLock = new Object();
    Object currentTransactionId;
    SpyXAResource spyXAResource;
    LinkedList messages = new LinkedList();
    LinkedList unacknowledgedMessages = new LinkedList();
    static /* synthetic */ Class class$org$jboss$mq$SpySession;

    SpySession(Connection conn, boolean trans, int acknowledge, boolean xaSession) {
        this.connection = conn;
        this.transacted = trans;
        this.acknowledgeMode = acknowledge;
        if (xaSession) {
            this.spyXAResource = new SpyXAResource(this);
        }
        this.closed = false;
        this.consumers = new HashSet();
        if (this.spyXAResource == null && this.transacted) {
            this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
        }
    }

    void addConsumer(SpyMessageConsumer who) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            this.consumers.add(who);
        }
        this.connection.addConsumer(who);
    }

    void addMessage(SpyMessage message) {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            this.messages.addLast(message);
        }
    }

    void addUnacknowledgedMessage(SpyMessage message) {
        this.unacknowledgedMessages.add(message);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void close() throws JMSException {
        Thread.yield();
        if (!this.closed && this.transacted && this.spyXAResource == null) {
            this.rollback();
        }
        var1_1 = this.runLock;
        synchronized (var1_1) {
            if (this.closed) {
                var2_2 = null;
                return;
            }
            this.closed = true;
        }
        var2_3 = this.consumers;
        synchronized (var2_3) {
            if (this.sessionConsumer != null) {
                this.sessionConsumer.close();
            }
            i = this.consumers.iterator();
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl24 : MonitorExitStatement: MONITOREXIT : var2_3
            if (true) ** GOTO lbl28
        }
        do {
            messageConsumer = (SpyMessageConsumer)i.next();
            messageConsumer.close();
lbl28:
            // 2 sources

        } while (i.hasNext());
        this.connection.sessionClosing(this);
    }

    public synchronized void commit() throws JMSException {
        if (this.spyXAResource != null) {
            throw new TransactionInProgressException("Should not be call from a XASession");
        }
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (!this.transacted) {
            throw new IllegalStateException("The session is not transacted");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Session: commit()");
        }
        Object object = this.runLock;
        synchronized (object) {
            try {
                try {
                    this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                    this.connection.spyXAResourceManager.commit(this.currentTransactionId, true);
                }
                catch (XAException e) {
                    throw new SpyJMSException("Could not commit", e);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
            }
            catch (Exception exception) {}
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyBytesMessage message = new SpyBytesMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMapMessage message = new SpyMapMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public Message createMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyMessage message = new SpyMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = new SpyObjectMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyObjectMessage message = new SpyObjectMessage();
        message.setObject(object);
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyStreamMessage message = new SpyStreamMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = new SpyTextMessage();
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        SpyTextMessage message = new SpyTextMessage();
        message.setText(string);
        message.producerClientId = this.connection.getClientID();
        return message;
    }

    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("SpySession: deleteDestination(dest=" + dest.toString() + ")"));
        }
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            this.consumers.remove(dest);
        }
    }

    public void doAcknowledge(Message message, AcknowledgementRequest ack) throws JMSException {
        LinkedList linkedList = this.unacknowledgedMessages;
        synchronized (linkedList) {
            this.connection.send(ack);
            this.unacknowledgedMessages.remove(message);
            if (ack.isAck) {
                Iterator i = this.unacknowledgedMessages.iterator();
                while (i.hasNext()) {
                    Message mess = (Message)i.next();
                    i.remove();
                    this.connection.send(((SpyMessage)mess).getAcknowledgementRequest(true));
                }
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (this.sessionConsumer == null) {
            return null;
        }
        return this.sessionConsumer.getMessageListener();
    }

    String getNewMessageID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.connection.getNewMessageID();
    }

    public boolean getTransacted() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return this.transacted;
    }

    public XAResource getXAResource() {
        return this.spyXAResource;
    }

    public synchronized void recover() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (this.transacted) {
            throw new IllegalStateException("The session is transacted");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Session: recover()");
        }
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw new SpyJMSException("Could not stop message delivery", (Exception)((Object)e));
        }
        try {
            LinkedList e = this.messages;
            synchronized (e) {
                Iterator i = this.consumers.iterator();
                while (i.hasNext()) {
                    SpyMessageConsumer consumer = (SpyMessageConsumer)i.next();
                    Iterator ii = this.unacknowledgedMessages.iterator();
                    while (ii.hasNext()) {
                        SpyMessage message = (SpyMessage)ii.next();
                        if (!consumer.getSubscription().accepts(message)) continue;
                        message.setJMSRedelivered(true);
                        consumer.messages.addLast(message);
                        ii.remove();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SpyJMSException("Unable to recover session ", e);
        }
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw new SpyJMSException("Could not resume message delivery", (Exception)((Object)e));
        }
    }

    void removeConsumer(SpyMessageConsumer who) throws JMSException {
        this.connection.removeConsumer(who);
        HashSet hashSet = this.consumers;
        synchronized (hashSet) {
            this.consumers.remove(who);
        }
    }

    public synchronized void rollback() throws JMSException {
        if (this.spyXAResource != null) {
            throw new TransactionInProgressException("Should not be call from a XASession");
        }
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (!this.transacted) {
            throw new IllegalStateException("The session is not transacted");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Session: rollback()");
        }
        Object object = this.runLock;
        synchronized (object) {
            try {
                try {
                    this.connection.spyXAResourceManager.endTx(this.currentTransactionId, true);
                    this.connection.spyXAResourceManager.rollback(this.currentTransactionId);
                }
                catch (XAException e) {
                    throw new SpyJMSException("Could not rollback", e);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                this.currentTransactionId = this.connection.spyXAResourceManager.startTx();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            while (true) {
                if (this.messages.size() <= 0) {
                    return;
                }
                SpyMessage message = (SpyMessage)this.messages.removeFirst();
                try {
                    if (this.sessionConsumer == null) {
                        log.warn((Object)"Session has no message listener set, cannot process message.");
                        this.connection.send(message.getAcknowledgementRequest(false));
                        continue;
                    }
                    this.sessionConsumer.addMessage(message);
                }
                catch (JMSException jMSException) {}
            }
        }
    }

    void sendMessage(SpyMessage m) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("sendMessage, ID:" + m.getJMSMessageID()));
        }
        if (this.transacted) {
            this.connection.spyXAResourceManager.addMessage(this.currentTransactionId, m.myClone());
        } else {
            this.connection.sendToServer(m);
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        this.sessionConsumer = new SpyMessageConsumer(this, true);
        this.sessionConsumer.setMessageListener(listener);
    }
}

