/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import javax.jms.JMSException;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.selectors.Selector;

public class Subscription
implements Serializable {
    private static final long serialVersionUID = 5655998476466703105L;
    public int subscriptionId;
    public SpyDestination destination;
    public String messageSelector;
    public boolean destroyDurableSubscription;
    public boolean noLocal;
    public transient Selector selector;
    public transient ConnectionToken dc;
    public transient Object clientConsumer = null;

    public boolean accepts(SpyMessage message) throws JMSException {
        if (message.getJMSDestination() instanceof SpyTopic && this.noLocal && message.producerClientId.equals(this.dc.getClientID())) {
            return false;
        }
        Selector ms = this.getSelector();
        return ms == null || ms.test(message);
    }

    public Selector getSelector() throws JMSException {
        if (this.messageSelector == null || this.messageSelector.length() == 0) {
            return null;
        }
        if (this.selector == null) {
            this.selector = new Selector(this.messageSelector);
        }
        return this.selector;
    }

    public Subscription myClone() {
        Subscription result = new Subscription();
        result.subscriptionId = this.subscriptionId;
        result.destination = this.destination;
        result.messageSelector = this.messageSelector;
        result.destroyDurableSubscription = this.destroyDurableSubscription;
        result.noLocal = this.noLocal;
        return result;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append("{subscriptionId=");
        tmp.append(this.subscriptionId);
        tmp.append(",destination=");
        tmp.append(this.destination);
        tmp.append(",messageSelector=");
        tmp.append(this.messageSelector);
        tmp.append(",destroyDurableSubscription=");
        tmp.append(this.destroyDurableSubscription);
        tmp.append(",noLocal=");
        tmp.append(this.noLocal);
        tmp.append(",dc=");
        tmp.append(this.dc);
        tmp.append("}");
        return tmp.toString();
    }
}

