/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.jms;

import EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.cluster.jms.ClusterTopicSession;
import org.jboss.mq.cluster.transport.NodeId;

public class ClusterTopicSubscriber
implements TopicSubscriber {
    Topic topic;
    boolean closed;
    boolean isReceiving;
    MessageListener messageListener;
    BoundedPriorityQueue messageQueue = new BoundedPriorityQueue(50);
    boolean noLocal;
    String selector;
    ClusterTopicSession session;

    ClusterTopicSubscriber(ClusterTopicSession session, Topic topic, boolean noLocal, String selector) {
        this.session = session;
        this.topic = topic;
        this.selector = selector;
        this.noLocal = noLocal;
    }

    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        if (this.messageListener == null && this.isReceiving) {
            try {
                this.messageQueue.put((Object)this);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.closed = true;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.messageListener;
    }

    public synchronized String getMessageSelector() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.selector;
    }

    public synchronized boolean getNoLocal() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.noLocal;
    }

    public synchronized Topic getTopic() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.topic;
    }

    public synchronized void onMessage(NodeId sender, SpyMessage message) throws InterruptedException {
        if (this.closed) {
            return;
        }
        if (this.session.connection.modeStop) {
            return;
        }
        if (this.noLocal && sender.equals(this.session.connection.transport.getLocalNodeId())) {
            return;
        }
        if (this.messageListener == null) {
            this.messageQueue.offer((Object)message, 0L);
        } else {
            this.messageListener.onMessage((Message)message);
        }
    }

    /*
     * Exception decompiling
     */
    public Message receive() throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Message receive(long arg1) throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public Message receiveNoWait() throws JMSException {
        throw new JMSException("This feature is not implemented");
    }

    public synchronized void setMessageListener(MessageListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        if (this.isReceiving) {
            throw new JMSException("This MessageConsumer is waiting in receive() !");
        }
        this.messageListener = listener;
    }
}

