/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.transport.udp;

import java.io.Serializable;
import java.net.InetAddress;
import org.jboss.mq.cluster.transport.NodeId;
import org.jboss.mq.cluster.transport.SerializerUtil;

public class UDPNodeId
implements NodeId,
Serializable {
    InetAddress address;
    int port;
    int adminPort;

    public boolean equals(Object obj) {
        try {
            UDPNodeId o = (UDPNodeId)obj;
            return o.address.equals(this.address) && o.port == this.port && o.adminPort == this.adminPort;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public void readFromByteArray(byte[] data, int pos) {
        try {
            this.port = SerializerUtil.readUShortFrom(data, pos);
            this.adminPort = SerializerUtil.readUShortFrom(data, pos + 2);
        }
        catch (Exception exception) {}
    }

    public String toString() {
        return "UDPNodeId:[" + this.address.getHostAddress() + ":" + this.port + ":" + this.adminPort + "]";
    }

    public void writeToByteArray(byte[] data, int pos) {
        SerializerUtil.writeUShortTo(this.port, data, pos);
        SerializerUtil.writeUShortTo(this.adminPort, data, pos + 2);
    }
}

