/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.oil.OILServerIL;
import org.jboss.mq.il.oil.OILServerILServiceMBean;
import org.jboss.mq.server.JMSServer;

public class OILServerILService
extends ServerILJMXService
implements Runnable,
OILServerILServiceMBean {
    protected ServerSocket serverSocket;
    protected boolean running;
    protected int serverBindPort = 0;
    protected InetAddress bindAddress = null;
    protected boolean enableTcpNoDelay;
    OILServerIL serverIL;
    Thread worker;
    protected static JMSServer server;
    static final int m_acknowledge = 1;
    static final int m_addMessage = 2;
    static final int m_browse = 3;
    static final int m_checkID = 4;
    static final int m_connectionClosing = 5;
    static final int m_createQueue = 6;
    static final int m_createTopic = 7;
    static final int m_deleteTemporaryDestination = 8;
    static final int m_getID = 9;
    static final int m_getTemporaryQueue = 10;
    static final int m_getTemporaryTopic = 11;
    static final int m_receive = 13;
    static final int m_setEnabled = 14;
    static final int m_setSpyDistributedConnection = 15;
    static final int m_subscribe = 16;
    static final int m_transact = 17;
    static final int m_unsubscribe = 18;
    static final int m_destroySubscription = 19;
    static final int m_checkUser = 20;
    static final int m_ping = 21;
    static final int SO_TIMEOUT = 5000;

    public String getBindAddress() {
        String addr = "0.0.0.0";
        if (this.bindAddress != null) {
            addr = this.bindAddress.getHostName();
        }
        return addr;
    }

    public Properties getClientConnectionProperties() {
        Properties rc = new Properties();
        rc.setProperty("ClientILService", "org.jboss.mq.il.oil.OILClientILService");
        String flag = this.enableTcpNoDelay ? "true" : "false";
        rc.setProperty("org.jboss.mq.il.oil.enableTcpNoDelay", flag);
        return rc;
    }

    public boolean getEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public String getName() {
        return "JBossMQ-OILServerIL";
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Socket socket = null;
        byte code = 0;
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        ConnectionToken connectionToken = null;
        boolean closed = false;
        boolean trace = this.log.isTraceEnabled();
        try {
            while (true) {
                if (!this.running || socket != null) {
                    if (this.running) break;
                    return;
                }
                try {
                    socket = this.serverSocket.accept();
                    if (!trace) continue;
                    this.log.trace((Object)("Accepted connection: " + socket));
                }
                catch (InterruptedIOException interruptedIOException) {}
            }
            socket.setSoTimeout(0);
            socket.setTcpNoDelay(this.enableTcpNoDelay);
            out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            out.flush();
            in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            Thread socketThread = new Thread((Runnable)this, "OIL Worker");
            socketThread.start();
        }
        catch (StreamCorruptedException sce) {
            this.log.warn((Object)"Stream propably closed from client", (Throwable)sce);
            return;
        }
        catch (IOException e) {
            this.log.warn((Object)"Could not initialize the OILServerIL Service.", (Throwable)e);
            this.running = false;
            return;
        }
        int cmd = 0;
        while (!closed && this.running) {
            block48: {
                ++cmd;
                if (trace) {
                    this.log.trace((Object)("Begin command msg: " + cmd));
                }
                try {
                    code = in.readByte();
                }
                catch (EOFException eOFException) {
                    break;
                }
                catch (IOException e) {
                    if (closed || !this.running) break;
                    this.log.warn((Object)"Connection failure (1).", (Throwable)e);
                    break;
                }
                if (trace) {
                    this.log.trace((Object)("MethodCode: " + code));
                }
                try {
                    SpyMessage[] result = null;
                    switch (code) {
                        case 15: {
                            connectionToken = (ConnectionToken)in.readObject();
                            if (!trace) break;
                            this.log.trace((Object)("The OILClientIL Connection is set up, token=" + connectionToken));
                            break;
                        }
                        case 1: {
                            AcknowledgementRequest ack = new AcknowledgementRequest();
                            ack.readExternal(in);
                            server.acknowledge(connectionToken, ack);
                            break;
                        }
                        case 2: {
                            server.addMessage(connectionToken, SpyMessage.readMessage(in));
                            break;
                        }
                        case 3: {
                            result = server.browse(connectionToken, (Destination)in.readObject(), (String)in.readObject());
                            break;
                        }
                        case 4: {
                            server.checkID((String)in.readObject());
                            break;
                        }
                        case 5: {
                            server.connectionClosing(connectionToken);
                            closed = true;
                            break;
                        }
                        case 6: {
                            result = server.createQueue(connectionToken, (String)in.readObject());
                            break;
                        }
                        case 7: {
                            result = server.createTopic(connectionToken, (String)in.readObject());
                            break;
                        }
                        case 8: {
                            server.deleteTemporaryDestination(connectionToken, (SpyDestination)in.readObject());
                            break;
                        }
                        case 9: {
                            result = server.getID();
                            break;
                        }
                        case 10: {
                            result = server.getTemporaryQueue(connectionToken);
                            break;
                        }
                        case 11: {
                            result = server.getTemporaryTopic(connectionToken);
                            break;
                        }
                        case 13: {
                            result = server.receive(connectionToken, in.readInt(), in.readLong());
                            break;
                        }
                        case 14: {
                            server.setEnabled(connectionToken, in.readBoolean());
                            break;
                        }
                        case 16: {
                            server.subscribe(connectionToken, (Subscription)in.readObject());
                            break;
                        }
                        case 17: {
                            TransactionRequest trans = new TransactionRequest();
                            trans.readExternal(in);
                            server.transact(connectionToken, trans);
                            break;
                        }
                        case 18: {
                            server.unsubscribe(connectionToken, in.readInt());
                            break;
                        }
                        case 19: {
                            server.destroySubscription((DurableSubcriptionID)in.readObject());
                            break;
                        }
                        case 20: {
                            result = server.checkUser((String)in.readObject(), (String)in.readObject());
                            break;
                        }
                        case 21: {
                            server.ping(connectionToken, in.readLong());
                            break;
                        }
                        default: {
                            throw new RemoteException("Bad method code !");
                        }
                    }
                    try {
                        if (result == null) {
                            out.writeByte(0);
                        } else {
                            out.writeByte(1);
                            out.writeObject(result);
                            out.reset();
                        }
                        out.flush();
                        break block48;
                    }
                    catch (IOException e) {
                        if (closed) break;
                        this.log.warn((Object)"Connection failure (2).", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    if (closed) break;
                    this.log.info((Object)"Client request resulted in a server exception: ", (Throwable)e);
                    try {
                        out.writeByte(2);
                        out.writeObject(e);
                        out.reset();
                        out.flush();
                        break block48;
                    }
                    catch (IOException iOException) {
                        if (closed) break;
                        this.log.warn((Object)"Connection failure (3).", (Throwable)e);
                    }
                }
                break;
            }
            if (!trace) continue;
            this.log.trace((Object)("End command msg: " + cmd));
        }
        try {
            if (!closed) {
                try {
                    server.connectionClosing(connectionToken);
                }
                catch (JMSException jMSException) {}
            }
            socket.close();
            return;
        }
        catch (IOException e) {
            this.log.warn((Object)"Connection failure during connection close.", (Throwable)e);
        }
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public void setEnableTcpNoDelay(boolean flag) {
        this.enableTcpNoDelay = flag;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public void startService() throws Exception {
        this.running = true;
        server = this.lookupJMSServer();
        this.serverSocket = new ServerSocket(this.serverBindPort, 50, this.bindAddress);
        this.serverSocket.setSoTimeout(5000);
        InetAddress socketAddress = this.serverSocket.getInetAddress();
        this.log.info((Object)("JBossMQ OIL service available at : " + socketAddress + ":" + this.serverSocket.getLocalPort()));
        this.worker = new Thread(OILServerILService.server.threadGroup, this, "OIL Worker");
        this.worker.start();
        if (socketAddress.toString().equals("0.0.0.0/0.0.0.0")) {
            socketAddress = InetAddress.getLocalHost();
        }
        this.serverIL = new OILServerIL(socketAddress, this.serverSocket.getLocalPort(), this.enableTcpNoDelay);
        this.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.running = false;
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

