/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.uil.UILClientIL;
import org.jboss.mq.il.uil.UILServerIL;
import org.jboss.mq.il.uil.UILServerILServiceMBean;
import org.jboss.mq.il.uil.multiplexor.SocketMultiplexor;
import org.jboss.mq.server.JMSServer;

public class UILServerILService
extends ServerILJMXService
implements Runnable,
UILServerILServiceMBean {
    protected ServerSocket serverSocket;
    UILServerIL serverIL;
    boolean running;
    int serverBindPort = 0;
    InetAddress bindAddress = null;
    Thread worker;
    protected static JMSServer server;
    static final int m_acknowledge = 1;
    static final int m_addMessage = 2;
    static final int m_browse = 3;
    static final int m_checkID = 4;
    static final int m_connectionClosing = 5;
    static final int m_createQueue = 6;
    static final int m_createTopic = 7;
    static final int m_deleteTemporaryDestination = 8;
    static final int m_getID = 9;
    static final int m_getTemporaryQueue = 10;
    static final int m_getTemporaryTopic = 11;
    static final int m_listenerChange = 12;
    static final int m_receive = 13;
    static final int m_setEnabled = 14;
    static final int m_setSpyDistributedConnection = 15;
    static final int m_subscribe = 16;
    static final int m_transact = 17;
    static final int m_unsubscribe = 18;
    static final int m_destroySubscription = 19;
    static final int m_checkUser = 20;
    static final int m_ping = 21;
    static final int SO_TIMEOUT = 5000;

    public String getBindAddress() {
        String addr = "0.0.0.0";
        if (this.bindAddress != null) {
            addr = this.bindAddress.getHostName();
        }
        return addr;
    }

    public Properties getClientConnectionProperties() {
        Properties rc = new Properties();
        rc.setProperty("ClientILService", "org.jboss.mq.il.uil.UILClientILService");
        return rc;
    }

    public String getName() {
        return "JBossMQ-UILServerIL";
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        socket = null;
        mSocket = null;
        code = 0;
        out = null;
        in = null;
        connectionToken = null;
        closed = false;
        try {
            while (true) {
                if (!this.running || socket != null) {
                    if (this.running) break;
                    return;
                }
                try {
                    socket = this.serverSocket.accept();
                }
                catch (InterruptedIOException v0) {}
            }
            socket.setSoTimeout(0);
            new Thread((Runnable)this, "UIL Worker").start();
            mSocket = new SocketMultiplexor(socket);
            out = new ObjectOutputStream(new BufferedOutputStream(mSocket.getOutputStream(1)));
            out.flush();
            in = new ObjectInputStream(new BufferedInputStream(mSocket.getInputStream(1)));
            if (true) ** GOTO lbl142
        }
        catch (StreamCorruptedException sce) {
            this.log.warn((Object)"Stream propably closed from client", (Throwable)sce);
            return;
        }
        catch (IOException e) {
            this.log.warn((Object)"Could not initialize the UILServerIL Service.", (Throwable)e);
            this.running = false;
            return;
        }
        do {
            try {
                code = in.readByte();
            }
            catch (EOFException v1) {
                break;
            }
            catch (IOException e) {
                if (closed || !this.running) break;
                this.log.warn((Object)"Connection failure (1).", (Throwable)e);
                break;
            }
            try {
                result = null;
                switch (code) {
                    case 15: {
                        this.log.debug((Object)"Setting up the UILClientIL Connection");
                        connectionToken = (ConnectionToken)in.readObject();
                        ((UILClientIL)connectionToken.clientIL).mSocket = mSocket;
                        ((UILClientIL)connectionToken.clientIL).createConnection();
                        this.log.debug((Object)"The UILClientIL Connection is set up");
                        break;
                    }
                    case 1: {
                        ack = new AcknowledgementRequest();
                        ack.readExternal(in);
                        UILServerILService.server.acknowledge(connectionToken, ack);
                        break;
                    }
                    case 2: {
                        UILServerILService.server.addMessage(connectionToken, SpyMessage.readMessage(in));
                        break;
                    }
                    case 3: {
                        result = UILServerILService.server.browse(connectionToken, (Destination)in.readObject(), (String)in.readObject());
                        break;
                    }
                    case 4: {
                        UILServerILService.server.checkID((String)in.readObject());
                        break;
                    }
                    case 5: {
                        UILServerILService.server.connectionClosing(connectionToken);
                        closed = true;
                        break;
                    }
                    case 6: {
                        result = UILServerILService.server.createQueue(connectionToken, (String)in.readObject());
                        break;
                    }
                    case 7: {
                        result = UILServerILService.server.createTopic(connectionToken, (String)in.readObject());
                        break;
                    }
                    case 8: {
                        UILServerILService.server.deleteTemporaryDestination(connectionToken, (SpyDestination)in.readObject());
                        break;
                    }
                    case 9: {
                        result = UILServerILService.server.getID();
                        break;
                    }
                    case 10: {
                        result = UILServerILService.server.getTemporaryQueue(connectionToken);
                        break;
                    }
                    case 11: {
                        result = UILServerILService.server.getTemporaryTopic(connectionToken);
                        break;
                    }
                    case 13: {
                        result = UILServerILService.server.receive(connectionToken, in.readInt(), in.readLong());
                        break;
                    }
                    case 14: {
                        UILServerILService.server.setEnabled(connectionToken, in.readBoolean());
                        break;
                    }
                    case 16: {
                        UILServerILService.server.subscribe(connectionToken, (Subscription)in.readObject());
                        break;
                    }
                    case 17: {
                        trans = new TransactionRequest();
                        trans.readExternal(in);
                        UILServerILService.server.transact(connectionToken, trans);
                        break;
                    }
                    case 18: {
                        UILServerILService.server.unsubscribe(connectionToken, in.readInt());
                        break;
                    }
                    case 19: {
                        UILServerILService.server.destroySubscription((DurableSubcriptionID)in.readObject());
                        break;
                    }
                    case 20: {
                        result = UILServerILService.server.checkUser((String)in.readObject(), (String)in.readObject());
                        break;
                    }
                    case 21: {
                        UILServerILService.server.ping(connectionToken, in.readLong());
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
                try {
                    if (result == null) {
                        out.writeByte(0);
                    } else {
                        out.writeByte(1);
                        out.writeObject(result);
                        out.reset();
                    }
                    out.flush();
                    continue;
                }
                catch (IOException e) {
                    if (closed) break;
                    this.log.warn((Object)"Connection failure (2).", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (closed) break;
                this.log.info((Object)"Client request resulted in a server exception: ", (Throwable)e);
                try {
                    out.writeByte(2);
                    out.writeObject(e);
                    out.reset();
                    out.flush();
                    continue;
                }
                catch (IOException v2) {
                    if (closed) break;
                    this.log.warn((Object)"Connection failure (3).", (Throwable)e);
                }
            }
            break;
lbl142:
            // 3 sources

        } while (!closed && this.running);
        try {
            if (!closed) {
                try {
                    UILServerILService.server.connectionClosing(connectionToken);
                }
                catch (JMSException v3) {}
            }
            mSocket.close();
            return;
        }
        catch (IOException e) {
            this.log.warn((Object)"Connection failure during connection close.", (Throwable)e);
        }
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public void startService() throws Exception {
        this.running = true;
        server = this.lookupJMSServer();
        this.serverSocket = new ServerSocket(this.serverBindPort, 50, this.bindAddress);
        this.serverSocket.setSoTimeout(5000);
        InetAddress socketAddress = this.serverSocket.getInetAddress();
        this.log.info((Object)("JBossMQ UIL service available at : " + socketAddress + ":" + this.serverSocket.getLocalPort()));
        this.worker = new Thread(UILServerILService.server.threadGroup, this, "UIL Worker");
        this.worker.start();
        if (socketAddress.toString().equals("0.0.0.0/0.0.0.0")) {
            socketAddress = InetAddress.getLocalHost();
        }
        this.serverIL = new UILServerIL(socketAddress, this.serverSocket.getLocalPort());
        this.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.running = false;
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

