/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.jboss.mq.il.uil.multiplexor.StreamDemux;

class DemuxInputStream
extends InputStream {
    StreamDemux streamDemux;
    short streamId;
    boolean atEOF = false;
    Object bufferMutex = new Object();
    byte[] buffer;
    short bufferEndPos;
    short bufferStartPos;

    DemuxInputStream(StreamDemux demux, short id) {
        this.streamDemux = demux;
        this.streamId = id;
        this.buffer = new byte[1000];
        this.bufferStartPos = 0;
        this.bufferEndPos = 0;
    }

    public int available() throws IOException {
        return this.getBufferFillSize();
    }

    public void close() throws IOException {
        this.streamDemux.closeStream(this.streamId);
    }

    private int getBufferFillSize() {
        return this.bufferStartPos <= this.bufferEndPos ? this.bufferEndPos - this.bufferStartPos : this.buffer.length - (this.bufferStartPos - this.bufferEndPos);
    }

    private int getBufferFreeSize() {
        return this.buffer.length - 1 - this.getBufferFillSize();
    }

    public void loadBuffer(byte[] data, short dataLength) throws IOException {
        int freeSize = 0;
        for (int dataPos = 0; dataPos < dataLength; dataPos += freeSize) {
            Object object = this.bufferMutex;
            synchronized (object) {
                while ((freeSize = this.getBufferFreeSize()) == 0) {
                    try {
                        this.bufferMutex.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException(e.getMessage());
                    }
                }
                freeSize = Math.min(freeSize, dataLength - dataPos);
                int i = 0;
                while (i < freeSize) {
                    short s = this.bufferEndPos;
                    this.bufferEndPos = (short)(s + 1);
                    this.buffer[s] = data[dataPos + i];
                    this.bufferEndPos = this.bufferEndPos == this.buffer.length ? (short)0 : this.bufferEndPos;
                    ++i;
                }
            }
            object = this.bufferMutex;
            synchronized (object) {
                this.bufferMutex.notify();
                continue;
            }
        }
    }

    public int read() throws IOException {
        if (this.bufferStartPos == this.bufferEndPos && this.atEOF) {
            return -1;
        }
        Object object = this.bufferMutex;
        synchronized (object) {
            while (!this.atEOF && this.bufferStartPos == this.bufferEndPos && !this.streamDemux.pumpData(this)) {
                try {
                    this.bufferMutex.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
            }
        }
        if (this.bufferStartPos == this.bufferEndPos) {
            return -1;
        }
        short s = this.bufferStartPos;
        this.bufferStartPos = (short)(s + 1);
        byte result = this.buffer[s];
        this.bufferStartPos = this.bufferStartPos == this.buffer.length ? (short)0 : this.bufferStartPos;
        Object object2 = this.bufferMutex;
        synchronized (object2) {
            this.bufferMutex.notify();
        }
        return result & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        len = Math.min(this.available(), len);
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                b[off + i] = (byte)c;
                ++i;
            }
        }
        catch (IOException iOException) {}
        return i;
    }
}

