/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;

public class MessageLog {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$pm$file$MessageLog != null ? class$org$jboss$mq$pm$file$MessageLog : (class$org$jboss$mq$pm$file$MessageLog = MessageLog.class$("org.jboss.mq.pm.file.MessageLog"))));
    private File queueName;
    static /* synthetic */ Class class$org$jboss$mq$pm$file$MessageLog;

    public MessageLog(String fileName) throws JMSException {
        this.queueName = new File(fileName);
        this.queueName.mkdir();
    }

    public void add(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            String fileName = message.getJMSMessageID().replace(':', '-');
            File f = transactionId == null ? new File(this.queueName, fileName) : new File(this.queueName, String.valueOf(fileName) + "." + transactionId);
            this.writeMessageToFile(message, f);
            message.persistData = f;
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws JMSException {
    }

    protected void delete(File file) throws IOException {
        if (!file.delete()) {
            Thread.yield();
            if (file.exists()) {
                if (!file.delete()) {
                    log.warn((Object)("Failed to delete file: " + file.getAbsolutePath()));
                }
            } else {
                log.warn((Object)("File was deleted, but delete() failed for: " + file.getAbsolutePath()));
            }
        }
    }

    public void finishAdd(SpyMessage message, Tx transactionId) throws JMSException {
    }

    public void finishRemove(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            File file = (File)message.persistData;
            this.delete(file);
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public void remove(SpyMessage message, Tx transactionId) throws JMSException {
    }

    protected void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            Thread.yield();
            if (from.exists()) {
                if (!from.renameTo(to)) {
                    log.warn((Object)("Rename of file " + from.getAbsolutePath() + " to " + to.getAbsolutePath() + " failed."));
                }
            } else {
                log.warn((Object)("Rename of file " + from.getAbsolutePath() + " to " + to.getAbsolutePath() + " failed but from no longer exists?"));
            }
        }
    }

    public SpyMessage[] restore(TreeSet rollBackTXs) throws JMSException {
        TreeMap messageIndex = new TreeMap();
        try {
            File[] files = this.queueName.listFiles();
            int i = 0;
            while (i < files.length) {
                String fileName = files[i].getName();
                int extIndex = fileName.indexOf(".");
                if (extIndex < 0) {
                    this.restoreMessageFromFile(messageIndex, files[i]);
                } else {
                    Long tx = new Long(Long.parseLong(fileName.substring(extIndex + 1)));
                    if (rollBackTXs.contains(tx)) {
                        this.delete(files[i]);
                    } else {
                        this.restoreMessageFromFile(messageIndex, files[i]);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.throwJMSException("Could not rebuild the queue from the queue's tranaction log.", e);
        }
        SpyMessage[] rc = new SpyMessage[messageIndex.size()];
        Iterator iter = messageIndex.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            rc[i] = (SpyMessage)iter.next();
            ++i;
        }
        return rc;
    }

    protected void restoreMessageFromFile(TreeMap store, File file) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        long msgId = in.readLong();
        SpyMessage message = SpyMessage.readMessage(in);
        in.close();
        message.messageId = msgId;
        message.persistData = file;
        store.put(new Long(msgId), message);
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }

    public void undoAdd(SpyMessage message, Tx transactionId) throws JMSException {
        try {
            File file = (File)message.persistData;
            this.delete(file);
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public void undoRemove(SpyMessage message, Tx transactionId) throws JMSException {
    }

    protected void writeMessageToFile(SpyMessage message, File file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        out.writeLong(message.messageId);
        SpyMessage.writeMessage(message, out);
        out.flush();
        out.close();
    }
}

