/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;

public class MessageLog {
    protected static DataSource datasource;

    public MessageLog(DataSource datasource, String dest) throws JMSException {
        if (MessageLog.datasource == null) {
            MessageLog.datasource = datasource;
        }
    }

    public void add(SpyMessage message, Tx transactionId) throws JMSException {
        PreparedStatement pstmt = null;
        Connection con = null;
        try {
            try {
                con = datasource.getConnection();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(message);
                byte[] messageAsBytes = baos.toByteArray();
                pstmt = con.prepareStatement("insert into jms_messages (messageid, destination, messageblob) VALUES(?,?,?)");
                ByteArrayInputStream bais = new ByteArrayInputStream(messageAsBytes);
                pstmt.setString(2, ((SpyDestination)message.getJMSDestination()).getName());
                pstmt.setBinaryStream(3, (InputStream)bais, messageAsBytes.length);
                String hexString = null;
                hexString = message.messageId <= 0L ? "-" + Long.toHexString(-1L * message.messageId) : Long.toHexString(message.messageId);
                pstmt.setString(1, hexString);
                pstmt.executeUpdate();
                con.commit();
                pstmt.close();
            }
            catch (IOException e) {
                this.throwJMSException("Could serialize the message.", e);
            }
            catch (SQLException e) {
                this.throwJMSException("Could not write message to the database.", e);
            }
            Object var6_13 = null;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                this.throwJMSException("Could not close the database.", e);
            }
            throw throwable;
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close the database.", e);
        }
    }

    public void close() throws JMSException {
    }

    public void remove(SpyMessage message, Tx transactionId) throws JMSException {
        PreparedStatement pstmt = null;
        Connection con = null;
        try {
            try {
                con = datasource.getConnection();
                pstmt = con.prepareStatement("delete from jms_messages where messageid = ? and destination = ?");
                String hexString = null;
                hexString = message.messageId <= 0L ? "-" + Long.toHexString(-1L * message.messageId) : Long.toHexString(message.messageId);
                pstmt.setString(1, hexString);
                pstmt.setString(2, ((SpyDestination)message.getJMSDestination()).getName().trim());
                pstmt.executeUpdate();
                con.commit();
            }
            catch (SQLException e) {
                this.throwJMSException("Could not remove the message.", e);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                this.throwJMSException("Could not close the database.", e);
            }
            throw throwable;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close the database.", e);
        }
    }

    public SpyMessage[] restore(TreeSet comittingTXs, String dest) throws JMSException {
        String destin = dest.substring(21, dest.length());
        TreeMap<Long, SpyMessage> messageIndex = new TreeMap<Long, SpyMessage>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            try {
                con = datasource.getConnection();
                pstmt = con.prepareStatement("select messageblob, messageid from jms_messages where destination = ?");
                pstmt.setString(1, destin);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    byte[] st = (byte[])rs.getObject(1);
                    ByteArrayInputStream baip = new ByteArrayInputStream(st);
                    ObjectInputStream ois = new ObjectInputStream(baip);
                    SpyMessage message = (SpyMessage)ois.readObject();
                    message.messageId = Long.parseLong(rs.getString(2).trim(), 16);
                    Long msgId = new Long(message.messageId);
                    messageIndex.put(msgId, message);
                }
            }
            catch (SQLException e) {
                this.throwJMSException("SQL error while rebuilding the tranaction log.", e);
            }
            catch (Exception e) {
                this.throwJMSException("Could not rebuild the queue from the queue's tranaction log.", e);
            }
            Object var9_17 = null;
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                this.throwJMSException("SQL error while closing the database connection", e);
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("SQL error while closing the database connection", e);
        }
        SpyMessage[] rc = new SpyMessage[messageIndex.size()];
        Iterator iter = messageIndex.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            rc[i] = (SpyMessage)iter.next();
            ++i;
        }
        return rc;
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }
}

