/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.jdbc.MessageLog;
import org.jboss.mq.pm.jdbc.PersistenceManagerMBean;
import org.jboss.mq.pm.jdbc.TxLog;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSServer;
import org.jboss.util.ServiceMBeanSupport;

public class PersistenceManager
extends ServiceMBeanSupport
implements PersistenceManagerMBean,
org.jboss.mq.pm.PersistenceManager {
    TxLog txLog;
    HashMap messageLogs = new HashMap();
    HashMap transactedTasks = new HashMap();
    TxManager txManager;
    private String jmsDBPoolName;
    protected static DataSource datasource;

    public void add(SpyMessage message, Tx txId) throws JMSException {
        LogInfo logInfo;
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logInfo = (LogInfo)this.messageLogs.get(String.valueOf(String.valueOf(message.getJMSDestination())));
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        System.out.println("PM.add(), add message: " + message + ", Tx ID: " + txId);
        logInfo.log.add(message, txId);
        if (txId != null) {
            LinkedList tasks;
            Cloneable cloneable = this.transactedTasks;
            synchronized (cloneable) {
                tasks = (LinkedList)this.transactedTasks.get(txId);
            }
            if (tasks == null) {
                throw new JMSException("Transaction is not active 5.");
            }
            cloneable = tasks;
            synchronized (cloneable) {
                tasks.addLast(new Transaction(true, logInfo, message, txId));
            }
        }
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        LinkedList transacted;
        Cloneable cloneable = this.transactedTasks;
        synchronized (cloneable) {
            transacted = (LinkedList)this.transactedTasks.remove(txId);
        }
        cloneable = transacted;
        synchronized (cloneable) {
            Iterator iter = transacted.iterator();
            while (iter.hasNext()) {
                Transaction task = (Transaction)iter.next();
                task.commit();
            }
        }
        this.txLog.commitTx(txId);
    }

    public Tx createPersistentTx() throws JMSException {
        Tx txId = this.txLog.createTx();
        HashMap hashMap = this.transactedTasks;
        synchronized (hashMap) {
            this.transactedTasks.put(txId, new LinkedList());
        }
        return txId;
    }

    public void destroyQueue(SpyDestination dest) throws JMSException {
        try {
            LogInfo logInfo;
            HashMap hashMap = this.messageLogs;
            synchronized (hashMap) {
                logInfo = (LogInfo)this.messageLogs.remove(String.valueOf(String.valueOf(dest)));
            }
            if (logInfo == null) {
                throw new SpyJMSException("The persistence log was never initialized");
            }
            logInfo.log.close();
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            JMSException newE = new JMSException("Invalid configuration.");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    public String getJmsDBPoolName() {
        return this.jmsDBPoolName;
    }

    public String getName() {
        return "JBossMQ-PersistenceManager";
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    /*
     * WARNING - void declaration
     */
    public void initQueue(SpyDestination dest) throws JMSException {
        try {
            MessageLog log = new MessageLog(datasource, dest.toString());
            LogInfo info = new LogInfo(log, dest);
            HashMap hashMap = this.messageLogs;
            synchronized (hashMap) {
                this.messageLogs.put(String.valueOf(String.valueOf(dest)), info);
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            void info;
            JMSException newE = new JMSException("Invalid configuration.");
            newE.setLinkedException(e);
            throw info;
        }
    }

    public void initService() throws Exception {
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        server.setPersistenceManager(this);
    }

    public void remove(SpyMessage message, Tx txId) throws JMSException {
        LogInfo logInfo;
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logInfo = (LogInfo)this.messageLogs.get(String.valueOf(String.valueOf(message.getJMSDestination())));
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        if (txId == null) {
            logInfo.log.remove(message, txId);
        } else {
            LinkedList tasks;
            Cloneable cloneable = this.transactedTasks;
            synchronized (cloneable) {
                tasks = (LinkedList)this.transactedTasks.get(txId);
            }
            if (tasks == null) {
                throw new JMSException("Transaction is not active 6.");
            }
            cloneable = tasks;
            synchronized (cloneable) {
                tasks.addLast(new Transaction(false, logInfo, message, txId));
            }
        }
    }

    public void restore(JMSServer server) throws JMSException {
        HashMap clone;
        TreeSet committingTXs = this.txLog.restore();
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            clone = (HashMap)this.messageLogs.clone();
        }
        Iterator iter = clone.values().iterator();
        while (iter.hasNext()) {
            LogInfo logInfo = (LogInfo)iter.next();
            JMSDestination q = server.getJMSDestination(logInfo.destination);
            SpyMessage[] rebuild = logInfo.log.restore(committingTXs, q.toString());
            JMSDestination jMSDestination = q;
            synchronized (jMSDestination) {
                int i = 0;
                while (i < rebuild.length) {
                    q.restoreMessage(rebuild[i]);
                    ++i;
                }
            }
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        LinkedList transacted;
        Cloneable cloneable = this.transactedTasks;
        synchronized (cloneable) {
            transacted = (LinkedList)this.transactedTasks.remove(txId);
        }
        cloneable = transacted;
        synchronized (cloneable) {
            Iterator iter = transacted.iterator();
            while (iter.hasNext()) {
                Transaction task = (Transaction)iter.next();
                task.rollback();
            }
        }
        this.txLog.rollbackTx(txId);
    }

    public void setJmsDBPoolName(String newJmsDBPoolName) {
        this.jmsDBPoolName = newJmsDBPoolName;
        this.txManager = new TxManager(this);
    }

    public void startService() throws Exception {
        InitialContext ctx = new InitialContext();
        datasource = (DataSource)ctx.lookup(this.jmsDBPoolName);
        this.txLog = new TxLog(datasource);
        Iterator iter = this.messageLogs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            LogInfo info = (LogInfo)entry.getValue();
            MessageLog log = info.log;
            MessageLog.datasource = datasource;
        }
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        this.restore(server);
    }

    class Transaction {
        private LogInfo logInfo;
        private SpyMessage message;
        private Tx txId;
        private boolean add;

        public Transaction(boolean add, LogInfo logInfo, SpyMessage message, Tx txId) {
            this.add = add;
            this.logInfo = logInfo;
            this.message = message;
            this.txId = txId;
        }

        public void commit() throws JMSException {
            if (!this.add) {
                this.logInfo.log.remove(this.message, this.txId);
            }
        }

        public void rollback() throws JMSException {
            if (this.add) {
                this.logInfo.log.remove(this.message, this.txId);
            }
        }
    }

    static class LogInfo {
        MessageLog log;
        SpyDestination destination;

        LogInfo(MessageLog log, SpyDestination destination) {
            this.log = log;
            this.destination = destination;
        }
    }
}

