/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.rollinglogged;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.TreeSet;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;

public class IntegrityLog {
    private RandomAccessFile raf;
    private File f;
    private ObjectOutput objectOutput;
    protected static final byte TX = 0;
    protected static final byte ADD = 1;
    protected static final byte REMOVE = 2;

    public IntegrityLog(String fileName) throws IOException {
        this.f = new File(fileName);
        this.raf = new RandomAccessFile(this.f, "rw");
        this.objectOutput = new MyObjectOutputStream(new MyOutputStream());
        this.seekEnd();
    }

    public synchronized void add(long messageID, boolean isTransacted, long txId, SpyMessage message) throws IOException {
        this.raf.writeByte(1);
        this.raf.writeLong(messageID);
        this.raf.writeBoolean(isTransacted);
        this.raf.writeLong(txId);
        SpyMessage.writeMessage(message, this.objectOutput);
        this.objectOutput.flush();
    }

    public synchronized void addTx(Tx tx) throws IOException {
        this.raf.writeByte(0);
        this.raf.writeLong(tx.longValue());
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    public void commit() throws IOException {
    }

    public void delete() throws IOException {
        if (this.f != null) {
            this.f.delete();
        }
        this.f = null;
    }

    public Object readNextEntry(ObjectInput in) throws IOException {
        byte type = this.raf.readByte();
        switch (type) {
            case 0: {
                return new Tx(this.raf.readLong());
            }
            case 1: {
                MessageAddedRecord add = new MessageAddedRecord();
                add.messageId = this.raf.readLong();
                add.isTransacted = this.raf.readBoolean();
                add.transactionId = this.raf.readLong();
                add.message = SpyMessage.readMessage(in);
                return add;
            }
            case 2: {
                MessageRemovedRecord remove = new MessageRemovedRecord();
                remove.messageId = this.raf.readLong();
                remove.isTransacted = this.raf.readBoolean();
                remove.transactionId = this.raf.readLong();
                return remove;
            }
        }
        throw new IOException("Error in log file format.");
    }

    public synchronized void remove(long messageID, boolean isTransacted, long txId) throws IOException {
        this.raf.writeByte(2);
        this.raf.writeLong(messageID);
        this.raf.writeBoolean(isTransacted);
        this.raf.writeLong(txId);
    }

    private void seekEnd() throws IOException {
        this.raf.seek(0L);
        long length = this.raf.length();
        long pos = 0L;
        MyObjectInputStream in = new MyObjectInputStream(new MyInputStream());
        try {
            while (pos < length) {
                this.skipNextEntry(in);
                pos = this.raf.getFilePointer();
            }
        }
        catch (EOFException eOFException) {}
        in.close();
        this.raf.seek(pos);
    }

    public void skipNextEntry(ObjectInput in) throws IOException {
        byte type = this.raf.readByte();
        switch (type) {
            case 0: {
                this.raf.readLong();
                return;
            }
            case 1: {
                this.raf.readLong();
                this.raf.readBoolean();
                this.raf.readLong();
                SpyMessage.readMessage(in);
                return;
            }
            case 2: {
                this.raf.readLong();
                this.raf.readBoolean();
                this.raf.readLong();
                return;
            }
        }
        throw new IOException("Error in log file format.");
    }

    public LinkedList toIndex() throws IOException {
        this.raf.seek(0L);
        long length = this.raf.length();
        long pos = 0L;
        MyObjectInputStream in = new MyObjectInputStream(new MyInputStream());
        LinkedList<Object> ll = new LinkedList<Object>();
        try {
            while (pos < length) {
                ll.add(this.readNextEntry(in));
                pos = this.raf.getFilePointer();
            }
        }
        catch (EOFException eOFException) {}
        in.close();
        this.raf.seek(pos);
        return ll;
    }

    public String toString() {
        return "IntegrityLog [ file: " + this.f + " ]";
    }

    public TreeSet toTreeSet() throws IOException {
        this.raf.seek(0L);
        long length = this.raf.length();
        long pos = 0L;
        MyObjectInputStream in = new MyObjectInputStream(new MyInputStream());
        TreeSet<Object> ll = new TreeSet<Object>();
        try {
            while (pos < length) {
                ll.add(this.readNextEntry(in));
                pos = this.raf.getFilePointer();
            }
        }
        catch (EOFException eOFException) {}
        in.close();
        this.raf.seek(pos);
        return ll;
    }

    class MyOutputStream
    extends OutputStream {
        MyOutputStream() {
        }

        public void close() throws IOException {
            this.flush();
        }

        public void write(int b) throws IOException {
            IntegrityLog.this.raf.write((byte)b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            IntegrityLog.this.raf.write(bytes, off, len);
        }
    }

    class MyObjectOutputStream
    extends ObjectOutputStream {
        MyObjectOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        protected void writeStreamHeader() {
        }
    }

    class MyObjectInputStream
    extends ObjectInputStream {
        MyObjectInputStream(InputStream is) throws IOException {
            super(is);
        }

        protected void readStreamHeader() {
        }
    }

    class MyInputStream
    extends InputStream {
        MyInputStream() {
        }

        public void close() throws IOException {
        }

        public int read() throws IOException {
            return IntegrityLog.this.raf.read();
        }

        public int read(byte[] bytes, int off, int len) throws IOException {
            return IntegrityLog.this.raf.read(bytes, off, len);
        }
    }

    class MessageAddedRecord
    implements Serializable {
        long messageId;
        boolean isTransacted;
        long transactionId;
        SpyMessage message;
        private static final long serialVersionUID = 235726945332013954L;

        MessageAddedRecord() {
        }
    }

    class MessageRemovedRecord
    implements Serializable {
        boolean isTransacted;
        long transactionId;
        long messageId;
        private static final long serialVersionUID = 235726945332013955L;

        MessageRemovedRecord() {
        }
    }
}

