/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.rollinglogged;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.rollinglogged.PersistenceManagerMBean;
import org.jboss.mq.pm.rollinglogged.SpyMessageLog;
import org.jboss.mq.pm.rollinglogged.SpyTxLog;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSServer;
import org.jboss.util.ServiceMBeanSupport;

public class PersistenceManager
extends ServiceMBeanSupport
implements org.jboss.mq.pm.PersistenceManager,
PersistenceManagerMBean {
    protected ArrayList listPool = new ArrayList();
    protected ArrayList txPool = new ArrayList();
    protected int messageCounter = 0;
    int numRollOvers = 0;
    HashMap queues = new HashMap();
    SpyTxLog currentTxLog;
    long nextTxId = Long.MIN_VALUE;
    HashMap messageLogs = null;
    HashMap transToTxLogs = new HashMap();
    URL dataDirURL;
    TxManager txManager = new TxManager(this);
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$pm$rollinglogged$PersistenceManager != null ? class$org$jboss$mq$pm$rollinglogged$PersistenceManager : (class$org$jboss$mq$pm$rollinglogged$PersistenceManager = PersistenceManager.class$("org.jboss.mq.pm.rollinglogged.PersistenceManager"))));
    private String dataDirectory;
    private int rollOverSize = 1000;
    public static final String TRANS_FILE_NAME = "transactions.dat";
    protected static int MAX_POOL_SIZE = 50;
    static /* synthetic */ Class class$org$jboss$mq$pm$rollinglogged$PersistenceManager;

    public void add(SpyMessage message, Tx txId) throws JMSException {
        LogInfo logInfo;
        HashMap logs;
        if (log.isTraceEnabled()) {
            long id = txId != null ? txId.longValue() : 0L;
            log.trace((Object)("Add message " + Long.toHexString(message.messageId) + "in trans " + Long.toHexString(id) + " to " + message.getJMSDestination()));
        }
        SpyTxLog txLog = null;
        if (txId == null) {
            txLog = this.currentTxLog;
        } else {
            HashMap hashMap = this.transToTxLogs;
            synchronized (hashMap) {
                txLog = ((TxInfo)this.transToTxLogs.get((Object)txId)).log;
            }
        }
        Object object = this.messageLogs;
        synchronized (object) {
            logs = (HashMap)this.messageLogs.get(txLog);
        }
        object = logs;
        synchronized (object) {
            logInfo = (LogInfo)logs.get(message.getJMSDestination().toString());
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        object = logInfo;
        synchronized (object) {
            ++logInfo.liveMessages;
            message.persistData = logInfo;
            logInfo.log.add(message, txId);
        }
        if (txId != null) {
            object = this.transToTxLogs;
            synchronized (object) {
                TxInfo txInfo = (TxInfo)this.transToTxLogs.get(txId);
                txInfo.addMessages.add(message);
            }
        }
        this.checkRollOver();
    }

    protected void checkCleanup(SpyTxLog txLog, boolean rollover) throws JMSException {
        HashMap logs;
        if (txLog == this.currentTxLog) {
            return;
        }
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logs = (HashMap)this.messageLogs.get(txLog);
        }
        boolean liveMessages = false;
        HashMap hashMap2 = logs;
        synchronized (hashMap2) {
            Iterator it = logs.values().iterator();
            while (it.hasNext()) {
                LogInfo info;
                LogInfo logInfo = info = (LogInfo)it.next();
                synchronized (logInfo) {
                    if (info.liveMessages == 0) {
                        if (rollover) {
                            info.log.close();
                            info.log.delete();
                        }
                    } else {
                        liveMessages = true;
                    }
                }
            }
        }
        if (liveMessages || !txLog.completed()) {
            return;
        }
        log.debug((Object)"Cleanign up");
        hashMap2 = this.messageLogs;
        synchronized (hashMap2) {
            logs = (HashMap)this.messageLogs.remove(txLog);
        }
        if (logs == null) {
            return;
        }
        txLog.close();
        txLog.delete();
        Iterator it = logs.values().iterator();
        while (it.hasNext()) {
            LogInfo info = (LogInfo)it.next();
            info.log.close();
            info.log.delete();
        }
    }

    protected void checkRollOver() throws JMSException {
        HashMap hashMap = this.queues;
        synchronized (hashMap) {
            int max = this.queues.size() + 1;
            max = max == 1 ? this.rollOverSize : (max *= this.rollOverSize);
            if (++this.messageCounter > max) {
                this.messageCounter = 0;
                this.rollOverLogs();
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        if (log.isTraceEnabled()) {
            long id = txId != null ? txId.longValue() : 0L;
            log.trace((Object)("Comitting TX " + Long.toHexString(id)));
        }
        TxInfo info = null;
        LinkedList messagesToDelete = null;
        HashMap hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            info = (TxInfo)this.transToTxLogs.remove(txId);
            messagesToDelete = info.ackMessages;
        }
        this.deleteMessages(messagesToDelete);
        info.log.commitTx(txId);
        hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            this.releaseTx(txId);
            this.releaseTxInfo(info);
        }
        this.checkRollOver();
    }

    public Tx createPersistentTx() throws JMSException {
        Tx txId = null;
        SpyTxLog txLog = this.currentTxLog;
        HashMap hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            txId = this.getTx(++this.nextTxId);
            this.transToTxLogs.put(txId, this.getTxInfo(txId, txLog));
        }
        txLog.createTx();
        return txId;
    }

    protected void deleteMessages(LinkedList messages) throws JMSException {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            LogInfo info;
            LogInfo logInfo = info = (LogInfo)((SpyMessage)it.next()).persistData;
            synchronized (logInfo) {
                --info.liveMessages;
            }
            this.checkCleanup(info.txLog, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void destroyQueue(SpyDestination dest) throws JMSException {
        try {
            HashMap logs;
            String key = String.valueOf(String.valueOf(dest));
            this.queues.remove(key);
            SpyMessageLog log = null;
            HashMap hashMap = this.messageLogs;
            synchronized (hashMap) {
                logs = (HashMap)this.messageLogs.get(this.currentTxLog);
            }
            hashMap = logs;
            synchronized (hashMap) {
                LogInfo logInfo = (LogInfo)logs.remove(key);
                log = logInfo.log;
            }
            if (log == null) {
                throw new SpyJMSException("The persistence log was never initialized");
            }
            log.close();
            log.delete();
            HashSet<SpyMessageLog> deleteLogs = new HashSet<SpyMessageLog>();
            HashMap hashMap2 = this.messageLogs;
            synchronized (hashMap2) {
                Iterator it = this.messageLogs.values().iterator();
                while (it.hasNext()) {
                    HashMap hashMap3 = logs = (HashMap)it.next();
                    synchronized (hashMap3) {
                        LogInfo logInfo = (LogInfo)logs.remove(key);
                        log = logInfo.log;
                    }
                    if (log == null) continue;
                    deleteLogs.add(log);
                }
            }
            Iterator it = deleteLogs.iterator();
            while (it.hasNext()) {
                log = (SpyMessageLog)it.next();
                log.close();
                log.delete();
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            void log;
            PersistenceManager.log.error((Object)"destroyQueue throw an exception", (Throwable)e);
            JMSException newE = new JMSException("Invalid configuration.");
            newE.setLinkedException(e);
            throw log;
        }
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public String getName() {
        return "JBossMQ-RollingLogged-PersistenceManager";
    }

    public int getRollOverSize() {
        return this.rollOverSize;
    }

    protected Tx getTx(long value) {
        if (this.txPool.isEmpty()) {
            return new Tx(value);
        }
        Tx tx = (Tx)this.txPool.remove(this.listPool.size() - 1);
        tx.setValue(value);
        return tx;
    }

    protected TxInfo getTxInfo(Tx txId, SpyTxLog txLog) {
        if (this.listPool.isEmpty()) {
            return new TxInfo(txId, txLog);
        }
        TxInfo info = (TxInfo)this.listPool.remove(this.listPool.size() - 1);
        info.txId = txId;
        info.log = txLog;
        return info;
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void initQueue(SpyDestination dest) throws JMSException {
        String key = String.valueOf(String.valueOf(dest));
        this.queues.put(key, dest);
        Object txLog = null;
        if (this.messageLogs == null) {
            return;
        }
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            HashMap<String, LogInfo> logs = (HashMap<String, LogInfo>)this.messageLogs.get(this.currentTxLog);
            if (logs == null) {
                logs = new HashMap<String, LogInfo>();
                this.messageLogs.put(this.currentTxLog, logs);
            }
            HashMap<String, LogInfo> hashMap2 = logs;
            synchronized (hashMap2) {
                LogInfo logInfo = (LogInfo)logs.get(dest.toString());
                if (logInfo == null) {
                    try {
                        SpyMessageLog log = new SpyMessageLog(new URL(this.dataDirURL, String.valueOf(dest.toString()) + ".dat" + this.numRollOvers).getFile());
                        logInfo = new LogInfo(log, dest, this.currentTxLog);
                        logs.put(String.valueOf(String.valueOf(dest)), logInfo);
                    }
                    catch (MalformedURLException e) {
                        SpyJMSException jme = new SpyJMSException("Error rolling over logs to new files.");
                        jme.setLinkedException(e);
                        throw jme;
                    }
                }
            }
        }
    }

    public void initService() throws Exception {
        log.debug((Object)"Using rolling logged persistence manager.");
        URL configFile = this.getClass().getClassLoader().getResource("jboss.jcml");
        this.dataDirURL = new URL(configFile, this.dataDirectory);
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        server.setPersistenceManager(this);
    }

    protected void releaseTx(Tx tx) {
        if (this.txPool.size() < MAX_POOL_SIZE) {
            this.txPool.add(tx);
        }
    }

    protected void releaseTxInfo(TxInfo list) {
        if (this.listPool.size() < MAX_POOL_SIZE) {
            list.ackMessages.clear();
            list.addMessages.clear();
            this.listPool.add(list);
        }
    }

    public void remove(SpyMessage message, Tx txId) throws JMSException {
        LogInfo logInfo;
        if (log.isTraceEnabled()) {
            long id = txId != null ? txId.longValue() : 0L;
            log.trace((Object)("Removing message " + Long.toHexString(message.messageId) + " in trans " + Long.toHexString(id) + " from " + message.getJMSDestination()));
        }
        SpyTxLog txLog = ((LogInfo)message.persistData).txLog;
        Object object = this.messageLogs;
        synchronized (object) {
            HashMap logs = (HashMap)this.messageLogs.get(txLog);
            logInfo = (LogInfo)logs.get(message.getJMSDestination().toString());
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        object = logInfo.log;
        synchronized (object) {
            logInfo.log.remove(message, txId);
        }
        if (txId != null) {
            object = this.transToTxLogs;
            synchronized (object) {
                TxInfo txInfo = (TxInfo)this.transToTxLogs.get(txId);
                txInfo.ackMessages.add(message);
            }
        }
        if (txId == null) {
            object = logInfo;
            synchronized (object) {
                --logInfo.liveMessages;
            }
            this.checkCleanup(txLog, false);
        }
    }

    public void restore(JMSServer server) throws JMSException {
        String key;
        TreeSet commitedTxs = new TreeSet();
        HashMap<Integer, SpyTxLog> txLogs = new HashMap<Integer, SpyTxLog>();
        File dir = new File(this.dataDirURL.getFile());
        File[] dataFiles = dir.listFiles();
        this.messageLogs = new HashMap();
        int i = 0;
        while (i < dataFiles.length) {
            int index;
            String name = dataFiles[i].getName();
            if (name.startsWith(TRANS_FILE_NAME) && (index = name.indexOf(".dat")) >= 0) {
                String sRollOver = name.substring(index + 4);
                int rollOver = Integer.parseInt(sRollOver);
                this.numRollOvers = Math.max(this.numRollOvers, rollOver + 1);
                SpyTxLog txLog = new SpyTxLog(dataFiles[i].getAbsolutePath());
                txLog.restore(commitedTxs);
                txLogs.put(new Integer(rollOver), txLog);
                this.messageLogs.put(txLog, new HashMap());
            }
            ++i;
        }
        if (!commitedTxs.isEmpty()) {
            this.nextTxId = ((Tx)commitedTxs.last()).longValue();
        }
        int i2 = 0;
        while (i2 < dataFiles.length) {
            int index;
            String name = dataFiles[i2].getName();
            if (!name.startsWith(TRANS_FILE_NAME) && (index = name.indexOf(".dat")) >= 0) {
                String sRollOver = name.substring(index + 4);
                int rollOver = Integer.parseInt(sRollOver);
                key = name.substring(0, name.length() - (sRollOver.length() + 4));
                SpyMessageLog messageLog = new SpyMessageLog(dataFiles[i2].getAbsolutePath());
                SpyMessage[] messages = messageLog.restore(commitedTxs);
                SpyTxLog txLog = (SpyTxLog)txLogs.get(new Integer(rollOver));
                SpyDestination dest = (SpyDestination)this.queues.get(key);
                if (dest != null) {
                    JMSDestination q = server.getJMSDestination(dest);
                    LogInfo info = new LogInfo(messageLog, dest, txLog);
                    info.liveMessages = messages.length;
                    HashMap logs = (HashMap)this.messageLogs.get(txLog);
                    logs.put(key, info);
                    JMSDestination jMSDestination = q;
                    synchronized (jMSDestination) {
                        int j = 0;
                        while (j < messages.length) {
                            messages[j].persistData = info;
                            q.restoreMessage(messages[j]);
                            ++j;
                        }
                    }
                }
            }
            ++i2;
        }
        Iterator it = txLogs.values().iterator();
        while (it.hasNext()) {
            this.checkCleanup((SpyTxLog)it.next(), false);
        }
        try {
            URL txLogFile = new URL(this.dataDirURL, TRANS_FILE_NAME + this.numRollOvers);
            this.currentTxLog = new SpyTxLog(txLogFile.getFile());
            this.messageLogs.put(this.currentTxLog, new HashMap());
            Iterator it2 = this.queues.values().iterator();
            while (it2.hasNext()) {
                SpyDestination dest = (SpyDestination)it2.next();
                key = String.valueOf(String.valueOf(dest));
                URL logFile = new URL(this.dataDirURL, String.valueOf(dest.toString()) + ".dat" + this.numRollOvers);
                SpyMessageLog log = new SpyMessageLog(logFile.getFile());
                HashMap hashMap = this.messageLogs;
                synchronized (hashMap) {
                    LogInfo logInfo = new LogInfo(log, dest, this.currentTxLog);
                    HashMap logs = (HashMap)this.messageLogs.get(this.currentTxLog);
                    logs.put(key, logInfo);
                }
            }
        }
        catch (Exception e) {
            JMSException newE = new JMSException("Invalid configuration.");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void rollOverLogs() throws JMSException {
        try {
            HashMap<String, LogInfo> logs = new HashMap<String, LogInfo>();
            ++this.numRollOvers;
            SpyTxLog newTxLog = new SpyTxLog(new URL(this.dataDirURL, TRANS_FILE_NAME + this.numRollOvers).getFile());
            Iterator it = this.queues.values().iterator();
            while (it.hasNext()) {
                SpyDestination dest = (SpyDestination)it.next();
                SpyMessageLog log = new SpyMessageLog(new URL(this.dataDirURL, String.valueOf(dest.toString()) + ".dat" + this.numRollOvers).getFile());
                LogInfo logInfo = new LogInfo(log, dest, newTxLog);
                logs.put(String.valueOf(String.valueOf(dest)), logInfo);
            }
            SpyTxLog oldLog = this.currentTxLog;
            HashMap hashMap = this.messageLogs;
            synchronized (hashMap) {
                this.currentTxLog = newTxLog;
                this.messageLogs.put(newTxLog, logs);
            }
            this.checkCleanup(oldLog, true);
        }
        catch (MalformedURLException e) {
            void newTxLog;
            SpyJMSException jme = new SpyJMSException("Error rolling over logs to new files.");
            jme.setLinkedException(e);
            throw newTxLog;
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        TxInfo info = null;
        LinkedList messagesToDelete = null;
        HashMap hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            info = (TxInfo)this.transToTxLogs.remove(txId);
            messagesToDelete = info.addMessages;
        }
        this.deleteMessages(messagesToDelete);
        info.log.rollbackTx(txId);
        hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            this.releaseTx(txId);
            this.releaseTxInfo(info);
        }
        this.checkCleanup(info.log, false);
    }

    public void setDataDirectory(String newDataDirectory) {
        this.dataDirectory = newDataDirectory;
    }

    public void setRollOverSize(int rollOverSize) {
        this.rollOverSize = rollOverSize;
    }

    public void startService() throws Exception {
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        this.restore(server);
    }

    static class LogInfo {
        SpyMessageLog log;
        SpyDestination destination;
        int liveMessages = 0;
        SpyTxLog txLog;

        LogInfo(SpyMessageLog log, SpyDestination destination, SpyTxLog txLog) {
            this.log = log;
            this.destination = destination;
            this.txLog = txLog;
        }
    }

    static class TxInfo {
        Tx txId;
        LinkedList addMessages = new LinkedList();
        LinkedList ackMessages = new LinkedList();
        SpyTxLog log;

        TxInfo(Tx txId, SpyTxLog log) {
            this.txId = txId;
            this.log = log;
        }
    }
}

