/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.selectors;

import gnu.regexp.RE;
import gnu.regexp.RESyntax;
import java.util.HashSet;
import org.jboss.mq.selectors.Identifier;

public class Operator {
    int operation;
    Object oper1;
    Object oper2;
    Object oper3;
    Object arg1;
    Object arg2;
    Object arg3;
    int class1;
    int class2;
    int class3;
    public static final int EQUAL = 0;
    public static final int NOT = 1;
    public static final int AND = 2;
    public static final int OR = 3;
    public static final int GT = 4;
    public static final int GE = 5;
    public static final int LT = 6;
    public static final int LE = 7;
    public static final int DIFFERENT = 8;
    public static final int ADD = 9;
    public static final int SUB = 10;
    public static final int NEG = 11;
    public static final int MUL = 12;
    public static final int DIV = 13;
    public static final int BETWEEN = 14;
    public static final int NOT_BETWEEN = 15;
    public static final int LIKE = 16;
    public static final int NOT_LIKE = 17;
    public static final int LIKE_ESCAPE = 18;
    public static final int NOT_LIKE_ESCAPE = 19;
    public static final int IS_NULL = 20;
    public static final int IS_NOT_NULL = 21;
    public static final int IN = 22;
    public static final int NOT_IN = 23;
    public static final int STRING = 0;
    public static final int DOUBLE = 1;
    public static final int LONG = 2;
    public static final int BOOLEAN = 3;
    static /* synthetic */ Class class$org$jboss$mq$selectors$Identifier;
    static /* synthetic */ Class class$org$jboss$mq$selectors$Operator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;

    public Operator(int operation, Object oper1) {
        this.operation = operation;
        this.oper1 = oper1;
        this.oper2 = null;
        this.oper3 = null;
    }

    public Operator(int operation, Object oper1, Object oper2) {
        this.operation = operation;
        this.oper1 = oper1;
        this.oper2 = oper2;
        this.oper3 = null;
    }

    public Operator(int operation, Object oper1, Object oper2, Object oper3) {
        this.operation = operation;
        this.oper1 = oper1;
        this.oper2 = oper2;
        this.oper3 = oper3;
    }

    Object add() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return new Double((Double)this.arg1 + (Double)this.arg2);
                    }
                    case 2: {
                        return new Double((Double)this.arg1 + ((Long)this.arg2).doubleValue());
                    }
                }
                throw new Exception("ADD: Bad object type");
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return new Double(((Long)this.arg1).doubleValue() + (Double)this.arg2);
                    }
                    case 2: {
                        return new Long((Long)this.arg1 + (Long)this.arg2);
                    }
                }
                throw new Exception("ADD: Bad object type");
            }
        }
        throw new Exception("ADD: Bad object type");
    }

    Object and() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 != 3) {
                throw new Exception("AND: Bad object type");
            }
            if (!((Boolean)this.arg2).booleanValue()) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.class1 == 3) {
            if (!((Boolean)this.arg1).booleanValue()) {
                return Boolean.FALSE;
            }
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 != 3) {
                throw new Exception("AND: Bad object type");
            }
            return this.arg2;
        }
        throw new Exception("AND: Bad object type");
    }

    Object apply() throws Exception {
        switch (this.operation) {
            case 0: {
                return this.equal();
            }
            case 1: {
                return this.not();
            }
            case 2: {
                return this.and();
            }
            case 3: {
                return this.or();
            }
            case 4: {
                return this.gt();
            }
            case 5: {
                return this.ge();
            }
            case 6: {
                return this.lt();
            }
            case 7: {
                return this.le();
            }
            case 8: {
                return this.different();
            }
            case 9: {
                return this.add();
            }
            case 10: {
                return this.sub();
            }
            case 11: {
                return this.neg();
            }
            case 12: {
                return this.mul();
            }
            case 13: {
                return this.div();
            }
            case 14: {
                return this.between();
            }
            case 15: {
                return this.not_between();
            }
            case 16: {
                return this.like(false, false);
            }
            case 17: {
                return this.like(true, false);
            }
            case 18: {
                return this.like(false, true);
            }
            case 19: {
                return this.like(true, true);
            }
            case 20: {
                return this.is_null();
            }
            case 21: {
                return this.is_not_null();
            }
            case 22: {
                return this.in();
            }
            case 23: {
                return this.not_in();
            }
        }
        throw new Exception("Unknown operation");
    }

    Object between() throws Exception {
        Object res = this.ge();
        if (res == null) {
            return null;
        }
        if (!((Boolean)res).booleanValue()) {
            return res;
        }
        Object oper4 = this.oper2;
        this.oper2 = this.oper3;
        res = this.le();
        this.oper2 = oper4;
        return res;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void computeArgument1() throws Exception {
        Class<?> className = this.oper1.getClass();
        this.arg1 = className == (class$org$jboss$mq$selectors$Identifier != null ? class$org$jboss$mq$selectors$Identifier : (class$org$jboss$mq$selectors$Identifier = Operator.class$("org.jboss.mq.selectors.Identifier"))) ? ((Identifier)this.oper1).value : (className == (class$org$jboss$mq$selectors$Operator != null ? class$org$jboss$mq$selectors$Operator : (class$org$jboss$mq$selectors$Operator = Operator.class$("org.jboss.mq.selectors.Operator"))) ? ((Operator)this.oper1).apply() : this.oper1);
        if (this.arg1 == null) {
            this.class1 = 0;
            return;
        }
        className = this.arg1.getClass();
        if (className == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Operator.class$("java.lang.String")))) {
            this.class1 = 0;
        } else if (className == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = Operator.class$("java.lang.Double")))) {
            this.class1 = 1;
        } else if (className == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = Operator.class$("java.lang.Long")))) {
            this.class1 = 2;
        } else if (className == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Operator.class$("java.lang.Integer")))) {
            this.class1 = 2;
            this.arg1 = new Long(((Integer)this.arg1).longValue());
        } else if (className == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = Operator.class$("java.lang.Short")))) {
            this.class1 = 2;
            this.arg1 = new Long(((Short)this.arg1).longValue());
        } else if (className == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = Operator.class$("java.lang.Byte")))) {
            this.class1 = 2;
            this.arg1 = new Long(((Byte)this.arg1).longValue());
        } else if (className == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = Operator.class$("java.lang.Float")))) {
            this.class1 = 1;
            this.arg1 = new Double(((Float)this.arg1).doubleValue());
        } else if (className == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = Operator.class$("java.lang.Boolean")))) {
            this.class1 = 3;
        } else {
            throw new Exception("ARG1: Bad object type");
        }
    }

    void computeArgument2() throws Exception {
        Class<?> className = this.oper2.getClass();
        this.arg2 = className == (class$org$jboss$mq$selectors$Identifier != null ? class$org$jboss$mq$selectors$Identifier : (class$org$jboss$mq$selectors$Identifier = Operator.class$("org.jboss.mq.selectors.Identifier"))) ? ((Identifier)this.oper2).value : (className == (class$org$jboss$mq$selectors$Operator != null ? class$org$jboss$mq$selectors$Operator : (class$org$jboss$mq$selectors$Operator = Operator.class$("org.jboss.mq.selectors.Operator"))) ? ((Operator)this.oper2).apply() : this.oper2);
        if (this.arg2 == null) {
            this.class2 = 0;
            return;
        }
        className = this.arg2.getClass();
        if (className == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Operator.class$("java.lang.String")))) {
            this.class2 = 0;
        } else if (className == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = Operator.class$("java.lang.Double")))) {
            this.class2 = 1;
        } else if (className == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = Operator.class$("java.lang.Long")))) {
            this.class2 = 2;
        } else if (className == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Operator.class$("java.lang.Integer")))) {
            this.class2 = 2;
            this.arg2 = new Long(((Integer)this.arg2).longValue());
        } else if (className == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = Operator.class$("java.lang.Short")))) {
            this.class2 = 2;
            this.arg2 = new Long(((Short)this.arg2).longValue());
        } else if (className == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = Operator.class$("java.lang.Byte")))) {
            this.class2 = 2;
            this.arg2 = new Long(((Byte)this.arg2).longValue());
        } else if (className == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = Operator.class$("java.lang.Float")))) {
            this.class2 = 1;
            this.arg2 = new Double(((Float)this.arg2).doubleValue());
        } else if (className == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = Operator.class$("java.lang.Boolean")))) {
            this.class2 = 3;
        } else {
            throw new Exception("ARG2: Bad object type");
        }
    }

    void computeArgument3() throws Exception {
        Class<?> className = this.oper3.getClass();
        this.arg3 = className == (class$org$jboss$mq$selectors$Identifier != null ? class$org$jboss$mq$selectors$Identifier : (class$org$jboss$mq$selectors$Identifier = Operator.class$("org.jboss.mq.selectors.Identifier"))) ? ((Identifier)this.oper3).value : (className == (class$org$jboss$mq$selectors$Operator != null ? class$org$jboss$mq$selectors$Operator : (class$org$jboss$mq$selectors$Operator = Operator.class$("org.jboss.mq.selectors.Operator"))) ? ((Operator)this.oper3).apply() : this.oper3);
        if (this.arg3 == null) {
            this.class3 = 0;
            return;
        }
        className = this.arg3.getClass();
        if (className == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Operator.class$("java.lang.String")))) {
            this.class3 = 0;
        } else if (className == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = Operator.class$("java.lang.Double")))) {
            this.class3 = 1;
        } else if (className == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = Operator.class$("java.lang.Long")))) {
            this.class3 = 2;
        } else if (className == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Operator.class$("java.lang.Integer")))) {
            this.class3 = 2;
            this.arg3 = new Long(((Integer)this.arg3).longValue());
        } else if (className == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = Operator.class$("java.lang.Short")))) {
            this.class3 = 2;
            this.arg3 = new Long(((Short)this.arg3).longValue());
        } else if (className == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = Operator.class$("java.lang.Byte")))) {
            this.class3 = 2;
            this.arg3 = new Long(((Byte)this.arg3).longValue());
        } else if (className == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = Operator.class$("java.lang.Float")))) {
            this.class3 = 1;
            this.arg3 = new Double(((Float)this.arg3).doubleValue());
        } else if (className == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = Operator.class$("java.lang.Boolean")))) {
            this.class3 = 3;
        } else {
            throw new Exception("ARG3: Bad object type");
        }
    }

    Object different() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.FALSE;
        }
        switch (this.class1) {
            case 0: 
            case 1: 
            case 2: {
                this.computeArgument2();
                if (this.arg2 == null) {
                    return Boolean.FALSE;
                }
                if (this.class2 != this.class1) {
                    throw new Exception("DIFFERENT: Bad object type");
                }
                return new Boolean(this.arg1.equals(this.arg2) ^ true);
            }
        }
        throw new Exception("DIFFERENT: Bad object type");
    }

    Object div() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return new Double((Double)this.arg1 / (Double)this.arg2);
                    }
                    case 2: {
                        return new Double((Double)this.arg1 / ((Long)this.arg2).doubleValue());
                    }
                }
                throw new Exception("DIV: Bad object type");
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return new Double(((Long)this.arg1).doubleValue() / (Double)this.arg2);
                    }
                    case 2: {
                        return new Long((Long)this.arg1 / (Long)this.arg2);
                    }
                }
                throw new Exception("DIV: Bad object type");
            }
        }
        throw new Exception("DIV: Bad object type");
    }

    Object equal() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.FALSE;
        }
        switch (this.class1) {
            case 0: 
            case 1: 
            case 2: {
                this.computeArgument2();
                if (this.arg2 == null) {
                    return Boolean.FALSE;
                }
                if (this.class2 != this.class1) {
                    throw new Exception("EQUAL: Bad object type");
                }
                return new Boolean(this.arg1.equals(this.arg2));
            }
        }
        throw new Exception("EQUAL: Bad object type");
    }

    Object ge() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.FALSE;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 2) {
                throw new Exception("GE: Bad object type");
            }
            return new Boolean((Long)this.arg1 >= (Long)this.arg2);
        }
        if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 1) {
                throw new Exception("GE: Bad object type");
            }
            return new Boolean((Double)this.arg1 >= (Double)this.arg2);
        }
        throw new Exception("GE: Bad object type");
    }

    Object gt() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.FALSE;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 2) {
                throw new Exception("GT: Bad object type");
            }
            return new Boolean((Long)this.arg1 > (Long)this.arg2);
        }
        if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 1) {
                throw new Exception("GT: Bad object type");
            }
            return new Boolean((Double)this.arg1 > (Double)this.arg2);
        }
        throw new Exception("GT: Bad object type");
    }

    Object in() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (((HashSet)this.oper2).contains(this.arg1)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Object is_not_null() throws Exception {
        this.computeArgument1();
        if (this.arg1 != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Object is_null() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Object le() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.FALSE;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 2) {
                throw new Exception("LE: Bad object type");
            }
            return new Boolean((Long)this.arg1 <= (Long)this.arg2);
        }
        if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 1) {
                throw new Exception("LE: Bad object type");
            }
            return new Boolean((Double)this.arg1 <= (Double)this.arg2);
        }
        throw new Exception("LE: Bad object type");
    }

    Object like(boolean not, boolean use_escape) throws Exception {
        Character escapeChar = null;
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 != 0) {
            throw new Exception("LIKE: Bad object type");
        }
        this.computeArgument2();
        if (this.arg2 == null) {
            return null;
        }
        if (this.class2 != 0) {
            throw new Exception("LIKE: Bad object type");
        }
        if (use_escape) {
            this.computeArgument3();
            if (this.arg3 == null) {
                return null;
            }
            if (this.class3 != 0) {
                throw new Exception("LIKE: Bad object type");
            }
            StringBuffer escapeBuf = new StringBuffer((String)this.arg3);
            if (escapeBuf.length() != 1) {
                throw new Exception("LIKE ESCAPE: Bad escape character");
            }
            escapeChar = new Character(escapeBuf.charAt(0));
        }
        StringBuffer patternBuf = new StringBuffer((String)this.arg2);
        StringBuffer REpattern = new StringBuffer("^");
        int i = 0;
        while (i < patternBuf.length()) {
            boolean escaped = false;
            char c = patternBuf.charAt(i);
            if (use_escape && escapeChar != null && escapeChar.charValue() == c) {
                if (i + 1 < patternBuf.length()) {
                    escaped = true;
                    c = patternBuf.charAt(++i);
                } else {
                    throw new Exception("LIKE ESCAPE: Bad use of escape character");
                }
            }
            switch (c) {
                case '_': {
                    if (escaped) {
                        REpattern.append(c);
                        break;
                    }
                    REpattern.append('.');
                    break;
                }
                case '%': {
                    if (escaped) {
                        REpattern.append(c);
                        break;
                    }
                    REpattern.append(".*");
                    break;
                }
                case '$': 
                case '*': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    REpattern.append("\\" + c);
                    break;
                }
                default: {
                    REpattern.append(c);
                    break;
                }
            }
            ++i;
        }
        REpattern.append('$');
        RE re = new RE((Object)REpattern, 0, RESyntax.RE_SYNTAX_POSIX_MINIMAL_BASIC);
        boolean result = re.isMatch(this.arg1);
        if (not) {
            result ^= true;
        }
        return new Boolean(result);
    }

    Object lt() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return Boolean.FALSE;
        }
        if (this.class1 == 2) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 2) {
                throw new Exception("LT: Bad object type");
            }
            return new Boolean((Long)this.arg1 < (Long)this.arg2);
        }
        if (this.class1 == 1) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return Boolean.FALSE;
            }
            if (this.class2 != 1) {
                throw new Exception("LT: Bad object type");
            }
            return new Boolean((Double)this.arg1 < (Double)this.arg2);
        }
        throw new Exception("LT: Bad object type");
    }

    Object mul() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return new Double((Double)this.arg1 * (Double)this.arg2);
                    }
                    case 2: {
                        return new Double((Double)this.arg1 * ((Long)this.arg2).doubleValue());
                    }
                }
                throw new Exception("MUL: Bad object type");
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return new Double(((Long)this.arg1).doubleValue() * (Double)this.arg2);
                    }
                    case 2: {
                        return new Long((Long)this.arg1 * (Long)this.arg2);
                    }
                }
                throw new Exception("MUL: Bad object type");
            }
        }
        throw new Exception("MUL: Bad object type");
    }

    Object neg() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                return new Double(-((Double)this.arg1).doubleValue());
            }
            case 2: {
                return new Long(-((Long)this.arg1).longValue());
            }
        }
        throw new Exception("NEG: Bad object type");
    }

    Object not() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (this.class1 != 3) {
            throw new Exception("NOT: Bad object type");
        }
        if (((Boolean)this.arg1).booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    Object not_between() throws Exception {
        Object res = this.lt();
        if (res == null) {
            return null;
        }
        if (((Boolean)res).booleanValue()) {
            return res;
        }
        Object oper4 = this.oper2;
        this.oper2 = this.oper3;
        res = this.gt();
        this.oper2 = oper4;
        return res;
    }

    Object not_in() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            return null;
        }
        if (((HashSet)this.oper2).contains(this.arg1)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    Object or() throws Exception {
        this.computeArgument1();
        if (this.arg1 == null) {
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 != 3) {
                throw new Exception("OR: Bad object type");
            }
            if (((Boolean)this.arg2).booleanValue()) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.class1 == 3) {
            if (((Boolean)this.arg1).booleanValue()) {
                return Boolean.TRUE;
            }
            this.computeArgument2();
            if (this.arg2 == null) {
                return null;
            }
            if (this.class2 != 3) {
                throw new Exception("OR: Bad object type");
            }
            return this.arg2;
        }
        throw new Exception("OR: Bad object type");
    }

    public String print(String level) {
        String st = String.valueOf(level) + new Integer(this.operation).toString() + "(\n";
        String nextLevel = String.valueOf(level) + "  ";
        st = this.oper1 == null ? String.valueOf(st) + nextLevel + "null\n" : (this.oper1 instanceof Operator ? String.valueOf(st) + ((Operator)this.oper1).print(nextLevel) : String.valueOf(st) + nextLevel + this.oper1.toString() + "\n");
        if (this.oper2 != null) {
            st = this.oper2 instanceof Operator ? String.valueOf(st) + ((Operator)this.oper2).print(nextLevel) : String.valueOf(st) + nextLevel + this.oper2.toString() + "\n";
        }
        if (this.oper3 != null) {
            st = this.oper3 instanceof Operator ? String.valueOf(st) + ((Operator)this.oper3).print(nextLevel) : String.valueOf(st) + nextLevel + this.oper3.toString() + "\n";
        }
        st = String.valueOf(st) + level + ")\n";
        return st;
    }

    Object sub() throws Exception {
        this.computeArgument1();
        this.computeArgument2();
        if (this.arg1 == null || this.arg2 == null) {
            return null;
        }
        switch (this.class1) {
            case 1: {
                switch (this.class2) {
                    case 1: {
                        return new Double((Double)this.arg1 - (Double)this.arg2);
                    }
                    case 2: {
                        return new Double((Double)this.arg1 - ((Long)this.arg2).doubleValue());
                    }
                }
                throw new Exception("SUB: Bad object type");
            }
            case 2: {
                switch (this.class2) {
                    case 1: {
                        return new Double(((Long)this.arg1).doubleValue() - (Double)this.arg2);
                    }
                    case 2: {
                        return new Long((Long)this.arg1 - (Long)this.arg2);
                    }
                }
                throw new Exception("SUB: Bad object type");
            }
        }
        throw new Exception("SUB: Bad object type");
    }

    public String toString() {
        return this.print("");
    }
}

