/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TransactionRolledBackException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyConnectionMetaData;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyQueue;
import org.jboss.mq.SpyTemporaryQueue;
import org.jboss.mq.SpyTemporaryTopic;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSQueue;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.StateManager;

public class JMSServer {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$server$JMSServer != null ? class$org$jboss$mq$server$JMSServer : (class$org$jboss$mq$server$JMSServer = JMSServer.class$("org.jboss.mq.server.JMSServer"))));
    protected static JMSServer theInstance = new JMSServer();
    public HashMap destinations = new HashMap();
    public ThreadGroup threadGroup = new ThreadGroup("JBossMQ Server Threads");
    HashMap clientConsumers = new HashMap();
    private SynchronizedInt lastID = new SynchronizedInt(1);
    private int lastTemporaryTopic = 1;
    private int lastTemporaryQueue = 1;
    private StateManager stateManager;
    private PersistenceManager persistenceManager;
    private Object stateLock = new Object();
    private boolean alive = true;
    private boolean stopped = true;
    static /* synthetic */ Class class$org$jboss$mq$server$JMSServer;

    protected JMSServer() {
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException {
        this.acknowledge(dc, item, null);
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item, Tx txId) throws JMSException {
        ClientConsumer cc = this.getClientConsumer(dc);
        cc.acknowledge(item, txId);
    }

    public void addDestination(SpyDestination topic, JMSDestination queue) throws JMSException {
        log.debug((Object)("addDestination: " + topic + ", " + queue));
        if (this.destinations.containsKey(topic)) {
            throw new JMSException("This destination already exists !");
        }
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.put(topic, queue);
            this.destinations = newMap;
        }
    }

    public void addMessage(ConnectionToken dc, SpyMessage val) throws JMSException {
        this.addMessage(dc, val, null);
    }

    public void addMessage(ConnectionToken dc, SpyMessage val, Tx txId) throws JMSException {
        JMSDestination queue = (JMSDestination)this.destinations.get(val.getJMSDestination());
        if (queue == null) {
            throw new JMSException("This destination does not exist !");
        }
        val.setReadOnlyMode();
        queue.addMessage(val, txId);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        JMSDestination queue = (JMSDestination)this.destinations.get(dest);
        if (queue == null) {
            throw new JMSException("That destination does not exist");
        }
        if (!(queue instanceof JMSQueue)) {
            throw new JMSException("That destination is not a queue");
        }
        return ((JMSQueue)queue).browse(selector);
    }

    public void checkID(String ID) throws JMSException {
        this.stateManager.addLoggedOnClientId(ID);
    }

    public String checkUser(String userName, String password) throws JMSException {
        return this.stateManager.checkUser(userName, password);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public synchronized void connectionClosing(ConnectionToken dc) throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("JMSServer->connectionClosing(dc=" + dc + ")"));
        }
        if (dc == null) {
            return;
        }
        HashMap hashMap = this.clientConsumers;
        synchronized (hashMap) {
            ClientConsumer cq = (ClientConsumer)this.clientConsumers.remove(dc);
            if (cq != null) {
                cq.close();
            }
        }
        if (dc.getClientID() != null) {
            this.stateManager.removeLoggedOnClientId(dc.getClientID());
        }
        hashMap = this.destinations;
        synchronized (hashMap) {
            Iterator i = this.destinations.values().iterator();
            while (i.hasNext()) {
                JMSDestination sq = (JMSDestination)i.next();
                if (!dc.equals(sq.temporaryDestination)) continue;
                i.remove();
            }
        }
    }

    public void connectionFailure(ConnectionToken dc) throws JMSException {
        log.error((Object)("The connection to client " + dc.getClientID() + " failed."));
        this.connectionClosing(dc);
    }

    public synchronized Queue createQueue(ConnectionToken dc, String name) throws JMSException {
        log.debug((Object)("createQueue(" + name + ")"));
        SpyQueue newQueue = new SpyQueue(name);
        if (!this.destinations.containsKey(newQueue)) {
            throw new JMSException("This destination does not exist !");
        }
        return newQueue;
    }

    public synchronized Topic createTopic(ConnectionToken dc, String name) throws JMSException {
        log.debug((Object)("createTopic(" + name + ")"));
        SpyTopic newTopic = new SpyTopic(name);
        if (!this.destinations.containsKey(newTopic)) {
            throw new JMSException("This destination does not exist !");
        }
        return newTopic;
    }

    public synchronized void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) {
        log.debug((Object)("deleteDestination(dest=" + dest.toString() + ")"));
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.remove(dest);
            this.destinations = newMap;
        }
    }

    public void destroySubscription(DurableSubcriptionID id) throws JMSException {
        this.getStateManager().setDurableSubscription(this, id, null);
    }

    public ClientConsumer getClientConsumer(ConnectionToken dc) throws JMSException {
        ClientConsumer cq = null;
        HashMap hashMap = this.clientConsumers;
        synchronized (hashMap) {
            cq = (ClientConsumer)this.clientConsumers.get(dc);
            if (cq == null) {
                cq = new ClientConsumer(this, dc);
                this.clientConsumers.put(dc, cq);
            }
        }
        return cq;
    }

    public String getID() {
        String ID = null;
        while (true) {
            try {
                int id = this.lastID.increment();
                ID = "ID:" + id;
                this.stateManager.addLoggedOnClientId(ID);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        return ID;
    }

    public static JMSServer getInstance() {
        return theInstance;
    }

    public JMSDestination getJMSDestination(SpyDestination dest) {
        return (JMSDestination)this.destinations.get(dest);
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public synchronized TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        SpyTemporaryQueue newQueue = new SpyTemporaryQueue("JMS_TQ" + new Integer(this.lastTemporaryQueue++).toString(), dc);
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            JMSQueue queue = new JMSQueue(newQueue, ClientConsumer2, this);
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.put(newQueue, queue);
            this.destinations = newMap;
        }
        return newQueue;
    }

    public synchronized TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        SpyTemporaryTopic topic = new SpyTemporaryTopic("JMS_TT" + new Integer(this.lastTemporaryTopic++).toString(), dc);
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        HashMap hashMap = this.destinations;
        synchronized (hashMap) {
            JMSTopic queue = new JMSTopic(topic, ClientConsumer2, this);
            HashMap newMap = (HashMap)this.destinations.clone();
            newMap.put(topic, queue);
            this.destinations = newMap;
        }
        return topic;
    }

    public boolean isStopped() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = this.stopped;
            Object var3_3 = null;
            return bl;
        }
    }

    public void ping(ConnectionToken dc, long clientTime) throws JMSException {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"PING");
            }
            dc.clientIL.pong(System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new SpyJMSException("Could not pong", e);
        }
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        return ClientConsumer2.receive(subscriberId, wait);
    }

    public void restoreMessage(SpyMessage message) {
        JMSDestination queue = (JMSDestination)this.destinations.get(message.getJMSDestination());
        if (queue == null) {
            throw new RuntimeException("This destination does not exist!");
        }
        queue.restoreMessage(message);
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException {
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        ClientConsumer2.setEnabled(enabled);
        if (!enabled) {
            Iterator it = this.destinations.values().iterator();
            while (it.hasNext()) {
                ((JMSDestination)it.next()).clientConsumerStopped(ClientConsumer2);
            }
        }
    }

    public void setPersistenceManager(PersistenceManager newPersistenceManager) {
        this.persistenceManager = newPersistenceManager;
    }

    public void setStateManager(StateManager newStateManager) {
        this.stateManager = newStateManager;
    }

    public void startServer() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stopped = false;
        }
    }

    public void stopServer() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stopped = true;
            this.alive = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void subscribe(ConnectionToken dc, Subscription sub) throws JMSException {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Server: subscribe(dest=" + sub.destination + ",idConnection=" + dc.getClientID() + ")"));
            }
            ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
            ClientConsumer2.addSubscription(sub);
        }
        catch (JMSException e) {
            void ClientConsumer3;
            log.debug((Object)"Exception:", (Throwable)e);
            throw ClientConsumer3;
        }
    }

    public String toString() {
        SpyConnectionMetaData md = new SpyConnectionMetaData();
        return String.valueOf(md.getJMSProviderName()) + " version " + md.getProviderVersion();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        TxManager txManager = this.persistenceManager.getTxManager();
        if (t.requestType == 0) {
            Tx txId = txManager.createTx();
            try {
                int i;
                if (t.messages != null) {
                    i = 0;
                    while (i < t.messages.length) {
                        this.addMessage(dc, t.messages[i], txId);
                        ++i;
                    }
                }
                if (t.acks != null) {
                    i = 0;
                    while (i < t.acks.length) {
                        this.acknowledge(dc, t.acks[i], txId);
                        ++i;
                    }
                }
                txManager.commitTx(txId);
                return;
            }
            catch (JMSException e) {
                txManager.rollbackTx(txId);
                TransactionRolledBackException newE = new TransactionRolledBackException("Transaction was rolled back.");
                newE.setLinkedException((Exception)((Object)e));
                throw newE;
            }
        } else if (t.requestType == 1) {
            Tx txId = txManager.createTx(dc, t.xid);
            try {
                int i;
                if (t.messages != null) {
                    i = 0;
                    while (i < t.messages.length) {
                        this.addMessage(dc, t.messages[i], txId);
                        ++i;
                    }
                }
                if (t.acks == null) return;
                i = 0;
                while (i < t.acks.length) {
                    this.acknowledge(dc, t.acks[i], txId);
                    ++i;
                }
                return;
            }
            catch (JMSException e) {
                txManager.rollbackTx(txId);
                TransactionRolledBackException newE = new TransactionRolledBackException("Transaction was rolled back.");
                newE.setLinkedException((Exception)((Object)e));
                throw newE;
            }
        } else if (t.requestType == 3) {
            Tx txId = txManager.getPrepared(dc, t.xid);
            txManager.rollbackTx(txId);
            return;
        } else {
            if (t.requestType != 2) return;
            Tx txId = txManager.getPrepared(dc, t.xid);
            txManager.commitTx(txId);
        }
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Server: unsubscribe(idConnection=" + dc.getClientID() + ")"));
        }
        ClientConsumer ClientConsumer2 = this.getClientConsumer(dc);
        ClientConsumer2.removeSubscription(subscriptionId);
    }
}

