/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyQueue;
import org.jboss.mq.server.JMSQueue;
import org.jboss.mq.server.JMSServer;
import org.jboss.mq.server.QueueManagerMBean;
import org.jboss.util.ServiceMBeanSupport;

public class QueueManager
extends ServiceMBeanSupport
implements QueueManagerMBean {
    JMSQueue destination;
    SpyQueue queue;
    String queueName;

    public String getName() {
        return "JBossMQQueue";
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.queueName = name.getKeyProperty("name");
        if (this.queueName == null || this.queueName.length() == 0) {
            throw new MalformedObjectNameException("Property 'name' not provided");
        }
        this.log = Logger.getLogger((String)(String.valueOf(this.getClass().getName()) + "#" + this.queueName));
        return name;
    }

    public int getQueueDepth() throws Exception {
        return this.destination.queue.messages.size();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void initService() throws Exception {
        if (this.queueName == null || this.queueName.length() == 0) {
            throw new Exception("QueueName was not set");
        }
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        this.queue = new SpyQueue(this.queueName);
        this.destination = new JMSQueue(this.queue, null, server);
        try {
            server.addDestination(this.queue, this.destination);
        }
        catch (JMSException e) {
            this.log.warn((Object)("Couldn't add queue: " + e.getMessage()));
        }
    }

    public void startService() throws Exception {
        Context subctx;
        InitialContext ctx = new InitialContext();
        try {
            subctx = (Context)ctx.lookup("queue");
        }
        catch (NamingException namingException) {
            subctx = ctx.createSubcontext("queue");
        }
        subctx.rebind(this.queueName, (Object)this.queue);
    }
}

