/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.management.ObjectName;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.server.JMSServer;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.StateManagerMBean;
import org.jboss.mq.xml.XElement;
import org.jboss.mq.xml.XElementException;
import org.jboss.util.ServiceMBeanSupport;

public class StateManager
extends ServiceMBeanSupport
implements StateManagerMBean {
    XElement stateConfig;
    private HashSet loggedOnClientIds = new HashSet();
    private String stateFile = "jbossmq-state.xml";

    public void addLoggedOnClientId(String ID) throws JMSException {
        Object object = this.loggedOnClientIds;
        synchronized (object) {
            if (this.loggedOnClientIds.contains(ID)) {
                throw new InvalidClientIDException("This loggedOnClientIds is already registered !");
            }
        }
        object = this.stateConfig;
        synchronized (object) {
            Enumeration enumeration = this.stateConfig.getElementsNamed("User");
            while (enumeration.hasMoreElements()) {
                XElement element = (XElement)enumeration.nextElement();
                try {
                    if (!element.containsField("Id") || !element.getField("Id").equals(ID)) continue;
                    throw new InvalidClientIDException("This loggedOnClientIds is password protected !");
                }
                catch (XElementException xElementException) {}
            }
        }
        object = this.loggedOnClientIds;
        synchronized (object) {
            this.loggedOnClientIds.add(ID);
        }
    }

    public String checkUser(String login, String passwd) throws JMSException {
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                Enumeration enumeration = this.stateConfig.getElementsNamed("User");
                while (enumeration.hasMoreElements()) {
                    XElement element = (XElement)enumeration.nextElement();
                    String name = element.getField("Name");
                    if (!name.equals(login)) continue;
                    String pw = element.getField("Password");
                    if (!passwd.equals(pw)) {
                        throw new JMSException("Bad password");
                    }
                    String clientId = null;
                    if (element.containsField("Id")) {
                        clientId = element.getField("Id");
                    }
                    if (clientId != null) {
                        HashSet hashSet = this.loggedOnClientIds;
                        synchronized (hashSet) {
                            if (this.loggedOnClientIds.contains(clientId)) {
                                throw new JMSSecurityException("The login id has an assigned client id.  That client id is already connected to the server!");
                            }
                            this.loggedOnClientIds.add(clientId);
                        }
                    }
                    String string = clientId;
                    Object var5_12 = null;
                    return string;
                }
                throw new JMSSecurityException("This user does not exist");
            }
        }
        catch (XElementException e) {
            this.log.error((Object)e);
            throw new JMSException("Invalid server user configuration.");
        }
    }

    public String displayStateConfig() throws Exception {
        return this.stateConfig.toString();
    }

    public String getName() {
        return "JBossMQ-StateManager";
    }

    public String getStateFile() {
        return this.stateFile;
    }

    public void initDurableSubscriptions(JMSServer server) throws XElementException {
        Enumeration enumeration = this.stateConfig.getElementsNamed("User/DurableSubscription");
        while (enumeration.hasMoreElements()) {
            XElement element = (XElement)enumeration.nextElement();
            String clientId = element.getField("../Id");
            String name = element.getField("Name");
            String topicName = element.getField("TopicName");
            try {
                this.log.debug((Object)("Restarting Durable Subscription: " + clientId + "," + name + "," + topicName));
                SpyTopic topic = new SpyTopic(topicName);
                JMSTopic dest = (JMSTopic)server.getJMSDestination(topic);
                if (dest == null) {
                    this.log.warn((Object)("Subscription topic of not found: " + topicName));
                    this.log.warn((Object)("Subscription cannot be initialized: " + clientId + "," + name));
                    element.removeFromParent();
                    continue;
                }
                dest.createDurableSubscription(new DurableSubcriptionID(clientId, name));
            }
            catch (JMSException e) {
                this.log.error((Object)("Could not initialize a durable subscription for : Client Id=" + clientId + ", Name=" + name + ", Topic Name=" + topicName), (Throwable)e);
            }
        }
    }

    public void loadConfig() throws IOException, XElementException {
        URL u = new URL(this.getClass().getClassLoader().getResource("jboss.jcml"), this.stateFile);
        InputStream in = u.openStream();
        this.stateConfig = XElement.createFrom(in);
        in.close();
    }

    public void removeLoggedOnClientId(String ID) {
        HashSet hashSet = this.loggedOnClientIds;
        synchronized (hashSet) {
            this.loggedOnClientIds.remove(ID);
        }
    }

    public void saveConfig() throws IOException {
        String file = this.getClass().getClassLoader().getResource("jbossmq-state.xml").getFile();
        PrintStream stream = new PrintStream(new FileOutputStream(file));
        stream.print(this.stateConfig.toXML(true));
        stream.close();
    }

    public void setDurableSubscription(JMSServer server, DurableSubcriptionID sub, SpyTopic topic) throws JMSException {
        this.log.debug((Object)("Checking durable subscription: " + sub + ", on topic: " + topic));
        try {
            Enumeration enumeration = this.stateConfig.getElementsNamed("User");
            while (enumeration.hasMoreElements()) {
                XElement user = (XElement)enumeration.nextElement();
                if (!user.containsField("Id") || !user.getField("Id").equals(sub.getClientID())) continue;
                this.log.debug((Object)"Found a matching ClientID configuration section.");
                XElement subscription = null;
                Enumeration enum2 = user.getElementsNamed("DurableSubscription");
                while (enum2.hasMoreElements()) {
                    XElement t = (XElement)enum2.nextElement();
                    if (!t.getField("Name").equals(sub.getSubscriptionName())) continue;
                    subscription = t;
                    break;
                }
                if (subscription == null) {
                    this.log.debug((Object)"The subscription was not previously registered.");
                    if (topic == null) {
                        return;
                    }
                    JMSTopic dest = (JMSTopic)server.getJMSDestination(topic);
                    dest.createDurableSubscription(sub);
                    subscription = new XElement("DurableSubscription");
                    subscription.addField("Name", sub.getSubscriptionName());
                    subscription.addField("TopicName", topic.getName());
                    user.addElement(subscription);
                    this.saveConfig();
                } else {
                    SpyTopic prevTopic;
                    this.log.debug((Object)"The subscription was previously registered.");
                    if (topic == null) {
                        prevTopic = new SpyTopic(subscription.getField("TopicName"));
                        JMSTopic dest = (JMSTopic)server.getJMSDestination(prevTopic);
                        dest.destoryDurableSubscription(sub);
                        subscription.removeFromParent();
                        this.saveConfig();
                    } else if (!subscription.getField("TopicName").equals(topic.getName())) {
                        this.log.debug((Object)"But the topic was different, changing the subscription.");
                        prevTopic = new SpyTopic(subscription.getField("TopicName"));
                        JMSTopic dest = (JMSTopic)server.getJMSDestination(prevTopic);
                        dest.destoryDurableSubscription(sub);
                        dest = (JMSTopic)server.getJMSDestination(topic);
                        dest.createDurableSubscription(sub);
                        subscription.setField("TopicName", topic.getName());
                        this.saveConfig();
                    }
                }
                return;
            }
            throw new JMSException("ClientID '" + sub.getClientID() + "' cannot create durable subscriptions.");
        }
        catch (IOException e) {
            SpyJMSException newE = new SpyJMSException("Could not setup the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
        catch (XElementException e) {
            SpyJMSException newE = new SpyJMSException("Could not setup the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    public void setStateFile(String newStateFile) {
        this.stateFile = newStateFile;
    }

    public void startService() throws Exception {
        this.loadConfig();
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        server.setStateManager(this);
        this.initDurableSubscriptions(server);
    }

    public class Identity {
        String login;
        String passwd;
        String loggedOnClientIds;

        Identity(String login, String passwd, String loggedOnClientIds) {
            this.login = login;
            this.passwd = passwd;
            this.loggedOnClientIds = loggedOnClientIds;
        }
    }
}

