/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.server.JMSServer;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.TopicManagerMBean;
import org.jboss.util.ServiceMBeanSupport;

public class TopicManager
extends ServiceMBeanSupport
implements TopicManagerMBean,
MBeanRegistration {
    JMSTopic destination;
    SpyTopic topic;
    String topicName;

    public String getName() {
        return "JBossMQTopic";
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.topicName = name.getKeyProperty("name");
        if (this.topicName == null || this.topicName.length() == 0) {
            throw new MalformedObjectNameException("Property 'name' not provided");
        }
        return name;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void initService() throws Exception {
        if (this.topicName == null || this.topicName.length() == 0) {
            throw new Exception("TopicName was not set");
        }
        JMSServer server = (JMSServer)this.getServer().invoke(new ObjectName("JBossMQ:service=Server"), "getJMSServer", new Object[0], new String[0]);
        this.topic = new SpyTopic(this.topicName);
        this.destination = new JMSTopic(this.topic, null, server);
        server.addDestination(this.topic, this.destination);
    }

    public void startService() throws Exception {
        Context subctx;
        InitialContext ctx = new InitialContext();
        try {
            subctx = (Context)ctx.lookup("topic");
        }
        catch (NamingException namingException) {
            subctx = ctx.createSubcontext("topic");
        }
        subctx.rebind(this.topicName, (Object)this.topic);
    }
}

