/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class MethodMetaData
extends MetaData {
    public static final char HOME_METHOD = 'H';
    public static final char REMOTE_METHOD = 'R';
    public static final char LOCAL_HOME_METHOD = 'h';
    public static final char LOCAL_METHOD = 'L';
    private static final ArrayList EMPTY_PARAM_LIST = new ArrayList();
    private String methodName;
    private String ejbName;
    private boolean intf = false;
    private char methodType;
    private boolean param = false;
    private boolean unchecked = false;
    private boolean excluded = false;
    private ArrayList paramList = EMPTY_PARAM_LIST;
    private byte transactionType;
    private Set permissions;

    private static String[] getClassNames(Class[] source) {
        String[] out = new String[source.length];
        int i = 0;
        while (i < out.length) {
            String brackets = "";
            Class<?> cls = source[i];
            while (cls.isArray()) {
                brackets = String.valueOf(brackets) + "[]";
                cls = cls.getComponentType();
            }
            out[i] = String.valueOf(cls.getName()) + brackets;
            ++i;
        }
        return out;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Iterator getParams() {
        return ((AbstractList)this.paramList).iterator();
    }

    public Set getRoles() {
        return this.permissions;
    }

    public byte getTransactionType() {
        return this.transactionType;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        Element paramsElement;
        this.methodName = MetaData.getElementContent(MetaData.getUniqueChild(element, "method-name"));
        this.ejbName = MetaData.getElementContent(MetaData.getUniqueChild(element, "ejb-name"));
        Element intfElement = MetaData.getOptionalChild(element, "method-intf");
        if (intfElement != null) {
            this.intf = true;
            String methodIntf = MetaData.getElementContent(intfElement);
            if (methodIntf.equals("Home")) {
                this.methodType = (char)72;
            } else if (methodIntf.equals("Remote")) {
                this.methodType = (char)82;
            } else if (methodIntf.equals("LocalHome")) {
                this.methodType = (char)104;
            } else if (methodIntf.equals("Local")) {
                this.methodType = (char)76;
            } else {
                throw new DeploymentException("method-intf tag should be one of: 'Home', 'Remote', 'LocalHome', 'Local'");
            }
        }
        if ((paramsElement = MetaData.getOptionalChild(element, "method-params")) != null) {
            this.param = true;
            this.paramList = new ArrayList();
            Iterator paramsIterator = MetaData.getChildrenByTagName(paramsElement, "method-param");
            while (paramsIterator.hasNext()) {
                this.paramList.add(MetaData.getElementContent((Element)paramsIterator.next()));
            }
        }
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public boolean isHomeMethod() {
        return this.methodType == 'H';
    }

    public boolean isIntfGiven() {
        return this.intf;
    }

    public boolean isLocalHomeMethod() {
        return this.methodType == 'h';
    }

    public boolean isLocalMethod() {
        return this.methodType == 'L';
    }

    public boolean isParamGiven() {
        return this.param;
    }

    public boolean isRemoteMethod() {
        return this.methodType == 'R';
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public boolean patternMatches(String name, Class[] arg, boolean remote) {
        return this.patternMatches(name, MethodMetaData.getClassNames(arg), remote);
    }

    public boolean patternMatches(String name, String[] arg, boolean remote) {
        if (this.getMethodName().equals("*")) {
            return !this.isIntfGiven() || this.isRemoteMethod() == remote;
        }
        if (!this.getMethodName().equals(name)) {
            return false;
        }
        if (this.isIntfGiven() && this.isRemoteMethod() != remote) {
            return false;
        }
        if (!this.isParamGiven()) {
            return true;
        }
        return this.sameParams(arg);
    }

    private boolean sameParams(String[] arg) {
        if (arg.length != this.paramList.size()) {
            return false;
        }
        int i = 0;
        while (i < arg.length) {
            if (!arg[i].equals(this.paramList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setExcluded() {
        this.excluded = true;
    }

    public void setRoles(Set perm) {
        this.permissions = perm;
    }

    public void setTransactionType(byte type) {
        this.transactionType = type;
    }

    public void setUnchecked() {
        this.unchecked = true;
    }
}

