/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.swing.Timer;
import org.gjt.lindfors.util.BufferType;
import org.gjt.lindfors.util.Library;
import org.gjt.lindfors.util.event.BufferEvent;
import org.gjt.lindfors.util.event.BufferEventGenerator;
import org.gjt.lindfors.util.event.BufferListener;
import org.gjt.lindfors.util.support.BufferEventGeneratorSupport;

public class Buffer
implements Serializable,
ActionListener,
BufferEventGenerator {
    private static final int DEFAULT_CAPACITY = 100;
    private static final int MIN_CAPACITY = 1;
    private static final int MAX_CAPACITY = Integer.MAX_VALUE;
    private static final int MIN_LIFETIME = 1;
    private static final int DEFAULT_LIFETIME = 60000;
    private static final int TIMER_SLEEP_DELAY = 1000;
    private static final boolean NOTIFY_ALL_OPERATIONS = false;
    private int capacity = 100;
    private int numberOfElements = 0;
    private int head = 0;
    private int tail = 0;
    private Object[] array;
    private long[] timestamp;
    private BufferType bufferType;
    private Timer timer;
    private int lifetime = 60000;
    protected float increaseFactor = 2.0f;
    protected float decreaseFactor = 0.5f;
    protected float decreaseThreshold = 0.25f;
    protected boolean isCapacityDecreaseEnabled = false;
    protected BufferEventGeneratorSupport support = new BufferEventGeneratorSupport();
    private final transient boolean[] MUTEX = new boolean[0];

    public Buffer() {
        this.bufferType = BufferType.SIZE_BOUND_BUFFER;
        this.array = new Object[this.capacity];
        this.timestamp = new long[this.capacity];
    }

    public Buffer(int n) {
        this.bufferType = BufferType.SIZE_BOUND_BUFFER;
        if (n < 1) {
            n = 1;
        }
        if (n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        this.capacity = ++n;
        this.array = new Object[n];
        this.timestamp = new long[n];
    }

    public Buffer(BufferType bufferType, int n) {
        if (bufferType == BufferType.SIZE_BOUND_BUFFER) {
            this.bufferType = BufferType.SIZE_BOUND_BUFFER;
            if (n < 1) {
                this.capacity = 1;
            }
            if (n > Integer.MAX_VALUE) {
                this.capacity = Integer.MAX_VALUE;
            }
            this.capacity = ++this.capacity;
            this.array = new Object[this.capacity];
            this.timestamp = new long[this.capacity];
        } else if (bufferType == BufferType.TIMED_BUFFER) {
            this.bufferType = BufferType.TIMED_BUFFER;
            this.lifetime = n < 1 ? 1 : n;
            this.isCapacityDecreaseEnabled = true;
            this.array = new Object[100];
            this.timestamp = new long[100];
            this.timer = new Timer(1000, this);
            this.timer.start();
        } else if (bufferType == BufferType.TIMED_SIZE_BOUND_BUFFER) {
            this.bufferType = BufferType.TIMED_SIZE_BOUND_BUFFER;
            this.lifetime = n < 1 ? 1 : n;
            this.array = new Object[100];
            this.timestamp = new long[100];
            this.timer = new Timer(1000, this);
            this.timer.start();
        } else {
            throw new InternalError("Invalid type in buffer constructor.");
        }
    }

    public Buffer(int n, int n2) {
        this.bufferType = BufferType.TIMED_SIZE_BOUND_BUFFER;
        this.capacity = n < 1 ? 1 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : n);
        this.lifetime = n2 < 1 ? 1 : n2;
        this.array = new Object[n];
        this.timestamp = new long[n];
        this.timer = new Timer(1000, this);
        this.timer.start();
    }

    public boolean add(Object object) {
        if (object == null) {
            return false;
        }
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            if (this.bufferType != BufferType.SIZE_BOUND_BUFFER) {
                if (this.bufferType == BufferType.TIMED_BUFFER && this.numberOfElements == this.capacity - 1) {
                    this.setCapacity(this.increaseFactor);
                }
                this.timestamp[this.head] = System.currentTimeMillis();
            }
            this.array[this.head] = object;
            this.head = this.head >= this.capacity - 1 ? 0 : ++this.head;
            if (this.head == this.tail) {
                this.tail = this.tail == this.capacity - 1 ? 0 : ++this.tail;
            } else {
                ++this.numberOfElements;
            }
            this.array[this.head] = null;
            if (this.bufferType != BufferType.SIZE_BOUND_BUFFER) {
                this.timestamp[this.head] = -1L;
            }
        }
        return true;
    }

    private void moveHead() {
        this.head = this.head >= this.capacity - 1 ? 0 : ++this.head;
        if (this.head == this.tail) {
            this.tail = this.tail == this.capacity - 1 ? 0 : ++this.tail;
        } else {
            ++this.numberOfElements;
        }
        this.array[this.head] = null;
        this.timestamp[this.head] = -1L;
    }

    public void clear() {
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            this.head = 0;
            this.tail = 0;
            this.numberOfElements = 0;
            int n = 0;
            while (n < this.array.length) {
                this.array[n] = null;
                this.timestamp[n] = -1L;
                ++n;
            }
        }
        this.support.fireBufferCleared(this);
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            int n = 0;
            while (n < this.capacity) {
                Object object2;
                if (this.array[n] != null && object.equals(object2 = this.array[n])) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            boolean bl = this.head == this.tail;
            return bl;
        }
    }

    public boolean setCapacity(float f) {
        BufferEvent bufferEvent;
        if (f <= Float.MIN_VALUE) {
            return false;
        }
        if (Float.isNaN(f)) {
            return false;
        }
        if (Float.isInfinite(f)) {
            return false;
        }
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            int n;
            float f2 = (float)this.capacity * f;
            int n2 = this.capacity;
            int n3 = n = f2 < 2.1474836E9f ? (int)f2 : Integer.MAX_VALUE;
            if ((double)f >= 1.0 && n == this.capacity) {
                ++n;
            }
            if ((double)f < 1.0 && n == this.capacity) {
                --n;
            }
            this.capacity = n;
            if (this.capacity < 1) {
                this.capacity = 1;
            }
            Object[] objectArray = this.toArray();
            long[] lArray = new long[this.timestamp.length];
            System.arraycopy(this.timestamp, 0, lArray, 0, lArray.length);
            this.array = new Object[this.capacity];
            this.timestamp = new long[this.capacity];
            if (this.array.length < objectArray.length) {
                System.arraycopy(objectArray, 0, this.array, 0, this.array.length - 1);
                System.arraycopy(lArray, 0, this.timestamp, 0, this.timestamp.length - 1);
                this.tail = 0;
                this.head = this.array.length - 1;
                this.numberOfElements = this.array.length - 1;
            } else {
                System.arraycopy(objectArray, 0, this.array, 0, objectArray.length);
                System.arraycopy(lArray, 0, this.timestamp, 0, lArray.length);
                this.tail = 0;
                this.head = objectArray.length;
            }
            bufferEvent = BufferEventGeneratorSupport.createCapacityChangedEvent(this, this.capacity - n2);
        }
        this.support.fireCapacityChanged(bufferEvent);
        return true;
    }

    public int getCapacity() {
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            int n = this.capacity - 1;
            return n;
        }
    }

    public int getSize() {
        return this.numberOfElements;
    }

    public Object[] toArray() {
        Object[] objectArray;
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            if (this.isEmpty()) {
                Object[] objectArray2 = null;
                return objectArray2;
            }
            objectArray = new Object[this.numberOfElements];
            int n = this.tail;
            int n2 = 0;
            while (n != this.head) {
                if (this.array[n] != null) {
                    objectArray[n2++] = this.array[n];
                }
                if (n == this.capacity - 1) {
                    n = 0;
                    continue;
                }
                ++n;
            }
        }
        return objectArray;
    }

    public boolean popLast() {
        Object var1_1 = null;
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            if (this.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.head = this.head == 0 ? this.capacity - 1 : --this.head;
            --this.numberOfElements;
            this.array[this.head] = null;
            if (this.bufferType != BufferType.SIZE_BOUND_BUFFER) {
                this.timestamp[this.head] = -1L;
            }
        }
        return true;
    }

    public boolean popFirst() {
        Object var1_1 = null;
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            if (this.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.array[this.tail] = null;
            if (this.bufferType != BufferType.SIZE_BOUND_BUFFER) {
                this.timestamp[this.tail] = -1L;
            }
            this.tail = this.tail == this.capacity - 1 ? 0 : ++this.tail;
            --this.numberOfElements;
        }
        return true;
    }

    public Object getFirst() {
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            if (this.isEmpty()) {
                throw new NoSuchElementException("Buffer is empty");
            }
            Object object = this.array[this.tail];
            return object;
        }
    }

    public Object getLast() {
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            if (this.isEmpty()) {
                throw new NoSuchElementException("Buffer is empty");
            }
            if (this.head == 0) {
                Object object = this.array[this.capacity - 1];
                return object;
            }
            Object object = this.array[this.head - 1];
            return object;
        }
    }

    public BufferType getType() {
        return this.bufferType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(Library.getClassName(this));
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            stringBuffer.append(this.bufferType.getName());
            stringBuffer.append("elements=" + this.getSize() + ", ");
            stringBuffer.append("capacity=" + this.getCapacity() + ", ");
        }
        stringBuffer.append("hash=$" + Integer.toHexString(this.hashCode()).toUpperCase() + "]");
        return stringBuffer.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        long l = System.currentTimeMillis();
        boolean bl = true;
        Object var5_4 = null;
        boolean[] blArray = this.MUTEX;
        synchronized (blArray) {
            int n;
            int n2 = this.tail;
            while (bl) {
                long l2 = this.timestamp[n2];
                if (l - l2 > (long)this.lifetime) {
                    this.array[n2] = null;
                    if (this.bufferType != BufferType.SIZE_BOUND_BUFFER) {
                        this.timestamp[n2] = -1L;
                    }
                    --this.numberOfElements;
                    if (++n2 != this.head) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (this.isCapacityDecreaseEnabled && (n = (int)((float)this.capacity * this.decreaseThreshold)) > 100 && this.numberOfElements < n) {
                this.setCapacity(this.decreaseFactor);
            }
        }
    }

    public void addBufferListener(BufferListener bufferListener) {
        this.support.addBufferListener(bufferListener);
    }

    public void removeBufferListener(BufferListener bufferListener) {
        this.support.removeBufferListener(bufferListener);
    }
}

