/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util.event;

import java.util.EventObject;
import org.gjt.lindfors.util.Library;
import org.gjt.lindfors.util.TypeSupport;
import org.gjt.lindfors.util.event.BufferEventGenerator;

public class BufferEvent
extends EventObject {
    public static final Type BUFFER_CLEARED = new Type("BUFFER_CLEARED");
    public static final Type BUFFER_ELEMENT_ADDED = new Type("BUFFER_ELEMENT_ADDED");
    public static final Type BUFFER_ELEMENT_REMOVED = new Type("BUFFER_ELEMENT_REMOVED");
    public static final Type BUFFER_CAPACITY_CHANGED = new Type("BUFFER_CAPACITY_CHANGED");
    private Type type;
    private Object bufferObject = null;
    private int deltaCapacity = 0;

    public BufferEvent(BufferEventGenerator bufferEventGenerator) {
        super(bufferEventGenerator);
        this.type = BUFFER_CLEARED;
    }

    public BufferEvent(BufferEventGenerator bufferEventGenerator, int n) {
        super(bufferEventGenerator);
        this.type = BUFFER_CAPACITY_CHANGED;
        this.deltaCapacity = n;
    }

    public BufferEvent(BufferEventGenerator bufferEventGenerator, Type type, Object object) {
        super(bufferEventGenerator);
        if (type != BUFFER_ELEMENT_ADDED && type != BUFFER_ELEMENT_REMOVED) {
            throw new IllegalArgumentException("This constructor allows only creation of BUFFER_ELEMENT_ADDED and BUFFER_ELEMENT_REMOVED event types.");
        }
        this.type = type;
        this.bufferObject = object;
    }

    public Object getBufferObject() {
        return this.bufferObject;
    }

    public int getBufferCapacityChange() {
        if (this.type == BUFFER_CAPACITY_CHANGED) {
            return this.deltaCapacity;
        }
        return 0;
    }

    public String toString() {
        return Library.getClassName(this) + "[type=" + this.type.toString() + ", source=" + Library.getClassName(this.source);
    }

    public static class Type
    extends TypeSupport {
        private Type(String string) {
            super(string);
        }
    }
}

