/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.client;

import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import org.jboss.jmx.client.RMIClientConnectorImplMBean;
import org.jboss.jmx.interfaces.JMXConnectorMBean;
import org.jboss.jmx.interfaces.RMIConnector;
import org.jboss.jmx.interfaces.RMINotificationListener;
import org.jboss.jmx.server.ObjectHandler;

public class RMIClientConnectorImpl
implements JMXConnectorMBean,
RMIClientConnectorImplMBean {
    private RMIConnector mRemoteConnector;
    private Object mServer = "";
    private Hashtable mHandbackPool = new Hashtable();
    private Vector mListeners = new Vector();

    public RMIClientConnectorImpl(String pServerName) {
        this.start(pServerName);
    }

    public void addNotificationListener(ObjectName pName, NotificationListener pListener, NotificationFilter pFilter, Object pHandback) throws InstanceNotFoundException {
        try {
            Listener lRemoteListener = new Listener(pListener, pHandback, pName);
            UnicastRemoteObject.exportObject(lRemoteListener);
            this.mRemoteConnector.addNotificationListener(pName, lRemoteListener, pFilter, lRemoteListener.getHandback());
            this.mListeners.addElement(lRemoteListener);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void addNotificationListener(ObjectName pName, ObjectName pListener, NotificationFilter pFilter, Object pHandback) throws InstanceNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("A connector cannot support this method");
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.mRemoteConnector.createMBean(pClassName, pName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, ObjectName pLoaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteConnector.createMBean(pClassName, pName, pLoaderName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, ObjectName pLoaderName, Object[] pParams, String[] pSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteConnector.createMBean(pClassName, pName, pLoaderName, pParams, pSignature);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, Object[] pParams, String[] pSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.mRemoteConnector.createMBean(pClassName, pName, pParams, pSignature);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ObjectInputStream deserialize(String pClassName, ObjectName pLoaderName, byte[] pData) throws InstanceNotFoundException, OperationsException, ReflectionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Remotely this method cannot be supported");
    }

    public ObjectInputStream deserialize(String pClassName, byte[] pData) throws OperationsException, ReflectionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Remotely this method cannot be supported");
    }

    public ObjectInputStream deserialize(ObjectName pName, byte[] pData) throws InstanceNotFoundException, OperationsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Remotely this method cannot be supported");
    }

    public Object getAttribute(ObjectName pName, String pAttribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            return this.mRemoteConnector.getAttribute(pName, pAttribute);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public AttributeList getAttributes(ObjectName pName, String[] pAttributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.mRemoteConnector.getAttributes(pName, pAttributes);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getDefaultDomain() {
        try {
            return this.mRemoteConnector.getDefaultDomain();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public Integer getMBeanCount() {
        try {
            return this.mRemoteConnector.getMBeanCount();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName pName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            return this.mRemoteConnector.getMBeanInfo(pName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ObjectInstance getObjectInstance(ObjectName pName) throws InstanceNotFoundException {
        try {
            return this.mRemoteConnector.getObjectInstance(pName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getServerDescription() {
        return String.valueOf(String.valueOf(this.mServer));
    }

    public Object instantiate(String pClassName) throws ReflectionException, MBeanException {
        try {
            return this.mRemoteConnector.instantiate(pClassName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public Object instantiate(String pClassName, ObjectName pLoaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteConnector.instantiate(pClassName, pLoaderName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public Object instantiate(String pClassName, ObjectName pLoaderName, Object[] pParams, String[] pSignature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            return this.mRemoteConnector.instantiate(pClassName, pLoaderName, pParams, pSignature);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public Object instantiate(String pClassName, Object[] pParams, String[] pSignature) throws ReflectionException, MBeanException {
        try {
            return this.mRemoteConnector.instantiate(pClassName, pParams, pSignature);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public Object invoke(ObjectName pName, String pActionName, Object[] pParams, String[] pSignature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            return this.mRemoteConnector.invoke(pName, pActionName, pParams, pSignature);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return null;
        }
    }

    public boolean isAlive() {
        return this.mRemoteConnector != null;
    }

    public boolean isInstanceOf(ObjectName pName, String pClassName) throws InstanceNotFoundException {
        try {
            return this.mRemoteConnector.isInstanceOf(pName, pClassName);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isRegistered(ObjectName pName) {
        try {
            return this.mRemoteConnector.isRegistered(pName);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public Set queryMBeans(ObjectName pName, QueryExp pQuery) {
        try {
            return this.mRemoteConnector.queryMBeans(pName, pQuery);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return null;
        }
    }

    public Set queryNames(ObjectName pName, QueryExp pQuery) {
        try {
            return this.mRemoteConnector.queryNames(pName, pQuery);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ObjectInstance registerMBean(Object pObject, ObjectName pName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        try {
            return this.mRemoteConnector.registerMBean(pObject, pName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void removeNotificationListener(ObjectName pName, NotificationListener pListener) throws InstanceNotFoundException, ListenerNotFoundException {
        Iterator i = ((AbstractList)this.mListeners).iterator();
        while (i.hasNext()) {
            Object var6_5;
            Listener lListener = (Listener)i.next();
            if (!new Listener(pListener, null, pName).equals(lListener)) continue;
            try {
                try {
                    this.mRemoteConnector.removeNotificationListener(pName, lListener);
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
                var6_5 = null;
                i.remove();
            }
            catch (Throwable throwable) {
                var6_5 = null;
                i.remove();
                throw throwable;
            }
        }
    }

    public void removeNotificationListener(ObjectName pName, ObjectName pListener) throws InstanceNotFoundException, ListenerNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("A connector cannot support this method");
    }

    public void setAttribute(ObjectName pName, Attribute pAttribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.mRemoteConnector.setAttribute(pName, pAttribute);
        }
        catch (RemoteException remoteException) {}
    }

    public AttributeList setAttributes(ObjectName pName, AttributeList pAttributes) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.mRemoteConnector.setAttributes(pName, pAttributes);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void start(Object pServer) throws IllegalArgumentException {
        if (pServer == null) {
            throw new IllegalArgumentException("Server cannot be null. To close the connection use stop()");
        }
        try {
            InitialContext lNamingContext = new InitialContext();
            System.out.println("RMIClientConnectorImp.start(), got Naming Context: " + lNamingContext + ", environment: " + lNamingContext.getEnvironment() + ", name in namespace: " + lNamingContext.getNameInNamespace());
            this.mRemoteConnector = (RMIConnector)new InitialContext().lookup("jmx:" + pServer + ":rmi");
            System.err.println("RMIClientConnectorImpl.start(), got remote connector: " + this.mRemoteConnector);
            this.mServer = pServer;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        System.out.println("RMIClientConnectorImpl.stop(), start");
        Iterator i = ((AbstractList)this.mListeners).iterator();
        while (i.hasNext()) {
            try {
                Object var4_4;
                Listener lRemoteListener = (Listener)i.next();
                System.out.println("RMIClientConnectorImpl.stop(), remove listener: " + lRemoteListener);
                try {
                    try {
                        this.mRemoteConnector.removeNotificationListener(lRemoteListener.getObjectName(), lRemoteListener);
                    }
                    catch (RemoteException re) {
                        re.printStackTrace();
                    }
                    var4_4 = null;
                    i.remove();
                }
                catch (Throwable throwable) {
                    var4_4 = null;
                    i.remove();
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mRemoteConnector = null;
        this.mServer = "";
    }

    public void unregisterMBean(ObjectName pName) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.mRemoteConnector.unregisterMBean(pName);
        }
        catch (RemoteException remoteException) {}
    }

    public class Listener
    implements RMINotificationListener {
        private NotificationListener mLocalListener;
        private ObjectHandler mHandbackHandler;
        private Object mHandback;
        private ObjectName mObjectName;

        public Listener(NotificationListener pLocalListener, Object pHandback, ObjectName pName) {
            this.mLocalListener = pLocalListener;
            this.mHandback = pHandback;
            this.mHandbackHandler = new ObjectHandler(this.toString());
            this.mObjectName = pName;
        }

        public boolean equals(Object pTest) {
            if (pTest instanceof Listener) {
                return this.mLocalListener.equals(((Listener)pTest).mLocalListener);
            }
            return false;
        }

        public ObjectHandler getHandback() {
            return this.mHandbackHandler;
        }

        public NotificationListener getLocalListener() {
            return this.mLocalListener;
        }

        public ObjectName getObjectName() {
            return this.mObjectName;
        }

        public void handleNotification(Notification pNotification, Object pHandback) throws RemoteException {
            Object lHandback = this.mHandbackHandler.equals(pHandback) ? this.mHandback : pHandback;
            this.mLocalListener.handleNotification(pNotification, lHandback);
        }

        public int hashCode() {
            return this.mLocalListener.hashCode();
        }
    }
}

