/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool;

import java.util.ConcurrentModificationException;
import java.util.Date;

class ObjectRecord {
    private long created;
    private long lastUsed;
    private Object object;
    private Object clientObject;
    private boolean inUse;

    public ObjectRecord(Object ob) {
        this(ob, true);
    }

    public ObjectRecord(Object ob, boolean inUse) {
        this.created = this.lastUsed = System.currentTimeMillis();
        this.object = ob;
        this.inUse = inUse;
    }

    public void close() {
        this.object = null;
        this.clientObject = null;
        this.lastUsed = Long.MAX_VALUE;
        this.created = Long.MAX_VALUE;
        this.inUse = true;
    }

    public Object getClientObject() {
        return this.clientObject == null ? this.object : this.clientObject;
    }

    public Date getCreationDate() {
        return new Date(this.created);
    }

    public Date getLastUsedDate() {
        return new Date(this.lastUsed);
    }

    public long getMillisSinceLastUse() {
        return System.currentTimeMillis() - this.lastUsed;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setClientObject(Object o) {
        this.clientObject = o;
    }

    public synchronized void setInUse(boolean inUse) throws ConcurrentModificationException {
        if (this.inUse == inUse) {
            throw new ConcurrentModificationException();
        }
        this.inUse = inUse;
        this.lastUsed = System.currentTimeMillis();
        if (!inUse) {
            this.clientObject = null;
        }
    }

    public void setLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }
}

