/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool;

import java.util.HashSet;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.pool.ObjectPool;

class PoolGCThread
extends Thread {
    private HashSet pools = new HashSet();
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$pool$ObjectPool != null ? class$org$jboss$pool$ObjectPool : (class$org$jboss$pool$ObjectPool = PoolGCThread.class$("org.jboss.pool.ObjectPool"))));
    static /* synthetic */ Class class$org$jboss$pool$ObjectPool;

    PoolGCThread() {
        super("Minerva ObjectPool GC Thread");
        this.setDaemon(true);
    }

    synchronized void addPool(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding pool: " + pool.getName() + ", GC enabled: " + pool.isGCEnabled()));
        }
        if (pool.isGCEnabled()) {
            this.pools.add(pool);
        }
        this.notify();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private synchronized long getDelay() {
        long next = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        Iterator it = this.pools.iterator();
        while (it.hasNext()) {
            ObjectPool pool = (ObjectPool)it.next();
            long current = pool.getNextGCMillis(now);
            if (current >= next) continue;
            next = current;
        }
        return next >= 0L ? next : 0L;
    }

    synchronized void removePool(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing pool: " + pool.getName()));
        }
        this.pools.remove(pool);
    }

    public void run() {
        boolean trace = log.isTraceEnabled();
        while (true) {
            this.waitForPools();
            if (trace) {
                log.trace((Object)"gc thread waited for pools");
            }
            long delay = this.getDelay();
            if (trace) {
                log.trace((Object)("gc thread delay: " + delay));
            }
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.runGC();
        }
    }

    private synchronized void runGC() {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"GC thread running GC");
        }
        Iterator it = this.pools.iterator();
        while (it.hasNext()) {
            ObjectPool pool = (ObjectPool)it.next();
            if (trace) {
                log.trace((Object)("GC Thread pool: " + pool.getName() + ", isTimeToGC(): " + pool.isTimeToGC()));
            }
            if (!pool.isTimeToGC()) continue;
            pool.runGCandShrink();
        }
    }

    private synchronized void waitForPools() {
        while (this.pools.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                log.warn((Object)"waitForPools interrupted");
            }
        }
    }
}

