/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.cache;

import java.io.PrintWriter;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.pool.cache.CachedObjectFactory;
import org.jboss.pool.cache.ObjectCache;

public class LeastRecentlyUsedCache
implements ObjectCache {
    private Object lock = new Object();
    private HashMap keyMap = new HashMap();
    private PrintWriter log;
    private Node mostRecentNode;
    private Node leastRecentNode;
    private int size;
    private int maxSize;
    private CachedObjectFactory factory;

    public LeastRecentlyUsedCache(CachedObjectFactory factory, int maxSize) {
        this.factory = factory;
        this.maxSize = maxSize;
    }

    private Node addObject(Object key) {
        Node result;
        Object data;
        try {
            data = this.factory.createObject(key);
        }
        catch (Exception e) {
            if (this.log != null) {
                e.printStackTrace(this.log);
            }
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.mostRecentNode == null) {
                this.mostRecentNode = result = new Node(null, null, data);
                this.leastRecentNode = result;
            } else {
                this.mostRecentNode.moreRecent = result = new Node(this.mostRecentNode, null, data);
                this.mostRecentNode = result;
            }
            ++this.size;
            this.checkMaxSize();
        }
        Object value = this.keyMap.get(key);
        if (value == null) {
            this.keyMap.put(key, result);
        } else if (value instanceof LinkedList) {
            ((LinkedList)value).add(result);
        } else if (value instanceof Node) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(value);
            list.add(result);
            this.keyMap.put(key, list);
        } else {
            throw new Error("LRU Cache Assertion Failure: Wrong class '" + value.getClass().getName() + "' in keyMap!");
        }
        this.keyMap.put(result, key);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void checkMaxSize() {
        if (this.maxSize > 0) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            drop = this.leastRecentNode;
            this.leastRecentNode = drop.moreRecent;
            this.leastRecentNode.lessRecent = null;
            --this.size;
            this.removeNode(drop);
lbl8:
            // 2 sources

            ** while (this.size > this.maxSize)
        }
lbl9:
        // 1 sources

    }

    public void close() {
        Object object = this.lock;
        synchronized (object) {
            Node current = this.leastRecentNode;
            Node next = current == null ? null : current.moreRecent;
            while (current != null) {
                this.removeNode(current);
                current = next;
                Node node = next = current == null ? null : current.moreRecent;
            }
        }
    }

    public Object getObject(Object key) {
        return this.getObject(key, false);
    }

    private Object getObject(Object key, boolean use) {
        Node node = null;
        try {
            Object value = this.keyMap.get(key);
            if (value == null) {
                node = this.addObject(key);
            } else if (value instanceof Node) {
                node = (Node)value;
                if (!node.used) {
                    this.makeMostRecent(node);
                } else {
                    node = this.addObject(key);
                }
            } else if (value instanceof LinkedList) {
                Iterator it = ((LinkedList)value).iterator();
                while (it.hasNext()) {
                    node = (Node)it.next();
                    if (!node.used) {
                        this.makeMostRecent(node);
                        break;
                    }
                    node = null;
                }
                if (node == null) {
                    node = this.addObject(key);
                }
            } else {
                throw new Error("LRU Cache Assertion Failure: Wrong class '" + value.getClass().getName() + "' in keyMap!");
            }
            if (use) {
                node.setUsed(true);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return this.getObject(key, use);
        }
        return this.factory.prepareObject(node.data);
    }

    private void makeMostRecent(Node node) {
        Object object = this.lock;
        synchronized (object) {
            Node next;
            if (node.moreRecent == null) {
                if (this.mostRecentNode != node) {
                    throw new ConcurrentModificationException();
                }
                Object var3_3 = null;
                return;
            }
            Node previous = node.moreRecent;
            previous.lessRecent = next = node.lessRecent;
            if (next == null) {
                this.leastRecentNode = previous;
            } else {
                next.moreRecent = previous;
            }
            node.moreRecent = null;
            node.lessRecent = this.mostRecentNode;
            this.mostRecentNode.moreRecent = node;
            this.mostRecentNode = node;
        }
    }

    private void removeNode(Node node) {
        Object key;
        Object value;
        boolean used = node.used;
        if (!used) {
            node.used = true;
        }
        if ((value = this.keyMap.get(key = this.keyMap.remove(node))) instanceof Node) {
            this.keyMap.remove(key);
        } else if (value instanceof LinkedList) {
            LinkedList list = (LinkedList)value;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Node current = (Node)it.next();
                if (current != node) continue;
                it.remove();
                break;
            }
            if (list.size() == 1) {
                this.keyMap.put(key, list.get(0));
            }
        } else {
            throw new Error("LRU Cache Assertion Failure: Wrong class '" + value.getClass().getName() + "' in keyMap!");
        }
        if (!used) {
            this.factory.deleteObject(node.data);
        }
        node.moreRecent = null;
        node.lessRecent = null;
    }

    public void removeObjects(Object key) {
        Object object = this.lock;
        synchronized (object) {
            Object value = this.keyMap.get(key);
            if (value == null) {
                Object var3_4 = null;
                return;
            }
            if (value instanceof Node) {
                this.removeNode((Node)value);
            } else if (value instanceof LinkedList) {
                LinkedList list = (LinkedList)value;
                int max = list.size();
                int i = 0;
                while (i < max) {
                    this.removeNode((Node)list.get(0));
                    ++i;
                }
            }
        }
    }

    public void returnObject(Object key, Object value) {
        Object pooled = this.keyMap.get(key);
        Object source = this.factory.translateObject(value);
        if (pooled == null) {
            this.factory.deleteObject(source);
        } else if (pooled instanceof Node) {
            Node node = (Node)pooled;
            if (node.data == source) {
                try {
                    node.setUsed(false);
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
            } else {
                this.factory.deleteObject(source);
            }
        } else if (pooled instanceof LinkedList) {
            Iterator it = ((LinkedList)pooled).iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (node.data != source) continue;
                try {
                    node.setUsed(false);
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
                return;
            }
            this.factory.deleteObject(source);
        } else {
            throw new Error("LRU Cache Assertion Failure: Wrong class '" + pooled.getClass().getName() + "' in keyMap!");
        }
    }

    public void setSize(int maxSize) {
        this.maxSize = maxSize;
        this.checkMaxSize();
    }

    public Object useObject(Object key) {
        return this.getObject(key, true);
    }

    private class Node {
        Node lessRecent;
        Node moreRecent;
        Object data;
        boolean used = false;

        public Node(Node lessRecent, Node moreRecent, Object data) {
            this(lessRecent, moreRecent, data, false);
        }

        public Node(Node lessRecent, Node moreRecent, Object data, boolean used) {
            this.lessRecent = lessRecent;
            this.moreRecent = moreRecent;
            this.data = data;
            this.used = used;
        }

        public synchronized void setUsed(boolean used) {
            if (this.used == used) {
                throw new ConcurrentModificationException();
            }
            this.used = used;
        }
    }
}

