/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.PoolObjectFactory;
import org.jboss.pool.PoolParameters;

public class PoolManager {
    private Map pools = new HashMap();
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public void addPerFactoryPool(ManagedConnectionFactory conFactory, PoolObjectFactory poolFactory, PoolParameters params, String name) {
        this.pools.put(conFactory, new FactoryRecord(poolFactory, params, name));
    }

    public void addPerUserPool(ManagedConnectionFactory conFactory, PoolObjectFactory poolFactory, PoolParameters params, String name) {
        this.pools.put(conFactory, new UserRecord(poolFactory, params, name));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clear() {
        Iterator it = this.pools.values().iterator();
        while (it.hasNext()) {
            ((Record)it.next()).clear();
        }
        this.pools.clear();
    }

    private static ObjectPool createPool(PoolObjectFactory factory, PoolParameters params, String name) {
        ObjectPool pool = new ObjectPool(factory, name);
        pool.setBlocking(params.blocking);
        pool.setBlockingTimeout(params.blockingTimeoutSecs);
        pool.setGCEnabled(params.gcEnabled);
        pool.setGCInterval(params.gcIntervalMillis);
        pool.setGCMinIdleTime(params.gcMinIdleMillis);
        pool.setIdleTimeout(params.idleTimeoutMillis);
        pool.setIdleTimeoutEnabled(params.idleTimeoutEnabled);
        pool.setInvalidateOnError(params.invalidateOnError);
        pool.setMaxIdleTimeoutPercent(params.maxIdleTimeoutPercent);
        pool.setMaxSize(params.maxSize);
        pool.setMinSize(params.minSize);
        pool.setTimestampUsed(params.trackLastUsed);
        pool.initialize();
        return pool;
    }

    public int getFactoryCount() {
        return this.pools.size();
    }

    public ObjectPool getPool(ManagedConnectionFactory factory, Subject subject, Object connectionRequestInfo) throws ResourceException {
        Record rec = (Record)this.pools.get(factory);
        if (rec == null) {
            return null;
        }
        return rec.getPool(subject, connectionRequestInfo);
    }

    public String getPoolName(ManagedConnectionFactory factory) {
        Record rec = (Record)this.pools.get(factory);
        return rec == null ? null : rec.getName();
    }

    private static interface Record {
        public void clear();

        public String getName();

        public ObjectPool getPool(Subject var1, Object var2) throws ResourceException;
    }

    private class FactoryRecord
    implements Record {
        ObjectPool pool;

        public FactoryRecord(PoolObjectFactory factory, PoolParameters params, String name) {
            this.pool = PoolManager.createPool(factory, params, name);
        }

        public void clear() {
            this.pool.shutDown();
            this.pool = null;
        }

        public String getName() {
            return this.pool.getName();
        }

        public ObjectPool getPool(Subject subject, Object info) throws ResourceException {
            return this.pool;
        }
    }

    private class UserRecord
    implements Record {
        Map users = new HashMap();
        PoolObjectFactory factory;
        PoolParameters params;
        String name;

        public UserRecord(PoolObjectFactory factory, PoolParameters params, String name) {
            this.factory = factory;
            this.params = params;
            this.name = name;
        }

        public void clear() {
            Iterator it = this.users.values().iterator();
            while (it.hasNext()) {
                ((ObjectPool)it.next()).shutDown();
            }
            this.users.clear();
            this.users = null;
            this.factory = null;
            this.params = null;
        }

        public String getName() {
            return this.name;
        }

        public ObjectPool getPool(Subject sub, Object info) throws ResourceException {
            Object user = null;
            if (sub != null) {
                Set creds = sub.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential != null ? class$javax$resource$spi$security$PasswordCredential : (class$javax$resource$spi$security$PasswordCredential = PoolManager.class$("javax.resource.spi.security.PasswordCredential")));
                Iterator it = creds.iterator();
                if (it.hasNext()) {
                    PasswordCredential pc = (PasswordCredential)it.next();
                    user = pc.getUserName();
                }
            } else if (info != null) {
                user = info;
            }
            if (user == null) {
                throw new ResourceException("For per-user pooling, must set container-managed sign-on or provide connection parameters!");
            }
            ObjectPool pool = (ObjectPool)this.users.get(user);
            if (pool == null) {
                pool = PoolManager.createPool(this.factory, this.params, String.valueOf(this.name) + "-" + this.users.size() + ":" + user);
                this.users.put(user, pool);
            }
            return pool;
        }
    }
}

