/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.connector.BaseConnectionManager;
import org.jboss.pool.connector.ConnectionParameters;

public class SharedLocalConnectionManager
extends BaseConnectionManager
implements Serializable {
    private transient Map txConnections = new HashMap();

    public Object allocateConnection(ManagedConnectionFactory factory, ConnectionRequestInfo info) throws ResourceException {
        Transaction trans = null;
        Subject subj = null;
        ObjectPool pool = null;
        try {
            if (this.tm != null && this.tm.getStatus() != 6) {
                trans = this.tm.getTransaction();
            }
        }
        catch (SystemException systemException) {}
        if (this.sec != null) {
            subj = this.sec.getSubject(factory, this.pools.getPoolName(factory));
        }
        pool = this.pools.getPool(factory, subj, info);
        Object txCache = null;
        if (trans != null) {
            txCache = this.txConnections.get(trans);
            if (txCache instanceof TxCacheKey) {
                TxCacheKey key = (TxCacheKey)txCache;
                if (key.factory.equals((Object)factory)) {
                    key.listener.addHandle();
                    return key.connection.getConnection(subj, info);
                }
            } else if (txCache instanceof List) {
                List list = (List)txCache;
                int i = list.size() - 1;
                while (i >= 0) {
                    TxCacheKey key = (TxCacheKey)list.get(i);
                    if (key.factory.equals((Object)factory)) {
                        key.listener.addHandle();
                        return key.connection.getConnection(subj, info);
                    }
                    --i;
                }
            }
        }
        ManagedConnection con = null;
        con = pool == null ? factory.createManagedConnection(subj, info) : (ManagedConnection)pool.getObject(new ConnectionParameters(subj, info));
        BaseConnectionManager.ConnectionListener listener = null;
        if (trans != null) {
            LocalTransaction ltx = con.getLocalTransaction();
            listener = new SharedLocalConnectionListener(pool, con, trans, ltx);
            TxCacheKey newKey = new TxCacheKey(factory, con, listener);
            if (txCache == null) {
                this.txConnections.put(trans, newKey);
            } else if (txCache instanceof TxCacheKey) {
                LinkedList<TxCacheKey> list = new LinkedList<TxCacheKey>();
                list.add((TxCacheKey)txCache);
                list.add(newKey);
                this.txConnections.put(trans, list);
            } else if (txCache instanceof List) {
                List list = (List)txCache;
                list.add(newKey);
            }
        } else {
            SharedLocalConnectionManager sharedLocalConnectionManager = this;
            sharedLocalConnectionManager.getClass();
            listener = sharedLocalConnectionManager.new BaseConnectionManager.NoTransactionListener(pool, con);
        }
        try {
            listener.register();
            listener.addHandle();
        }
        catch (SystemException e) {
            throw new ApplicationServerInternalException("Unable to register Local TX with JTA TX: " + e.getMessage());
        }
        catch (RollbackException rollbackException) {
            throw new ApplicationServerInternalException("Unable to register Local TX with JTA TX: TX is rolled back.");
        }
        Object handle = con.getConnection(subj, info);
        this.connectionHandleIssued(handle, listener);
        return handle;
    }

    public void enlistExistingConnection(Object connection) throws ResourceException {
        block9: {
            Transaction trans = null;
            try {
                if (this.tm != null && this.tm.getStatus() != 6) {
                    trans = this.tm.getTransaction();
                }
            }
            catch (SystemException systemException) {}
            if (trans == null) break block9;
            BaseConnectionManager.ConnectionListener listener = (BaseConnectionManager.ConnectionListener)this.handles.get(connection);
            if (listener instanceof BaseConnectionManager.NoTransactionListener) {
                ObjectPool pool = listener.getPool();
                ManagedConnection con = listener.getManagedConnection();
                listener.clear();
                LocalTransaction local = con.getLocalTransaction();
                listener = new SharedLocalConnectionListener(pool, con, trans, local);
            } else if (listener instanceof SharedLocalConnectionListener) {
                ManagedConnection con = listener.getManagedConnection();
                LocalTransaction local = con.getLocalTransaction();
                ((SharedLocalConnectionListener)listener).updateTransaction(trans, local);
            } else {
                throw new ResourceException("Invalid connection " + connection + " for ConnectionManager " + this);
            }
            try {
                listener.enlist();
            }
            catch (Exception e) {
                ResourceException re = new ResourceException("Unable to register listeners for connection: " + e);
                re.setLinkedException(e);
            }
        }
    }

    public void shutDown() {
        this.txConnections.clear();
        this.txConnections = null;
        super.shutDown();
    }

    void transactionDone(Transaction trans) {
        this.txConnections.remove(trans);
    }

    private static class TxCacheKey {
        public ManagedConnectionFactory factory;
        public ManagedConnection connection;
        public BaseConnectionManager.ConnectionListener listener;

        public TxCacheKey(ManagedConnectionFactory factory, ManagedConnection connection, BaseConnectionManager.ConnectionListener listener) {
            this.factory = factory;
            this.connection = connection;
            this.listener = listener;
        }

        public boolean equals(Object o) {
            TxCacheKey key = (TxCacheKey)o;
            return key.factory == this.factory && key.connection == this.connection;
        }

        public int hashCode() {
            return this.factory.hashCode() ^ this.connection.hashCode();
        }
    }

    protected class SharedLocalConnectionListener
    extends BaseConnectionManager.ConnectionListener
    implements Synchronization,
    ConnectionEventListener {
        private Transaction trans;
        private LocalTransaction local;

        public SharedLocalConnectionListener(ObjectPool pool, ManagedConnection con, Transaction trans, LocalTransaction local) {
            super(pool, con);
            this.trans = trans;
            this.local = local;
            if (con == null) {
                throw new IllegalArgumentException("How can you manage a null connection?");
            }
            if (trans == null) {
                throw new IllegalArgumentException("Not allowed to use a listener when there's no transaction!");
            }
        }

        public void afterCompletion(int status) {
            if (this.local == null) {
                return;
            }
            SharedLocalConnectionManager.this.transactionDone(this.trans);
            try {
                if (status == 3) {
                    this.local.commit();
                } else {
                    this.local.rollback();
                }
            }
            catch (ResourceException e) {
                this.killConnection();
                throw new RuntimeException("Unable to complete LocalTransaction: " + e.getMessage() + " " + (e.getLinkedException() == null ? "" : e.getLinkedException().getMessage()));
            }
            if (this.getHandleCount() <= 0) {
                this.done(this.pool, this.con);
            } else {
                this.trans = null;
                this.local = null;
            }
        }

        public void beforeCompletion() {
        }

        public void clear() {
            super.clear();
            this.trans = null;
            this.local = null;
        }

        public void connectionClosed(ConnectionEvent evt) {
            SharedLocalConnectionManager.this.connectionHandleClosed(evt.getConnectionHandle());
            if (this.removeHandle() <= 0 && this.trans == null) {
                this.done(this.pool, this.con);
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            try {
                this.local.rollback();
            }
            catch (Exception exception) {}
            this.killConnection();
            this.clear();
        }

        private void done(ObjectPool pool, ManagedConnection con) {
            this.clear();
            if (pool != null) {
                pool.releaseObject(con);
            } else {
                try {
                    con.destroy();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
            }
        }

        public void enlist() throws SystemException, RollbackException {
            try {
                this.local.begin();
            }
            catch (ResourceException e) {
                SystemException se = new SystemException("Unable to start LocalTransaction: " + e.getMessage());
                throw se;
            }
            this.trans.registerSynchronization((Synchronization)this);
        }

        private void killConnection() {
            if (this.pool != null) {
                this.pool.markObjectAsInvalid(this.con);
                this.pool.releaseObject(this.con);
            } else {
                try {
                    this.con.destroy();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
            }
        }

        public void localTransactionCommitted(ConnectionEvent evt) {
        }

        public void localTransactionRolledback(ConnectionEvent evt) {
        }

        public void localTransactionStarted(ConnectionEvent evt) {
        }

        public void register() throws SystemException, RollbackException {
            this.enlist();
            this.con.addConnectionEventListener((ConnectionEventListener)this);
        }

        public void updateTransaction(Transaction trans, LocalTransaction local) {
            this.trans = trans;
            this.local = local;
        }
    }
}

