/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector;

import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.connector.BaseConnectionManager;
import org.jboss.pool.connector.ConnectionParameters;

public class XAConnectionManager
extends BaseConnectionManager
implements Serializable {
    public Object allocateConnection(ManagedConnectionFactory factory, ConnectionRequestInfo info) throws ResourceException {
        Transaction trans = null;
        Subject subj = null;
        ObjectPool pool = null;
        try {
            if (this.tm != null && this.tm.getStatus() != 6) {
                trans = this.tm.getTransaction();
            }
        }
        catch (SystemException systemException) {}
        if (this.sec != null) {
            subj = this.sec.getSubject(factory, this.pools.getPoolName(factory));
        }
        pool = this.pools.getPool(factory, subj, info);
        ManagedConnection con = null;
        con = pool == null ? factory.createManagedConnection(subj, info) : (ManagedConnection)pool.getObject(new ConnectionParameters(subj, info));
        BaseConnectionManager.ConnectionListener listener = null;
        if (trans != null) {
            XAResource xar = null;
            try {
                xar = con.getXAResource();
            }
            catch (ResourceException resourceException) {
                throw new ResourceException("Unable to get XAResource from ManagedConnection '" + con.getClass().getName() + "'.  Are you sure you shouldn't be using a non-XA ConnectionManager?");
            }
            XAConnectionManager xAConnectionManager = this;
            xAConnectionManager.getClass();
            listener = xAConnectionManager.new BaseConnectionManager.XAListener(pool, con, trans, xar);
        } else {
            XAConnectionManager xAConnectionManager = this;
            xAConnectionManager.getClass();
            listener = xAConnectionManager.new BaseConnectionManager.NoTransactionListener(pool, con);
        }
        try {
            ((BaseConnectionManager.ConnectionListener)listener).register();
            listener.addHandle();
        }
        catch (SystemException e) {
            throw new ApplicationServerInternalException("Unable to register Local TX with JTA TX: " + e.getMessage());
        }
        catch (RollbackException rollbackException) {
            throw new ApplicationServerInternalException("Unable to register Local TX with JTA TX: TX is rolled back.");
        }
        Object handle = con.getConnection(subj, info);
        this.connectionHandleIssued(handle, listener);
        return handle;
    }

    public void enlistExistingConnection(Object connection) throws ResourceException {
        block9: {
            Transaction trans = null;
            try {
                if (this.tm != null && this.tm.getStatus() != 6) {
                    trans = this.tm.getTransaction();
                }
            }
            catch (SystemException systemException) {}
            if (trans == null) break block9;
            BaseConnectionManager.ConnectionListener listener = (BaseConnectionManager.ConnectionListener)this.handles.get(connection);
            if (listener instanceof BaseConnectionManager.NoTransactionListener) {
                ObjectPool pool = listener.getPool();
                ManagedConnection con = listener.getManagedConnection();
                listener.clear();
                XAResource res = con.getXAResource();
                XAConnectionManager xAConnectionManager = this;
                xAConnectionManager.getClass();
                listener = xAConnectionManager.new BaseConnectionManager.XAListener(pool, con, trans, res);
            } else if (listener instanceof BaseConnectionManager.XAListener) {
                ManagedConnection con = listener.getManagedConnection();
                XAResource res = con.getXAResource();
                ((BaseConnectionManager.XAListener)listener).updateTransaction(trans, res);
            } else {
                throw new ResourceException("Invalid connection " + connection + " for ConnectionManager " + this);
            }
            try {
                listener.enlist();
            }
            catch (Exception e) {
                ResourceException re = new ResourceException("Unable to register listeners for connection: " + e);
                re.setLinkedException(e);
            }
        }
    }
}

