/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.jboss.pool.connector.jdbc.BaseManagedConnection;

public class XAManagedConnection
extends BaseManagedConnection {
    private XAConnection con;
    private XADataSource source;

    public XAManagedConnection(XADataSource source, XAConnection con, String user) {
        super(user);
        this.con = con;
        this.source = source;
    }

    public void cleanup() throws ResourceException {
    }

    public void destroy() throws ResourceException {
        super.destroy();
        try {
            this.con.close();
        }
        catch (SQLException e) {
            ResourceException re = new ResourceException("Unable to close DB connection: " + e);
            re.setLinkedException((Exception)e);
            throw re;
        }
        this.con = null;
        this.source = null;
    }

    public Object getConnection(Subject sub, ConnectionRequestInfo info) throws ResourceException {
        try {
            final Connection wrapper = this.con.getConnection();
            this.con.addConnectionEventListener(new ConnectionEventListener(){

                public void connectionClosed(javax.sql.ConnectionEvent evt) {
                    ConnectionEvent ce = new ConnectionEvent((ManagedConnection)XAManagedConnection.this, 1);
                    ce.setConnectionHandle((Object)wrapper);
                    XAManagedConnection.this.fireConnectionEvent(ce);
                    XAManagedConnection.this.con.removeConnectionEventListener(this);
                }

                public void connectionErrorOccurred(javax.sql.ConnectionEvent evt) {
                    ConnectionEvent ce = new ConnectionEvent((ManagedConnection)XAManagedConnection.this, 5);
                    ce.setConnectionHandle((Object)wrapper);
                    XAManagedConnection.this.fireConnectionEvent(ce);
                    XAManagedConnection.this.con.removeConnectionEventListener(this);
                }
            });
            return wrapper;
        }
        catch (SQLException e) {
            ResourceException re = new ResourceException("Unable to get XAResource: " + e);
            re.setLinkedException((Exception)e);
            throw re;
        }
    }

    XADataSource getDataSource() {
        return this.source;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new ResourceException("getLocalTransaction not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException("Method getMetaData() not yet implemented.");
    }

    public XAResource getXAResource() throws ResourceException {
        try {
            return this.con.getXAResource();
        }
        catch (SQLException e) {
            ResourceException re = new ResourceException("Unable to get XAResource: " + e);
            re.setLinkedException((Exception)e);
            throw re;
        }
    }
}

