/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jboss.pool.connector.jdbc.JDBCConnectionRequestInfo;
import org.jboss.pool.connector.jdbc.JDBCDataSource;
import org.jboss.pool.connector.jdbc.XAManagedConnection;

public class XAManagedConnectionFactory
implements ManagedConnectionFactory {
    private transient PrintWriter logger;
    private transient XADataSource source;
    private String username;
    private String password;
    private String xaDataSourceClass;
    private String xaDataSourceProperties;
    private String xaDataSourceName;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;
    static /* synthetic */ Class class$java$lang$String;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new UnsupportedOperationException("Must be used in managed mode");
    }

    public Object createConnectionFactory(ConnectionManager mgr) throws ResourceException {
        JDBCDataSource source;
        block2: {
            source = new JDBCDataSource(mgr, this);
            if (this.logger == null) break block2;
            try {
                source.setLogWriter(this.logger);
            }
            catch (SQLException sQLException) {}
        }
        return source;
    }

    public ManagedConnection createManagedConnection(Subject sub, ConnectionRequestInfo info) throws ResourceException {
        String user = this.username;
        String pw = this.password;
        if (sub != null) {
            Set creds = sub.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential != null ? class$javax$resource$spi$security$PasswordCredential : (class$javax$resource$spi$security$PasswordCredential = XAManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")));
            Iterator it = creds.iterator();
            if (it.hasNext()) {
                PasswordCredential pc = (PasswordCredential)it.next();
                user = pc.getUserName();
                pw = new String(pc.getPassword());
            }
        } else if (info != null) {
            JDBCConnectionRequestInfo jdbcInfo = (JDBCConnectionRequestInfo)info;
            user = jdbcInfo.user;
            pw = jdbcInfo.password;
        }
        try {
            XAConnection con = this.getSource().getXAConnection(user, pw);
            XAManagedConnection mc = new XAManagedConnection(this.source, con, user);
            mc.setLogWriter(this.logger);
            return mc;
        }
        catch (SQLException e) {
            throw new ResourceException("Unable to create DB XAConnection: " + e);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logger;
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XADataSource getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.xaDataSourceClass != null) {
            try {
                Class<?> cls = Class.forName(this.xaDataSourceClass);
                XADataSource xads = (XADataSource)cls.newInstance();
                Properties props = this.parseProperties();
                Iterator it = ((Hashtable)props).keySet().iterator();
                while (it.hasNext()) {
                    String name = null;
                    String value = null;
                    try {
                        name = (String)it.next();
                        value = props.getProperty(name);
                        Method meth = cls.getMethod("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), class$java$lang$String != null ? class$java$lang$String : XAManagedConnectionFactory.class$("java.lang.String"));
                        meth.invoke((Object)xads, value);
                    }
                    catch (Exception exception) {
                        if (this.logger == null) continue;
                        this.logger.println("Unable to set XADataSource property " + name + "=" + value + ":");
                    }
                }
                this.source = xads;
                return this.source;
            }
            catch (Exception e) {
                if (this.logger == null) return null;
                this.logger.println("Unable to create and initialize XADataSource:");
                e.printStackTrace(this.logger);
                return null;
            }
        }
        if (this.xaDataSourceName == null) return null;
        try {
            InitialContext ic = new InitialContext();
            this.source = (XADataSource)ic.lookup(this.xaDataSourceName);
            return this.source;
        }
        catch (Exception e) {
            if (this.logger == null) return null;
            this.logger.println("Unable to reach XADataSource in JNDI:");
            e.printStackTrace(this.logger);
            return null;
        }
    }

    public String getUserName() {
        return this.username;
    }

    public XADataSource getXADataSource() {
        return this.source;
    }

    public String getXADataSourceClass() {
        return this.xaDataSourceClass;
    }

    public String getXADataSourceJNDIName() {
        return this.xaDataSourceName;
    }

    public String getXADataSourceProperties() {
        return this.xaDataSourceProperties;
    }

    public ManagedConnection matchManagedConnections(Set cons, Subject sub, ConnectionRequestInfo info) throws ResourceException {
        String user = this.username;
        String pw = this.password;
        if (sub != null) {
            Set creds = sub.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential != null ? class$javax$resource$spi$security$PasswordCredential : (class$javax$resource$spi$security$PasswordCredential = XAManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")));
            Iterator it = creds.iterator();
            if (it.hasNext()) {
                PasswordCredential pc = (PasswordCredential)it.next();
                user = pc.getUserName();
                pw = new String(pc.getPassword());
            }
        } else if (info != null) {
            if (!(info instanceof JDBCConnectionRequestInfo)) {
                throw new ResourceException("Passed ConnectionRequestInfo class '" + info.getClass().getName() + "' to XAManagedConnectionFactory!");
            }
            JDBCConnectionRequestInfo jdbcInfo = (JDBCConnectionRequestInfo)info;
            user = jdbcInfo.user;
            pw = jdbcInfo.password;
        }
        Iterator it = cons.iterator();
        while (it.hasNext()) {
            XAManagedConnection con;
            Object unknown = it.next();
            if (!(unknown instanceof XAManagedConnection) || !(con = (XAManagedConnection)unknown).getUser().equals(user) || !con.getDataSource().equals(this.source)) continue;
            return con;
        }
        return null;
    }

    private Properties parseProperties() {
        Properties props = new Properties();
        StringTokenizer tokens = new StringTokenizer(this.xaDataSourceProperties, ";=");
        while (tokens.hasMoreTokens()) {
            String key = tokens.nextToken();
            String value = tokens.nextToken();
            ((Hashtable)props).put(key, value);
        }
        return props;
    }

    public void setLogWriter(PrintWriter writer) throws ResourceException {
        this.logger = writer;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public void setXADataSource(XADataSource source) {
        this.source = source;
    }

    public void setXADataSourceClass(String className) {
        this.xaDataSourceClass = className;
    }

    public void setXADataSourceJNDIName(String name) {
        this.xaDataSourceName = name;
    }

    public void setXADataSourceProperties(String props) {
        this.xaDataSourceProperties = props;
    }
}

